/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher.util;

import cpw.mods.jarhandling.SecureJar;
import java.lang.module.FindException;
import java.lang.module.ResolutionException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModuleExceptionEnhancer {
    private static final String NAME = "[^ ]+";
    private static final Message NOT_FOUND = new Message(1, "^Module (?<m1>[^ ]+) not found$");
    private static final Message NOT_FOUND_REQUIRED = new Message(2, "^Module (?<m1>[^ ]+) not found, required by (?<m2>[^ ]+)$");
    private static final Message SELF_REFERENCE = new Message(2, "^Module (?<m1>[^ ]+) reads another module named (?<m2>[^ ]+)$");
    private static final Message MULTIPLE = new Message(2, "^Module (?<m1>[^ ]+) reads more than one module named (?<m2>[^ ]+)$");
    private static final Message PACKAGE_NOT_FOUND = new Message(1, "^Module (?<m1>[^ ]+) does not read a module that exports (?<p1>[^ ]+)$");
    private static final Message PACKAGE_CLAIMED = new Message(3, "^Module (?<m1>[^ ]+) contains package (?<p1>[^ ]+), module (?<m2>[^ ]+) exports package (?<p2>[^ ]+) to (?<m3>[^ ]+)$");
    private static final Message PACKAGE_SAME = new Message(3, "^Modules (?<m1>[^ ]+) and (?<m2>[^ ]+) export package (?<p1>[^ ]+) to module (?<m3>[^ ]+)$");

    public static RuntimeException enhance(RuntimeException exception, SecureJar[] jars) {
        String message = exception.getMessage();
        if (exception instanceof FindException) {
            Collection<String> names = ModuleExceptionEnhancer.extractNames(message, NOT_FOUND, NOT_FOUND_REQUIRED);
            String msg = ModuleExceptionEnhancer.buildMessage(message, names, jars);
            if (msg == null) {
                return exception;
            }
            return new FindException(msg, exception);
        }
        if (exception instanceof ResolutionException) {
            Collection<String> names = message.startsWith("Cycle detected: ") ? ModuleExceptionEnhancer.extractCycle(message) : ModuleExceptionEnhancer.extractNames(message, SELF_REFERENCE, MULTIPLE, PACKAGE_NOT_FOUND, PACKAGE_CLAIMED, PACKAGE_SAME);
            String msg = ModuleExceptionEnhancer.buildMessage(message, names, jars);
            if (msg == null) {
                return exception;
            }
            return new ResolutionException(msg, exception);
        }
        return exception;
    }

    private static Collection<String> extractNames(String message, Message ... expected) {
        for (Message pattern : expected) {
            Matcher match = pattern.pattern.matcher(message);
            if (!match.matches()) continue;
            TreeSet<String> names = new TreeSet<String>();
            for (int x = 1; x <= pattern.count; ++x) {
                String name = match.group("m" + x);
                if (name == null || name.isEmpty()) continue;
                names.add(name);
            }
            return names;
        }
        return Collections.emptyList();
    }

    private static Collection<String> extractCycle(String message) {
        String[] parts;
        TreeSet<String> ret = new TreeSet<String>();
        String names = message.substring(16);
        for (String part : parts = names.split("\\s*->\\s*")) {
            ret.add(part);
        }
        return ret;
    }

    private static String buildMessage(String prefix, Collection<String> names, SecureJar[] jars) {
        TreeMap<String, String> modules = new TreeMap<String, String>();
        for (SecureJar jar : jars) {
            if (!names.isEmpty() && !names.contains(jar.name())) continue;
            Path path = jar.getPrimaryPath().getFileName();
            modules.put(jar.name(), path == null ? "null" : path.toString());
        }
        if (modules.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(prefix).append(System.lineSeparator());
        builder.append("Impacted Modules:").append(System.lineSeparator());
        for (Map.Entry entry : modules.entrySet()) {
            builder.append("\t- ").append((String)entry.getKey()).append(" (").append((String)entry.getValue()).append(")").append(System.lineSeparator());
        }
        return builder.toString();
    }

    private record Message(int count, Pattern pattern) {
        Message(int count, String pattern) {
            this(count, Pattern.compile(pattern));
        }
    }
}

