/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.Environment;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import org.jetbrains.annotations.NotNull;

public class ArgumentHandler {
    private String[] args;
    private OptionSet optionSet;
    private OptionSpec<String> profileOption;
    private OptionSpec<Path> gameDirOption;
    private OptionSpec<Path> assetsDirOption;
    private OptionSpec<Path> minecraftJarOption;
    private OptionSpec<String> launchTarget;
    private OptionSpec<String> uuidOption;

    DiscoveryData setArgs(String[] args) {
        this.args = args;
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec gameDir = parser.accepts("gameDir", "Alternative game directory").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[]{PathProperties.DIRECTORY_EXISTING})).defaultsTo((Object)Path.of(".", new String[0]), (Object[])new Path[0]);
        ArgumentAcceptingOptionSpec launchTarget = parser.accepts("launchTarget", "LauncherService target to launch").withRequiredArg();
        parser.allowsUnrecognizedOptions();
        OptionSet optionSet = parser.parse(args);
        return new DiscoveryData((Path)optionSet.valueOf((OptionSpec)gameDir), (String)optionSet.valueOf((OptionSpec)launchTarget), args);
    }

    void processArguments(Environment env, Consumer<OptionParser> parserConsumer, BiConsumer<OptionSet, BiFunction<String, OptionSet, ITransformationService.OptionResult>> resultConsumer) {
        OptionParser parser = new OptionParser();
        parser.allowsUnrecognizedOptions();
        this.profileOption = parser.accepts("version", "The version we launched with").withRequiredArg();
        this.gameDirOption = parser.accepts("gameDir", "Alternative game directory").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[]{PathProperties.DIRECTORY_EXISTING})).defaultsTo((Object)Path.of(".", new String[0]), (Object[])new Path[0]);
        this.assetsDirOption = parser.accepts("assetsDir", "Assets directory").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[]{PathProperties.DIRECTORY_EXISTING}));
        this.minecraftJarOption = parser.accepts("minecraftJar", "Path to minecraft jar").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[]{PathProperties.READABLE})).withValuesSeparatedBy(',');
        this.uuidOption = parser.accepts("uuid", "The UUID of the logging in player").withRequiredArg();
        this.launchTarget = parser.accepts("launchTarget", "LauncherService target to launch").withRequiredArg();
        parserConsumer.accept(parser);
        parser.nonOptions();
        this.optionSet = parser.parse(this.args);
        env.computePropertyIfAbsent(IEnvironment.Keys.VERSION.get(), s -> (String)this.optionSet.valueOf(this.profileOption));
        env.computePropertyIfAbsent(IEnvironment.Keys.GAMEDIR.get(), f -> (Path)this.optionSet.valueOf(this.gameDirOption));
        env.computePropertyIfAbsent(IEnvironment.Keys.ASSETSDIR.get(), f -> (Path)this.optionSet.valueOf(this.assetsDirOption));
        env.computePropertyIfAbsent(IEnvironment.Keys.LAUNCHTARGET.get(), f -> (String)this.optionSet.valueOf(this.launchTarget));
        env.computePropertyIfAbsent(IEnvironment.Keys.UUID.get(), f -> (String)this.optionSet.valueOf(this.uuidOption));
        resultConsumer.accept(this.optionSet, ArgumentHandler::optionResults);
    }

    Path[] getSpecialJars() {
        return this.optionSet.valuesOf(this.minecraftJarOption).toArray(new Path[0]);
    }

    String getLaunchTarget() {
        return (String)this.optionSet.valueOf(this.launchTarget);
    }

    private static ITransformationService.OptionResult optionResults(final String serviceName, final OptionSet set) {
        return new ITransformationService.OptionResult(){

            @Override
            public <V> V value(OptionSpec<V> option) {
                this.checkOwnership(option);
                return (V)set.valueOf(option);
            }

            @Override
            @NotNull
            public <V> List<V> values(OptionSpec<V> option) {
                this.checkOwnership(option);
                return set.valuesOf(option);
            }

            private <V> void checkOwnership(OptionSpec<V> option) {
                if (!option.options().stream().allMatch(opt -> opt.startsWith(serviceName + ".") || !opt.contains("."))) {
                    throw new IllegalArgumentException("Cannot process non-arguments");
                }
            }
        };
    }

    public String[] buildArgumentList() {
        ArrayList<String> args = new ArrayList<String>();
        ArgumentHandler.addOptionToString(this.profileOption, this.optionSet, args);
        ArgumentHandler.addOptionToString(this.gameDirOption, this.optionSet, args);
        ArgumentHandler.addOptionToString(this.assetsDirOption, this.optionSet, args);
        ArgumentHandler.addOptionToString(this.uuidOption, this.optionSet, args);
        List nonOptionList = this.optionSet.nonOptionArguments();
        args.addAll(nonOptionList.stream().map(Object::toString).toList());
        return args.toArray(new String[0]);
    }

    private static void addOptionToString(OptionSpec<?> option, OptionSet optionSet, List<String> appendTo) {
        if (optionSet.has(option)) {
            appendTo.add("--" + (String)option.options().get(0));
            appendTo.add(option.value(optionSet).toString());
        }
    }

    record DiscoveryData(Path gameDir, String launchTarget, String[] arguments) {
    }
}

