/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.ArgumentHandler;
import cpw.mods.modlauncher.Environment;
import cpw.mods.modlauncher.LaunchPluginHandler;
import cpw.mods.modlauncher.LaunchServiceHandler;
import cpw.mods.modlauncher.LogMarkers;
import cpw.mods.modlauncher.ModuleLayerHandler;
import cpw.mods.modlauncher.NameMappingServiceHandler;
import cpw.mods.modlauncher.ProtectionDomainHelper;
import cpw.mods.modlauncher.TransformStore;
import cpw.mods.modlauncher.TransformationServicesHandler;
import cpw.mods.modlauncher.TransformingClassLoader;
import cpw.mods.modlauncher.TransformingClassLoaderBuilder;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ILaunchHandlerService;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.INameMappingService;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.TypesafeMap;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Launcher {
    public static Launcher INSTANCE;
    private static final Logger LOGGER;
    private final TypesafeMap blackboard;
    private final TransformationServicesHandler transformationServicesHandler;
    private final Environment environment;
    private final TransformStore transformStore;
    private final NameMappingServiceHandler nameMappingServiceHandler;
    private final ArgumentHandler argumentHandler;
    private final LaunchServiceHandler launchService;
    private final LaunchPluginHandler launchPlugins;
    private final ModuleLayerHandler moduleLayerHandler;
    private TransformingClassLoader classLoader;

    private Launcher(boolean quiet) {
        INSTANCE = this;
        VersionInfo version = Launcher.getVersionInfo();
        if (!quiet) {
            LOGGER.info(LogMarkers.MODLAUNCHER, "ModLauncher {} starting: java version {} by {}; OS {} arch {} version {}", (Object)version.implementation(), (Object)System.getProperty("java.version"), (Object)System.getProperty("java.vendor"), (Object)System.getProperty("os.name"), (Object)System.getProperty("os.arch"), (Object)System.getProperty("os.version"));
        }
        this.moduleLayerHandler = new ModuleLayerHandler();
        this.launchService = new LaunchServiceHandler(this.moduleLayerHandler, quiet);
        this.blackboard = new TypesafeMap();
        this.environment = new Environment(this);
        this.environment.putPropertyIfAbsent(IEnvironment.Keys.MLSPEC_VERSION.get(), version.implementation());
        this.environment.putPropertyIfAbsent(IEnvironment.Keys.MLIMPL_VERSION.get(), version.specification());
        this.environment.computePropertyIfAbsent(IEnvironment.Keys.MODLIST.get(), k -> new ArrayList());
        this.environment.putPropertyIfAbsent(IEnvironment.Keys.SECURED_JARS_ENABLED.get(), ProtectionDomainHelper.canHandleSecuredJars());
        this.transformStore = new TransformStore();
        this.transformationServicesHandler = new TransformationServicesHandler(this.transformStore, this.moduleLayerHandler);
        this.argumentHandler = new ArgumentHandler();
        this.nameMappingServiceHandler = new NameMappingServiceHandler(this.moduleLayerHandler);
        this.launchPlugins = new LaunchPluginHandler(this.moduleLayerHandler);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static VersionInfo getVersionInfo() {
        Package pkg = IEnvironment.class.getPackage();
        String impl = pkg.getImplementationVersion();
        String spec = pkg.getSpecificationVersion();
        if (impl != null && spec != null) {
            return new VersionInfo(impl, spec);
        }
        Module module = IEnvironment.class.getModule();
        try (InputStream is = module.getResourceAsStream("/META-INF/MANIFEST.MF");){
            if (is == null) return new VersionInfo("0.dev", "0.dev");
            Manifest manifst = new Manifest(is);
            Attributes section = manifst.getAttributes(pkg.getName().replace('.', '/') + "/");
            if (section == null) return new VersionInfo("0.dev", "0.dev");
            impl = section.getValue("Implementation-Version");
            spec = section.getValue("Specification-Version");
            if (impl == null) return new VersionInfo("0.dev", "0.dev");
            if (spec == null) return new VersionInfo("0.dev", "0.dev");
            VersionInfo versionInfo = new VersionInfo(impl, spec);
            return versionInfo;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new VersionInfo("0.dev", "0.dev");
    }

    public static void main(String ... args) {
        Properties props = System.getProperties();
        if (props.getProperty("java.vm.name").contains("OpenJ9")) {
            System.err.printf("WARNING: OpenJ9 is detected. This is definitely unsupported and you may encounter issues and significantly worse performance.\nFor support and performance reasons, we recommend installing a temurin JVM from https://adoptium.net/\nJVM information: %s %s %s\n", props.getProperty("java.vm.vendor"), props.getProperty("java.vm.name"), props.getProperty("java.vm.version"));
        }
        LOGGER.info(LogMarkers.MODLAUNCHER, "ModLauncher running: args {}", LaunchServiceHandler.hideAccessToken(args));
        LOGGER.info(LogMarkers.MODLAUNCHER, "JVM identified as {} {} {}", (Object)props.getProperty("java.vm.vendor"), (Object)props.getProperty("java.vm.name"), (Object)props.getProperty("java.vm.version"));
        new Launcher(false).run(args);
    }

    public final TypesafeMap blackboard() {
        return this.blackboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(String ... args) {
        ArgumentHandler.DiscoveryData discoveryData = this.argumentHandler.setArgs(args);
        this.transformationServicesHandler.discoverServices(discoveryData);
        HashMap scanResults = new HashMap();
        for (ITransformationService.Resource resource : this.transformationServicesHandler.initializeTransformationServices(this.argumentHandler, this.environment, this.nameMappingServiceHandler)) {
            scanResults.computeIfAbsent(resource.target(), k -> new ArrayList()).add(resource);
        }
        for (ITransformationService.Resource resource : scanResults.getOrDefault((Object)IModuleLayerManager.Layer.PLUGIN, List.of())) {
            for (SecureJar jar : resource.resources()) {
                this.moduleLayerHandler.addToLayer(IModuleLayerManager.Layer.PLUGIN, jar);
            }
        }
        this.moduleLayerHandler.build(IModuleLayerManager.Layer.PLUGIN);
        for (ITransformationService.Resource resource : this.transformationServicesHandler.triggerScanCompletion(this.moduleLayerHandler)) {
            scanResults.computeIfAbsent(resource.target(), k -> new ArrayList()).add(resource);
        }
        ArrayList<SecureJar> gameContents = new ArrayList<SecureJar>();
        for (ITransformationService.Resource resource : scanResults.getOrDefault((Object)IModuleLayerManager.Layer.GAME, List.of())) {
            for (SecureJar jar : resource.resources()) {
                this.moduleLayerHandler.addToLayer(IModuleLayerManager.Layer.GAME, jar);
                gameContents.add(jar);
            }
        }
        this.transformationServicesHandler.initialiseServiceTransformers();
        this.launchPlugins.offerScanResultsToPlugins(gameContents);
        this.launchService.validateLaunchTarget(this.argumentHandler);
        TransformingClassLoaderBuilder transformingClassLoaderBuilder = this.launchService.identifyTransformationTargets(this.argumentHandler);
        this.classLoader = this.transformationServicesHandler.buildTransformingClassLoader(this.launchPlugins, transformingClassLoaderBuilder, this.environment, this.moduleLayerHandler);
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)((Object)this.classLoader));
            this.launchService.launch(this.argumentHandler, this.moduleLayerHandler.getLayer(IModuleLayerManager.Layer.GAME).orElseThrow(), this.classLoader, this.launchPlugins);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    public Environment environment() {
        return this.environment;
    }

    Optional<ILaunchPluginService> findLaunchPlugin(String name) {
        return this.launchPlugins.get(name);
    }

    Optional<ILaunchHandlerService> findLaunchHandler(String name) {
        return this.launchService.findLaunchHandler(name);
    }

    Optional<BiFunction<INameMappingService.Domain, String, String>> findNameMapping(String targetMapping) {
        return this.nameMappingServiceHandler.findNameTranslator(targetMapping);
    }

    public Optional<IModuleLayerManager> findLayerManager() {
        return Optional.ofNullable(this.moduleLayerHandler);
    }

    static {
        LOGGER = LogManager.getLogger();
    }

    private record VersionInfo(String implementation, String specification) {
    }
}

