/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.LogMarkers;
import cpw.mods.modlauncher.ModuleLayerHandler;
import cpw.mods.modlauncher.TransformerAuditTrail;
import cpw.mods.modlauncher.TransformingClassLoader;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.NamedPath;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import cpw.mods.modlauncher.util.ServiceLoaderUtils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public class LaunchPluginHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, ILaunchPluginService> plugins = new HashMap<String, ILaunchPluginService>();

    public LaunchPluginHandler(ModuleLayerHandler layerHandler) {
        ModuleLayer boot = layerHandler.getLayer(IModuleLayerManager.Layer.BOOT).orElseThrow();
        List<Map<String, String>> modlist = Launcher.INSTANCE == null ? null : Launcher.INSTANCE.environment().getProperty(IEnvironment.Keys.MODLIST.get()).orElseThrow(() -> new IllegalStateException("Invalid environment, Missing MODLIST"));
        Iterator<ILaunchPluginService> itr = ServiceLoader.load(boot, ILaunchPluginService.class).iterator();
        while (itr.hasNext()) {
            try {
                ILaunchPluginService srvc = itr.next();
                String file = ServiceLoaderUtils.fileNameFor(srvc.getClass());
                this.plugins.put(srvc.name(), srvc);
                if (modlist == null) continue;
                modlist.add(Map.of("name", srvc.name(), "type", "PLUGINSERVICE", "file", file));
            }
            catch (ServiceConfigurationError e) {
                LOGGER.fatal(LogMarkers.MODLAUNCHER, "Encountered serious error loading launch plugin service. Things will not work well", (Throwable)e);
            }
        }
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Found launch plugins: [{}]", new Supplier[]{() -> String.join((CharSequence)",", this.plugins.keySet())});
    }

    public Optional<ILaunchPluginService> get(String name) {
        return Optional.ofNullable(this.plugins.get(name));
    }

    public EnumMap<ILaunchPluginService.Phase, List<ILaunchPluginService>> computeLaunchPluginTransformerSet(Type className, boolean isEmpty, String reason, TransformerAuditTrail auditTrail) {
        HashSet<ILaunchPluginService> uniqueValues = new HashSet<ILaunchPluginService>();
        EnumMap<ILaunchPluginService.Phase, List<ILaunchPluginService>> phaseObjectEnumMap = new EnumMap<ILaunchPluginService.Phase, List<ILaunchPluginService>>(ILaunchPluginService.Phase.class);
        for (ILaunchPluginService plugin : this.plugins.values()) {
            for (ILaunchPluginService.Phase ph : plugin.handlesClass(className, isEmpty, reason)) {
                phaseObjectEnumMap.computeIfAbsent(ph, e -> new ArrayList()).add(plugin);
                if (!uniqueValues.add(plugin)) continue;
                plugin.customAuditConsumer(className.getClassName(), strings -> auditTrail.addPluginCustomAuditTrail(className.getClassName(), plugin, (String)strings));
            }
        }
        LOGGER.debug(LogMarkers.LAUNCHPLUGIN, "LaunchPluginService {}", new Supplier[]{() -> phaseObjectEnumMap});
        return phaseObjectEnumMap;
    }

    void offerScanResultsToPlugins(List<SecureJar> scanResults) {
        for (ILaunchPluginService p : this.plugins.values()) {
            p.addResources(scanResults);
        }
    }

    int offerClassNodeToPlugins(ILaunchPluginService.Phase phase, List<ILaunchPluginService> plugins, @Nullable ClassNode node, Type className, TransformerAuditTrail auditTrail, String reason) {
        int flags = 0;
        for (ILaunchPluginService plugin : plugins) {
            LOGGER.debug(LogMarkers.LAUNCHPLUGIN, "LauncherPluginService {} offering transform {}", (Object)plugin.name(), (Object)className.getClassName());
            int pluginFlags = plugin.processClassWithFlags(phase, node, className, reason);
            if (pluginFlags == 0) continue;
            auditTrail.addPluginAuditTrail(className.getClassName(), plugin, phase);
            LOGGER.debug(LogMarkers.LAUNCHPLUGIN, "LauncherPluginService {} transformed {} with class compute flags {}", (Object)plugin.name(), (Object)className.getClassName(), (Object)pluginFlags);
            flags |= pluginFlags;
        }
        LOGGER.debug(LogMarkers.LAUNCHPLUGIN, "Final flags state for {} is {}", (Object)className.getClassName(), (Object)flags);
        return flags;
    }

    void announceLaunch(TransformingClassLoader transformerLoader, NamedPath[] specialPaths) {
        this.plugins.forEach((name, plugin) -> plugin.initializeLaunch(clazzName -> transformerLoader.buildTransformedClassNodeFor(clazzName, (String)name), specialPaths));
    }
}

