/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.cache;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraftforge.java_provisioner.api.JavaInstall;
import net.minecraftforge.java_provisioner.api.JavaLocator;
import net.minecraftforge.java_provisioner.api.JavaProvisioner;
import net.minecraftforge.mcmaven.impl.Mavenizer;
import net.minecraftforge.util.logging.Logger;

public final class JDKCache {
    private Map<JavaLocator, List<String>> attemptedLocate = null;
    private final File root;
    private final Map<Integer, File> jdks = new HashMap<Integer, File>();
    private final JavaProvisioner disco;

    public JDKCache(File cache) {
        this.root = cache;
        this.disco = JavaLocator.disco(cache, Mavenizer.isOffline());
    }

    public File root() {
        return this.root;
    }

    public File get(int version) throws Exception {
        File ret;
        if (this.attemptedLocate == null) {
            this.attemptLocate();
        }
        if ((ret = this.jdks.get(version)) != null) {
            return ret;
        }
        try {
            ret = this.disco.provision(version).home();
        }
        catch (Exception e) {
            Mavenizer.LOGGER.error("Failed to provision JDK " + version);
            this.disco.logOutput().forEach(Mavenizer.LOGGER::error);
            e.printStackTrace(Mavenizer.LOGGER.getLog(Logger.Level.ERROR));
            if (!this.attemptedLocate.isEmpty()) {
                Mavenizer.LOGGER.error("The following errors were found trying to find existing JDKs:");
                for (Map.Entry<JavaLocator, List<String>> entry : this.attemptedLocate.entrySet()) {
                    JavaLocator locator = entry.getKey();
                    List<String> output = entry.getValue();
                    Mavenizer.LOGGER.error("Errors with locator: " + locator.getClass().getName() + " " + String.valueOf(locator));
                    output.forEach(Mavenizer.LOGGER::error);
                }
            }
            throw e;
        }
        File old = this.jdks.putIfAbsent(version, ret);
        if (old != null) {
            Mavenizer.LOGGER.error("JDKCache: Downloaded JDK " + version + " is replacing an existing download! It was probably downloaded by another thread.");
            Mavenizer.LOGGER.error("JDKCache: Old JDK: " + String.valueOf(old));
        }
        return ret;
    }

    private void attemptLocate() {
        if (this.attemptedLocate != null) {
            return;
        }
        this.attemptedLocate = Map.of();
        ArrayList<JavaLocator> locators = new ArrayList<JavaLocator>();
        locators.add(JavaLocator.home());
        locators.add(JavaLocator.gradle());
        locators.add(this.disco);
        ArrayList<JavaInstall> installs = new ArrayList<JavaInstall>();
        HashMap<JavaLocator, List<String>> errors = new HashMap<JavaLocator, List<String>>(locators.size());
        for (JavaLocator locator : locators) {
            List<JavaInstall> located = locator.findAll();
            if (located.isEmpty()) {
                errors.put(locator, locator.logOutput());
                continue;
            }
            installs.addAll(located);
        }
        this.attemptedLocate = errors;
        HashSet seen = new HashSet();
        installs.removeIf(install -> !seen.add(install.home()));
        Collections.sort(installs);
        for (JavaInstall install2 : installs) {
            if (!install2.isJdk() || install2.majorVersion() <= 0) continue;
            this.jdks.putIfAbsent(install2.majorVersion(), install2.home());
        }
    }
}

