/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.java_provisioner;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.java_provisioner.Disco;
import net.minecraftforge.java_provisioner.JavaHomeLocator;
import net.minecraftforge.java_provisioner.api.Distro;
import net.minecraftforge.java_provisioner.api.JavaInstall;
import net.minecraftforge.java_provisioner.api.JavaProvisioner;
import net.minecraftforge.java_provisioner.api.JavaProvisionerException;
import net.minecraftforge.util.os.OS;
import org.jetbrains.annotations.Nullable;

final class DiscoLocator
extends JavaHomeLocator
implements JavaProvisioner {
    private final File cache;
    private final boolean offline;

    public DiscoLocator(File cache) {
        this(cache, false);
    }

    public DiscoLocator(File cache, boolean offline) {
        this.cache = cache;
        this.offline = offline;
    }

    @Override
    public File find(int version) throws JavaProvisionerException {
        return this.findInternal(null, version).home();
    }

    @Override
    public List<JavaInstall> findAll() {
        try {
            ArrayList<JavaInstall> ret = new ArrayList<JavaInstall>();
            this.findInternal(ret, -1);
            return ret;
        }
        catch (JavaProvisionerException e) {
            this.log(e.getMessage());
            return Collections.emptyList();
        }
    }

    @Nullable
    private JavaInstall findInternal(@Nullable List<JavaInstall> results, int version) throws JavaProvisionerException {
        if (!this.cache.exists() || !this.cache.isDirectory()) {
            throw new JavaProvisionerException("Java Provisioner has not provisioned any Java installations", this.logOutput());
        }
        ArrayList<JavaInstall> found = new ArrayList<JavaInstall>();
        File[] listFiles = this.cache.listFiles();
        if (listFiles == null) {
            throw new JavaProvisionerException("Could not list contents of Disco cache: " + this.cache, this.logOutput());
        }
        for (File dir : listFiles) {
            if (!dir.isDirectory()) continue;
            this.log("Disco Cache: \"" + dir.getAbsolutePath() + "\"");
            JavaInstall install = this.fromPath(dir, version);
            if (install == null) continue;
            if (results == null) {
                return install;
            }
            found.add(install);
        }
        if (found.isEmpty()) {
            throw new JavaProvisionerException("Failed to find any Java installations from Disco cache");
        }
        results.addAll(found);
        return null;
    }

    @Override
    public JavaInstall provision(int version, @Nullable Distro distro) throws JavaProvisionerException {
        List<Disco.Package> jdks;
        Disco disco = new Disco(this.cache, this.offline){

            @Override
            protected void debug(String message) {
                DiscoLocator.this.log(message);
            }

            @Override
            protected void error(String message) {
                DiscoLocator.this.log(message);
            }
        };
        try {
            jdks = disco.getPackages(version, OS.current(), distro, Disco.Arch.CURRENT);
        }
        catch (Exception e) {
            this.log(String.format("Failed to find any JDKs from Disco for: %s%d - %s %s", new Object[]{distro != null ? distro + " " : "", version, OS.current(), Disco.Arch.CURRENT}));
            try {
                jdks = disco.getPackages(version, OS.current(), distro, null);
            }
            catch (Exception suppressed) {
                this.log(String.format("Failed to find any JDKs from Disco for: %s%d - %s ANY", new Object[]{distro != null ? distro + " " : "", version, OS.current()}));
                e.addSuppressed(suppressed);
                throw new JavaProvisionerException("Failed to provision Disco download", e, this.logOutput());
            }
        }
        this.log("Found " + jdks.size() + " download candidates");
        Disco.Package pkg = jdks.get(0);
        this.log("Selected " + pkg.distribution + ": " + pkg.filename);
        File java_home = disco.extract(pkg);
        if (java_home == null) {
            throw new JavaProvisionerException("Failed to provision Disco download: " + pkg.filename, this.logOutput());
        }
        JavaInstall ret = this.fromPath(java_home);
        if (ret == null) {
            throw new JavaProvisionerException("Failed to provision Disco download: " + pkg.filename, this.logOutput());
        }
        return ret;
    }
}

