/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.repo.mcpconfig;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.minecraftforge.mcmaven.impl.Mavenizer;
import net.minecraftforge.mcmaven.impl.cache.Cache;
import net.minecraftforge.mcmaven.impl.util.Artifact;
import net.minecraftforge.mcmaven.impl.util.Constants;
import net.minecraftforge.mcmaven.impl.util.POMBuilder;
import net.minecraftforge.mcmaven.impl.util.ProcessUtils;
import net.minecraftforge.mcmaven.impl.util.Task;
import net.minecraftforge.mcmaven.impl.util.Util;
import net.minecraftforge.srgutils.IMappingFile;
import net.minecraftforge.util.data.json.JsonData;
import net.minecraftforge.util.data.json.LauncherManifest;
import net.minecraftforge.util.data.json.MinecraftVersion;
import net.minecraftforge.util.download.DownloadUtils;
import net.minecraftforge.util.file.FileUtils;
import net.minecraftforge.util.hash.HashStore;

public class MinecraftTasks {
    private final Cache cache;
    private final File cacheRoot;
    private final String version;
    public final Task launcherManifest;
    public final Task versionJson;
    private final Map<String, Task> versionFiles = new HashMap<String, Task>();
    private Task mergeMappings;
    private Task renameClient;
    private Task renameServer;
    private Task clientPom;
    private Task serverPom;

    MinecraftTasks(Cache cache, String version, Task launcherManifest) {
        this.cache = cache;
        this.cacheRoot = new File(new File(this.cache.root(), "minecraft_tasks"), version);
        this.version = version;
        this.launcherManifest = launcherManifest;
        this.versionJson = Task.named("downloadVersionJson[" + version + "]", Task.deps(this.launcherManifest), this::downloadVersionJson);
    }

    public String getVersion() {
        return this.version;
    }

    private File downloadVersionJson() {
        File target = new File(this.cacheRoot, "version.json");
        File manifestF = this.launcherManifest.execute();
        HashStore cache = HashStore.fromFile(target);
        cache.add("manifest", manifestF);
        if (target.exists() && cache.isSame()) {
            return target;
        }
        if (Mavenizer.isCacheOnly()) {
            Mavenizer.assertNotCacheOnly();
        }
        if (Mavenizer.isOffline() && target.exists()) {
            return target;
        }
        Mavenizer.assertOnline();
        LauncherManifest manifest = JsonData.launcherManifest(manifestF);
        URL url = manifest.getUrl(this.version);
        if (url == null) {
            throw new IllegalStateException("Failed to find url for " + this.version + " version.json");
        }
        try {
            DownloadUtils.downloadFile(target, url.toExternalForm());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to download " + String.valueOf(url), e);
        }
        cache.save();
        return target;
    }

    public Task versionFile(Files file) {
        return this.versionFile(file.key, file.ext);
    }

    public Task versionFile(String key, String ext) {
        return this.versionFiles.computeIfAbsent(key, string -> Task.named("download[" + this.version + "][" + key + "]", Task.deps(this.versionJson), () -> this.downloadVersionFile(key, ext)));
    }

    private File downloadVersionFile(String key, String ext) {
        File target = new File(this.cacheRoot, key + "." + ext);
        File manifestF = this.versionJson.execute();
        HashStore cache = HashStore.fromFile(target);
        cache.add("manifest", manifestF);
        if (target.exists() && cache.isSame()) {
            return target;
        }
        Mavenizer.assertNotCacheOnly();
        Mavenizer.assertOnline();
        MinecraftVersion manifest = JsonData.minecraftVersion(manifestF);
        MinecraftVersion.Download dl = manifest.getDownload(key);
        if (dl == null || dl.url == null) {
            throw new IllegalStateException("Missing '" + key + "' from " + manifestF.getAbsolutePath());
        }
        try {
            DownloadUtils.downloadFile(target, dl.url.toExternalForm());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to download " + String.valueOf(dl.url), e);
        }
        cache.save();
        return target;
    }

    public Task mergeMappings() {
        if (this.mergeMappings == null) {
            this.mergeMappings = Task.named("merge_mappings[" + this.version + "]", Task.deps(this.versionFile(Files.CLIENT_MAPPINGS), this.versionFile(Files.SERVER_MAPPINGS)), this::mergeMappingsImpl);
        }
        return this.mergeMappings;
    }

    private File mergeMappingsImpl() {
        Task clientTask = this.versionFile(Files.CLIENT_MAPPINGS);
        Task serverTask = this.versionFile(Files.SERVER_MAPPINGS);
        File output = new File(this.cacheRoot, "joined_mappings.tsrg.gz");
        File client = clientTask.execute();
        File server = serverTask.execute();
        HashStore cache = HashStore.fromFile(output).add(client, server);
        if (output.exists() && cache.isSame()) {
            return output;
        }
        Mavenizer.assertNotCacheOnly();
        try {
            IMappingFile off2obfClient = IMappingFile.load(client);
            IMappingFile off2obfServer = IMappingFile.load(server);
            IMappingFile off2obf = off2obfClient.merge(off2obfServer);
            off2obf.write(output.toPath(), IMappingFile.Format.TSRG2, false);
        }
        catch (IOException e) {
            Util.sneak(e);
        }
        cache.save();
        return output;
    }

    public Task renameClient() {
        if (this.renameClient == null) {
            Task jar = this.versionFile(Files.CLIENT_JAR);
            Task map = this.versionFile(Files.CLIENT_MAPPINGS);
            this.renameClient = Task.named("rename[" + this.version + "][client]", Task.deps(jar, map), () -> this.renameJar("client", jar, map));
        }
        return this.renameClient;
    }

    public Task renameServer() {
        if (this.renameServer == null) {
            Task jar = this.versionFile(Files.SERVER_JAR);
            Task map = this.versionFile(Files.SERVER_MAPPINGS);
            this.renameServer = Task.named("rename[" + this.version + "][server]", Task.deps(jar, map), () -> this.renameJar("server", jar, map));
        }
        return this.renameServer;
    }

    private File renameJar(String name, Task jarTask, Task mapTask) {
        File jdk;
        File tool = this.cache.maven().download(Constants.RENAMER);
        File output = new File(this.cacheRoot, name + "-official.jar");
        File log = new File(this.cacheRoot, name + "-official.log");
        File mappings = mapTask.execute();
        File jar = jarTask.execute();
        HashStore cache = HashStore.fromFile(output);
        cache.add("tool", tool);
        cache.add("mappings", mappings);
        cache.add("input", jar);
        if (output.exists() && cache.isSame()) {
            return output;
        }
        Mavenizer.assertNotCacheOnly();
        List<String> args = List.of("--input", jar.getAbsolutePath(), "--output", output.getAbsolutePath(), "--reverse", "--map", mappings.getAbsolutePath(), "--ann-fix", "--record-fix", "--src-fix", "--strip-sigs", "--disable-abstract-param");
        try {
            jdk = this.cache.jdks().get(8);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to find JDK for version 8", e);
        }
        ProcessUtils.Result ret = ProcessUtils.runJar(jdk, log.getParentFile(), log, tool, Collections.emptyList(), args);
        if (ret.exitCode != 0) {
            throw new IllegalStateException("Failed to rename jar file, See log: " + log.getAbsolutePath());
        }
        cache.save();
        return output;
    }

    public Task clientPom() {
        if (this.clientPom == null) {
            this.clientPom = Task.named("pom[" + this.version + "][client]", Task.deps(this.versionJson), this::clientPomImpl);
        }
        return this.clientPom;
    }

    private File clientPomImpl() {
        File output = new File(this.cacheRoot, "client.pom");
        File json = this.versionJson.execute();
        HashStore cache = HashStore.fromFile(output).add("json", json);
        if (output.exists() && cache.isSame()) {
            return output;
        }
        Mavenizer.assertNotCacheOnly();
        MinecraftVersion meta = JsonData.minecraftVersion(json);
        POMBuilder builder = new POMBuilder("net.minecraft", "client", this.version).preferGradleModule().dependencies(deps -> {
            for (MinecraftVersion.Library lib : meta.libraries) {
                deps.add(Artifact.from(lib.name));
            }
        });
        FileUtils.ensureParent(output);
        try (FileOutputStream os = new FileOutputStream(output);){
            os.write(builder.build().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            Util.sneak(e);
        }
        cache.save();
        return output;
    }

    public Task serverPom() {
        if (this.serverPom == null) {
            this.serverPom = Task.named("pom[" + this.version + "][server]", Task.deps(this.versionFile(Files.SERVER_JAR)), this::serverPomImpl);
        }
        return this.serverPom;
    }

    private File serverPomImpl() {
        File output = new File(this.cacheRoot, "client.pom");
        File jarFile = this.versionFile(Files.SERVER_JAR).execute();
        HashStore cache = HashStore.fromFile(output).add("jar", jarFile);
        if (output.exists() && cache.isSame()) {
            return output;
        }
        Mavenizer.assertNotCacheOnly();
        List<Artifact> libs = MinecraftTasks.listBundleArtifacts(jarFile);
        POMBuilder builder = new POMBuilder("net.minecraft", "server", this.version).preferGradleModule().dependencies(deps -> libs.forEach(deps::add));
        FileUtils.ensureParent(output);
        try (FileOutputStream os = new FileOutputStream(output);){
            os.write(builder.build().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            Util.sneak(e);
        }
        cache.save();
        return output;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<Artifact> listBundleArtifacts(File bundle) {
        try (JarFile jar = new JarFile(bundle);){
            String line;
            String format = jar.getManifest().getMainAttributes().getValue("Bundler-Format");
            if (format == null) {
                List<Artifact> list = List.of();
                return list;
            }
            if (!"1.0".equals(format)) {
                throw new RuntimeException("Invalid bundle: `" + String.valueOf(bundle) + "` - Unsupported format " + format);
            }
            ZipEntry entry = jar.getEntry("META-INF/libraries.list");
            if (entry == null) {
                throw new IllegalStateException("Invalid bundle: `" + String.valueOf(bundle) + "` - Missing META-INF/libraries.list");
            }
            ArrayList<Artifact> ret = new ArrayList<Artifact>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(jar.getInputStream(entry)));
            while ((line = reader.readLine()) != null) {
                String[] pts = line.split("\t");
                if (pts.length < 3) {
                    throw new IllegalStateException("Invalid bundle: `" + String.valueOf(bundle) + "` - Invalid line: " + line);
                }
                ret.add(Artifact.from(pts[1]));
            }
            ArrayList<Artifact> arrayList = ret;
            return arrayList;
        }
        catch (IOException e) {
            return (List)Util.sneak(e);
        }
    }

    public static enum Files {
        CLIENT_JAR("client", "jar"),
        CLIENT_MAPPINGS("client_mappings", "txt"),
        SERVER_JAR("server", "jar"),
        SERVER_MAPPINGS("server_mappings", "txt");

        public final String key;
        public final String ext;

        private Files(String key, String ext) {
            this.key = key;
            this.ext = ext;
        }
    }
}

