/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.repo.forge;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraftforge.mcmaven.impl.util.ComparableVersion;
import org.jetbrains.annotations.Nullable;

public enum FGVersion {
    v1_1("1.1"),
    v1_2("1.2"),
    v2("2.0"),
    v2_1("2.1"),
    v2_2("2.2"),
    v2_3("2.3"),
    v3("3"),
    v4("4"),
    v5("5"),
    v6("6");

    private final ComparableVersion comp;
    private static final TreeMap<FGVersion, ComparableVersion> FORGE_TO_FG;
    private static final List<SpecialCase> SPECIAL_CASES;

    private FGVersion(String ver) {
        this.comp = new ComparableVersion(ver);
    }

    public String toString() {
        return this.comp.toString();
    }

    private static void forge(FGVersion fg, String forge) {
        FORGE_TO_FG.put(fg, new ComparableVersion(forge));
    }

    private static SpecialCase special(FGVersion fg, String start, String end) {
        return new SpecialCase(fg, new ComparableVersion(start), new ComparableVersion(end));
    }

    @Nullable
    public static FGVersion fromForge(String version) {
        ComparableVersion ver = new ComparableVersion(version);
        for (SpecialCase specialCase : SPECIAL_CASES) {
            if (ver.compareTo(specialCase.start) < 0 || ver.compareTo(specialCase.end()) >= 0) continue;
            return specialCase.version;
        }
        for (Map.Entry entry : FORGE_TO_FG.entrySet()) {
            if (((ComparableVersion)entry.getValue()).compareTo(ver) > 0) continue;
            return (FGVersion)((Object)entry.getKey());
        }
        return null;
    }

    static {
        FORGE_TO_FG = new TreeMap(Comparator.reverseOrder());
        FGVersion.forge(v1_1, "1.7.2-10.12.0.967");
        FGVersion.forge(v1_2, "1.7.2-10.12.0.1048");
        FGVersion.forge(v2, "1.8-11.14.3.1503");
        FGVersion.forge(v2_1, "1.8.8-11.14.4.1583");
        FGVersion.forge(v2_2, "1.9.4-12.17.0.1908");
        FGVersion.forge(v2_3, "1.12-14.21.0.2320");
        FGVersion.forge(v3, "1.13.2-25.0.9");
        FGVersion.forge(v4, "1.16.5-36.1.66");
        FGVersion.forge(v5, "1.19-41.0.7");
        FGVersion.forge(v6, "1.19.2-43.3.5");
        SPECIAL_CASES = List.of(FGVersion.special(v3, "1.12.2-14.23.5.2851", "1.12.3"));
    }

    private record SpecialCase(FGVersion version, ComparableVersion start, ComparableVersion end) {
    }
}

