/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.mappings;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraftforge.util.data.json.JsonData;

class ParchmentData {
    String version;
    List<Package> packages;
    List<Clazz> classes;
    transient Map<String, Package> packageMap;
    transient Map<String, Clazz> classMap;

    ParchmentData() {
    }

    public static ParchmentData load(InputStream stream) {
        return JsonData.fromJson(stream, ParchmentData.class);
    }

    void bake() {
        this.packageMap = this.packages == null ? Collections.emptyMap() : this.packages.stream().collect(Collectors.toMap(p -> p.name, Function.identity()));
        if (this.classes == null) {
            this.classMap = Collections.emptyMap();
        } else {
            this.classMap = new HashMap<String, Clazz>();
            for (Clazz cls : this.classes) {
                this.classMap.put(cls.name, cls);
                cls.bake();
            }
        }
    }

    static class Clazz
    extends Element {
        List<Field> fields;
        List<Method> methods;
        transient Map<String, Field> fieldMap;
        transient Map<String, Method> methodMap;

        Clazz() {
        }

        void bake() {
            this.fieldMap = this.fields == null ? Collections.emptyMap() : this.fields.stream().collect(Collectors.toMap(p -> p.name, Function.identity()));
            if (this.methods == null) {
                this.methodMap = Collections.emptyMap();
            } else {
                this.methodMap = new HashMap<String, Method>();
                for (Method mtd : this.methods) {
                    this.methodMap.put(mtd.name + mtd.descriptor, mtd);
                    mtd.bake();
                }
            }
        }
    }

    static class Package
    extends Element {
        Package() {
        }
    }

    static class Parameter {
        int index;
        String name;
        String javadoc;

        Parameter() {
        }
    }

    static class Method
    extends Element {
        String descriptor;
        List<Parameter> parameters;
        transient Map<Integer, Element> paramMap;

        Method() {
        }

        void bake() {
            if (this.parameters == null) {
                this.paramMap = Collections.emptyMap();
            } else {
                this.paramMap = new HashMap<Integer, Element>();
                for (Parameter param : this.parameters) {
                    this.paramMap.put(param.index, new Element(param.name, param.javadoc == null ? null : List.of(param.javadoc)));
                }
            }
        }
    }

    static class Field
    extends Element {
        String descriptor;

        Field() {
        }
    }

    static class Element {
        String name;
        List<String> javadoc;

        public Element() {
        }

        private Element(String name, List<String> javadoc) {
            this.name = name;
            this.javadoc = javadoc;
        }
    }
}

