/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.repo.forge;

import io.codechicken.diffpatch.cli.CliOperation;
import io.codechicken.diffpatch.cli.PatchOperation;
import io.codechicken.diffpatch.util.Input;
import io.codechicken.diffpatch.util.LogLevel;
import io.codechicken.diffpatch.util.Output;
import io.codechicken.diffpatch.util.PatchMode;
import io.codechicken.diffpatch.util.archiver.ArchiveFormat;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.mcmaven.impl.Mavenizer;
import net.minecraftforge.mcmaven.impl.cache.Cache;
import net.minecraftforge.mcmaven.impl.cache.JDKCache;
import net.minecraftforge.mcmaven.impl.cache.MavenCache;
import net.minecraftforge.mcmaven.impl.repo.forge.ForgeRepo;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCP;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPSide;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPTaskFactory;
import net.minecraftforge.mcmaven.impl.util.Artifact;
import net.minecraftforge.mcmaven.impl.util.Constants;
import net.minecraftforge.mcmaven.impl.util.ProcessUtils;
import net.minecraftforge.mcmaven.impl.util.Task;
import net.minecraftforge.mcmaven.impl.util.Util;
import net.minecraftforge.util.data.json.JsonData;
import net.minecraftforge.util.data.json.PatcherConfig;
import net.minecraftforge.util.file.FileUtils;
import net.minecraftforge.util.hash.HashFunction;
import net.minecraftforge.util.hash.HashStore;
import org.jetbrains.annotations.Nullable;

public class Patcher
implements Supplier<Task> {
    private final File build;
    private final ForgeRepo forge;
    private final Artifact name;
    private final File data;
    private final String dataHash;
    public final PatcherConfig.V2 config;
    private final Patcher parent;
    @Nullable
    private final MCP mcp;
    @Nullable
    private final MCPSide mcpSide;
    private final Map<String, Task> extracts = new HashMap<String, Task>();
    private final Task downloadSources;
    private final Task predecomp;
    private final Task last;

    Patcher(File build, ForgeRepo forge, Artifact name) {
        Task last;
        Task predecomp;
        this.build = build;
        this.forge = forge;
        this.name = name;
        this.data = this.forge.getCache().maven().download(name);
        if (!this.data.exists()) {
            throw new IllegalStateException("Failed to download " + String.valueOf(name));
        }
        this.dataHash = HashFunction.SHA1.sneakyHash(this.data);
        this.config = this.loadConfig(this.data);
        this.validateConfig();
        this.downloadSources = this.config.sources == null ? null : Task.named("downloadSources", () -> {
            Artifact art = Artifact.from(this.config.sources);
            File ret = this.forge.getCache().maven().download(art);
            if (ret == null) {
                throw this.except("Failed to download sources " + String.valueOf(art));
            }
            return ret;
        });
        if (this.config.hasParent()) {
            this.parent = new Patcher(build, this.forge, Artifact.from(this.config.getParent()));
            this.mcp = null;
            this.mcpSide = null;
            predecomp = this.parent.predecomp;
            last = this.parent.last;
        } else {
            this.parent = null;
            this.mcp = this.forge.mcpconfig.get(Artifact.from(this.config.getParent()));
            this.mcpSide = this.mcp.getSide("joined");
            predecomp = this.mcpSide.getTasks().getPreDecompile();
            last = this.mcpSide.getTasks().getLastTask();
        }
        Stack<Patcher> stack = new Stack<Patcher>();
        stack.add(this);
        File ats = this.extractATs();
        File sass = this.extractSASs();
        if (ats != null || sass != null) {
            Task tmp;
            String mcpver = this.getMCP().getName().getVersion();
            String hash = Util.hash(HashFunction.SHA1, ats, sass);
            File dir = new File(this.forge.globalBuild, "mcp/" + mcpver + "/" + this.name.getName() + "/" + hash);
            Cache cache = this.forge.getCache();
            if (ats != null) {
                tmp = predecomp;
                predecomp = Task.named("modifyAccess", Task.deps(tmp), () -> Patcher.modifyAccess(dir, tmp, ats, cache));
            }
            if (sass != null) {
                tmp = predecomp;
                predecomp = Task.named("stripSides", Task.deps(tmp), () -> Patcher.stripSides(dir, tmp, sass, cache));
            }
            last = this.completeMcp(dir, predecomp);
            stack = this.getStack();
        }
        this.predecomp = predecomp;
        while (!stack.isEmpty()) {
            File root;
            Patcher patcher = (Patcher)stack.pop();
            File file = root = patcher == this ? this.build : new File(this.build, "parent-" + patcher.name.getName());
            if (patcher.config.processor != null) {
                last = patcher.postProcess(last, root);
            }
            if (patcher.config.patches != null) {
                last = patcher.patch(last, root);
            }
            if (patcher.config.sources == null) continue;
            last = patcher.injectSources(last, root);
        }
        this.last = last;
    }

    private RuntimeException except(String message) {
        return new IllegalArgumentException("Invalid Patcher Dependency: " + String.valueOf(this.name) + " - " + message);
    }

    private RuntimeException except(String message, Throwable e) {
        return new IllegalArgumentException("Invalid Patcher Dependency: " + String.valueOf(this.name) + " - " + message, e);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PatcherConfig.V2 loadConfig(File data) {
        try (ZipFile zip = new ZipFile(data);){
            ZipEntry entry = zip.getEntry("config.json");
            if (entry == null) {
                throw this.except("Missing config.json");
            }
            byte[] cfg_data = zip.getInputStream(entry).readAllBytes();
            int spec = JsonData.configSpec(cfg_data);
            if (spec == 1) {
                PatcherConfig.V2 v2 = new PatcherConfig.V2(JsonData.patcherConfig(cfg_data));
                return v2;
            }
            if (spec != 2) throw this.except("Unknown Spec: " + spec);
            PatcherConfig.V2 v2 = JsonData.patcherConfigV2(cfg_data);
            return v2;
        }
        catch (IOException e) {
            throw this.except("Error reading config", e);
        }
    }

    private void validateConfig() {
        if (this.config.parent == null && this.config.mcp == null) {
            throw this.except("Missing parent or mcp entry");
        }
    }

    public MCP getMCP() {
        return this.mcp == null ? this.parent.getMCP() : this.mcp;
    }

    public MCPSide getMCPSide() {
        return this.mcpSide == null ? this.parent.getMCPSide() : this.mcpSide;
    }

    public String getDataHash() {
        return this.dataHash;
    }

    public void forAllLibraries(Consumer<Artifact> consumer) {
        this.forAllLibraries(consumer, null);
    }

    public void forAllLibraries(Consumer<Artifact> consumer, Predicate<Artifact> filter) {
        this.forAllLibrariesInternal(consumer, filter, this.getMCPSide().getMCLibraries());
        this.forAllLibrariesInternal(consumer, filter, this.getMCPSide().getMCPConfigLibraries());
        this.forAllLibrariesInternal(consumer, filter, this.getArtifacts());
    }

    private void forAllLibrariesInternal(Consumer<? super Artifact> consumer, @Nullable Predicate<? super Artifact> filter, Iterable<? extends Artifact> libraries) {
        for (Artifact artifact : libraries) {
            if (filter != null && !filter.test(artifact)) continue;
            consumer.accept(artifact);
        }
    }

    public List<Artifact> getArtifacts() {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (String lib : this.config.libraries) {
            Artifact artifact = Artifact.from(lib);
            artifacts.add(artifact);
        }
        return artifacts;
    }

    public List<File> getClasspath() {
        ArrayList<File> classpath = new ArrayList<File>();
        for (MCPTaskFactory.Lib lib : this.getMCP().getSide("joined").getTasks().getLibraries()) {
            classpath.add(lib.file());
        }
        Cache cache = this.forge.getCache();
        for (String lib : this.getMCP().getConfig().getLibraries("joined")) {
            classpath.add(Patcher.getArtifact(cache, lib));
        }
        for (String lib : this.config.libraries) {
            classpath.add(Patcher.getArtifact(cache, lib));
        }
        return classpath;
    }

    private static final File getArtifact(Cache cache, String coords) {
        Artifact artifact = Artifact.from(coords);
        if ("net.minecraft".equals(artifact.getGroup())) {
            return cache.minecraft().download(artifact);
        }
        try {
            return cache.maven().download(artifact);
        }
        catch (Exception e) {
            if (e.getCause() instanceof FileNotFoundException) {
                try {
                    return cache.minecraft().download(artifact);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                }
            }
            return (File)Util.sneak(e);
        }
    }

    @Override
    public Task get() {
        return this.last;
    }

    public Stack<Patcher> getStack() {
        return this.getStack(true);
    }

    public Stack<Patcher> getParents() {
        return this.getStack(false);
    }

    private Stack<Patcher> getStack(boolean includeSelf) {
        Stack<Patcher> stack = new Stack<Patcher>();
        if (includeSelf) {
            stack.add(this);
        }
        Patcher parent = this.parent;
        while (parent != null) {
            stack.add(parent);
            parent = parent.parent;
        }
        return stack;
    }

    private File extractATs() {
        return this.extractJoinedFiles("access_transformer.cfg", this.config.getAts());
    }

    private File extractSASs() {
        return this.extractJoinedFiles("side_annotation_stripper.cfg", this.config.getSASs());
    }

    private File extractJoinedFiles(String filename, List<String> files) {
        if (files.isEmpty()) {
            return null;
        }
        File output = new File(this.build, filename);
        HashStore cache = HashStore.fromFile(output);
        cache.add("data", this.data);
        if (output.exists() && cache.isSame()) {
            return output;
        }
        Mavenizer.assertNotCacheOnly();
        if (output.exists()) {
            output.delete();
        }
        FileUtils.ensureParent(output);
        boolean first = true;
        try (ZipFile zip = new ZipFile(this.data);
             FileOutputStream out = new FileOutputStream(output);){
            for (String file : files) {
                ZipEntry entry = zip.getEntry(file);
                if (entry == null) {
                    throw new IllegalStateException("Invalid Patcher configuation, Missing Data: " + file);
                }
                if (!first) {
                    out.write(new byte[]{13, 10});
                } else {
                    first = false;
                }
                InputStream is = zip.getInputStream(entry);
                try {
                    is.transferTo(out);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Invalid patcher config, failed to extract data", e);
        }
        cache.save();
        return output;
    }

    private Task extractSingle(String key, String value) {
        return this.extracts.computeIfAbsent(value, string -> Task.named("extract[" + key + "]", () -> this.extractSingleTask(key, value)));
    }

    private File extractSingleTask(String key, String value) {
        File file;
        int idx = value.lastIndexOf(47);
        String filename = idx == -1 ? value : value.substring(idx);
        File target = new File(this.build, "data/" + key + "/" + filename);
        HashStore cache = HashStore.fromFile(target);
        cache.add("data", this.data);
        if (target.exists() && cache.isSame()) {
            return target;
        }
        Mavenizer.assertNotCacheOnly();
        ZipFile zip = new ZipFile(this.data);
        try {
            ZipEntry entry = zip.getEntry(value);
            if (entry == null) {
                throw this.except("Missing data: `" + key + "`: `" + value + "`");
            }
            FileUtils.ensureParent(target);
            try (FileOutputStream os = new FileOutputStream(target);){
                zip.getInputStream(entry).transferTo(os);
            }
            target.setLastModified(entry.getLastModifiedTime().toMillis());
            cache.save();
            file = target;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zip.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw this.except("Failed to extract `" + key + "`: `" + value + "`", e);
            }
        }
        zip.close();
        return file;
    }

    public static File modifyAccess(File globalBase, Task inputTask, File cfg, Cache dlCache) {
        File jdk;
        File input = inputTask.execute();
        File tool = dlCache.maven().download(Constants.ACCESS_TRANSFORMER);
        File output = new File(globalBase, "modifyAccess.jar");
        File log = new File(globalBase, "modifyAccess.log");
        HashStore cache = HashStore.fromFile(output);
        cache.add("tool", tool);
        cache.add("input", input);
        cache.add("cfg", cfg);
        if (output.exists() && cache.isSame()) {
            return output;
        }
        Mavenizer.assertNotCacheOnly();
        List<String> args = List.of("--inJar", input.getAbsolutePath(), "--atfile", cfg.getAbsolutePath(), "--outJar", output.getAbsolutePath());
        try {
            jdk = dlCache.jdks().get(8);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to find JDK for version 8", e);
        }
        ProcessUtils.Result ret = ProcessUtils.runJar(jdk, globalBase, log, tool, Collections.emptyList(), args);
        if (ret.exitCode != 0) {
            throw new IllegalStateException("Failed to run Access Transformer (exit code " + ret.exitCode + "), See log: " + log.getAbsolutePath());
        }
        cache.save();
        return output;
    }

    public static File stripSides(File globalBase, Task inputTask, File cfg, Cache dlCache) {
        File jdk;
        File input = inputTask.execute();
        File tool = dlCache.maven().download(Constants.SIDE_STRIPPER);
        File output = new File(globalBase, "stripSides.jar");
        File log = new File(globalBase, "stripSides.log");
        HashStore cache = HashStore.fromFile(output);
        cache.add("tool", tool);
        cache.add("input", input);
        cache.add("cfg", cfg);
        if (output.exists() && cache.isSame()) {
            return output;
        }
        Mavenizer.assertNotCacheOnly();
        ArrayList<String> args = new ArrayList<String>();
        args.add("--strip");
        args.add("--input");
        args.add(input.getAbsolutePath());
        args.add("--data");
        args.add(cfg.getAbsolutePath());
        args.add("--output");
        args.add(output.getAbsolutePath());
        try {
            jdk = dlCache.jdks().get(8);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to find JDK for version 8", e);
        }
        ProcessUtils.Result ret = ProcessUtils.runJar(jdk, globalBase, log, tool, Collections.emptyList(), args);
        if (ret.exitCode != 0) {
            throw new IllegalStateException("Failed to run Side Stripper (exit code " + ret.exitCode + "), See log: " + log.getAbsolutePath());
        }
        cache.save();
        return output;
    }

    private Task completeMcp(File globalBase, Task inputTask) {
        MCPSide mcp = this.getMCP().getSide("joined");
        MCPTaskFactory taskFactory = mcp.getTasks().child(globalBase, inputTask);
        return taskFactory.getLastTask();
    }

    private Task postProcess(Task input, File outputDir) {
        PatcherConfig.V2.DataFunction data = this.config.processor;
        File output = new File(outputDir, "post-processed.jar");
        File log = new File(outputDir, "post-processed.log");
        HashSet<Task> deps = new HashSet<Task>();
        deps.add(input);
        if (data.data != null) {
            for (Map.Entry<String, String> entry : data.data.entrySet()) {
                deps.add(this.extractSingle(entry.getKey(), entry.getValue()));
            }
        }
        return Task.named("postProcess[" + this.name.getName() + "]", Task.deps(deps), () -> this.postProcess(input, data, output, log));
    }

    private File postProcess(Task inputTask, PatcherConfig.V2.DataFunction data, File output, File log) {
        File jdk;
        File input = inputTask.execute();
        MavenCache maven = new MavenCache("mcp-tools", data.repo, this.forge.getCache().root());
        Artifact toolA = Artifact.from(data.version);
        File tool = maven.download(toolA);
        HashStore cache = HashStore.fromFile(output);
        cache.add("data", this.data);
        cache.add("tool", tool);
        cache.add("input", input);
        cache.add("jvm-args", data.getJvmArgs().stream().collect(Collectors.joining(" ")));
        cache.add("run-args", data.getArgs().stream().collect(Collectors.joining(" ")));
        HashMap<Object, String> files = new HashMap<Object, String>();
        files.put("{input}", input.getAbsolutePath());
        files.put("{output}", output.getAbsolutePath());
        if (data.data != null) {
            for (Map.Entry<String, String> entry : data.data.entrySet()) {
                Task extract = this.extractSingle(entry.getKey(), entry.getValue());
                File file = extract.execute();
                files.put("{" + entry.getKey() + "}", file.getAbsolutePath());
                cache.add(entry.getKey(), file);
            }
        }
        if (output.exists() && cache.isSame()) {
            return output;
        }
        Mavenizer.assertNotCacheOnly();
        ArrayList<String> args = new ArrayList<String>();
        for (String arg : data.getArgs()) {
            args.add(files.getOrDefault(arg, arg));
        }
        int n = data.getJavaVersion(this.getMCP().getConfig());
        JDKCache jdks = this.getMCP().getCache().jdks();
        try {
            jdk = jdks.get(n);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to find JDK for version " + n, e);
        }
        ProcessUtils.Result ret = ProcessUtils.runJar(jdk, log.getParentFile(), log, tool, data.getJvmArgs(), args);
        if (ret.exitCode != 0) {
            throw new IllegalStateException("Failed to run MCP Step (exit code " + ret.exitCode + "), See log: " + log.getAbsolutePath());
        }
        cache.save();
        return output;
    }

    private Task patch(Task input, File outputDir) {
        File output = new File(outputDir, "patched.jar");
        File rejects = new File(outputDir, "patched-rejects.jar");
        return Task.named("patch[" + this.name.getName() + "]", Task.deps(input), () -> this.patch(input, output, rejects));
    }

    private File patch(Task inputTask, File output, File rejects) {
        File input = inputTask.execute();
        HashStore cache = HashStore.fromFile(output);
        cache.add("input", input);
        cache.add("data", this.data);
        if (output.exists() && cache.isSame()) {
            return output;
        }
        Mavenizer.assertNotCacheOnly();
        PatchOperation.Builder builder = PatchOperation.builder().logTo(Mavenizer.LOGGER::error).baseInput(Input.MultiInput.archive(ArchiveFormat.ZIP, input.toPath())).patchesInput(Input.MultiInput.archive(ArchiveFormat.ZIP, this.data.toPath())).patchedOutput(Output.MultiOutput.archive(ArchiveFormat.ZIP, output.toPath())).rejectsOutput(Output.MultiOutput.archive(ArchiveFormat.ZIP, rejects.toPath())).level(LogLevel.ERROR).mode(PatchMode.ACCESS).patchesPrefix(this.config.patches);
        if (this.config.patchesOriginalPrefix != null) {
            builder = builder.aPrefix(this.config.patchesOriginalPrefix);
        }
        if (this.config.patchesModifiedPrefix != null) {
            builder = builder.bPrefix(this.config.patchesModifiedPrefix);
        }
        try {
            boolean success;
            CliOperation.Result<PatchOperation.PatchesSummary> result = builder.build().operate();
            boolean bl = success = result.exit == 0;
            if (!success) {
                if (result.summary != null) {
                    ((PatchOperation.PatchesSummary)result.summary).print(Mavenizer.LOGGER.getError(), true);
                } else {
                    Mavenizer.LOGGER.error("Failed to apply patches, no summary available");
                }
                throw this.except("Failed to apply patches, rejects saved to: " + rejects.getAbsolutePath());
            }
            cache.save();
            return output;
        }
        catch (IOException e) {
            return (File)Util.sneak(e);
        }
    }

    private Task injectSources(Task input, File outputDir) {
        if (this.downloadSources == null) {
            return input;
        }
        File output = new File(outputDir, "injected-sources.jar");
        return Task.named("injectSources[" + this.name.getName() + "]", Task.deps(input, this.downloadSources), () -> this.injectSourcesImpl(input, output));
    }

    private File injectSourcesImpl(Task inputTask, File output) {
        File input = inputTask.execute();
        File sources = this.downloadSources.execute();
        HashStore cache = HashStore.fromFile(output);
        cache.add("input", input);
        cache.add("sources", sources);
        if (output.exists() && cache.isSame()) {
            return output;
        }
        Mavenizer.assertNotCacheOnly();
        try {
            FileUtils.mergeJars(output, false, (file, path) -> file != sources || !path.startsWith("patches/"), sources, input);
        }
        catch (IOException e) {
            return (File)Util.sneak(e);
        }
        cache.save();
        return output;
    }
}

