/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.mappings;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.mcmaven.impl.util.Artifact;

public record ParchmentVersion(String timestamp, String mcVersion, String mapMcVersion) {
    private static final Pattern TIMESTAMP = Pattern.compile("\\d{4}.\\d{2}.\\d{2}");
    private static final Pattern MCP_TIMESTAMP = Pattern.compile("\\d{8}.\\d{6}");
    public static final String PARCHMENT_MAVEN = "https://maven.parchmentmc.org/";
    private static final String PARCHMENT_GROUP = "org.parchmentmc.data";

    public static ParchmentVersion parse(String version) {
        if (version == null) {
            throw new IllegalArgumentException("Parchment mappings version must be present");
        }
        if (version.contains("-SNAPSHOT")) {
            throw new IllegalArgumentException("Parchment snapshots are not supported: " + version);
        }
        Matcher matcher = TIMESTAMP.matcher(version);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Parchment version does not contain a timestamp: " + version);
        }
        int start = matcher.start();
        int end = matcher.end();
        if (start == 0 && end == version.length()) {
            return new ParchmentVersion(version, null, null);
        }
        String timestamp = matcher.group();
        String mcVersion = null;
        if (end < version.length()) {
            if (version.charAt(end) != '-' || end == version.length() - 1) {
                throw new IllegalArgumentException("Parchment version does not specify Minecraft version: " + version);
            }
            mcVersion = version.substring(end + 1);
        }
        String mapMcVersion = ParchmentVersion.stripMcp(mcVersion);
        if (start > 0) {
            if (version.charAt(start - 1) != '-' || start == 1) {
                throw new IllegalArgumentException("Parchment version does not specify Mapping Minecraft version: " + version);
            }
            mapMcVersion = version.substring(0, start - 1);
        }
        return new ParchmentVersion(timestamp, mcVersion, mapMcVersion);
    }

    public static ParchmentVersion tryParse(String version) {
        try {
            return ParchmentVersion.parse(version);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static String stripMcp(String version) {
        if (version == null) {
            return null;
        }
        if (version.length() <= 17 || version.charAt(version.length() - 16) != '-') {
            return version;
        }
        Matcher matcher = MCP_TIMESTAMP.matcher(version);
        if (matcher.find() && matcher.start() == version.length() - 15) {
            return version.substring(0, version.length() - 16);
        }
        return version;
    }

    public ParchmentVersion withMinecraft(String mcVersion) {
        return new ParchmentVersion(this.timestamp, mcVersion, this.mapMcVersion == null ? mcVersion : this.mapMcVersion);
    }

    public String toFriendly() {
        if (this.mapMcVersion == null) {
            if (this.mcVersion == null) {
                return this.timestamp;
            }
            return this.timestamp + "-" + this.mcVersion;
        }
        if (this.mcVersion == null) {
            return this.mapMcVersion + "-" + this.timestamp;
        }
        if (this.mapMcVersion.equals(ParchmentVersion.stripMcp(this.mcVersion))) {
            return this.timestamp + "-" + this.mcVersion;
        }
        return this.mapMcVersion + "-" + this.timestamp + "-" + this.mcVersion;
    }

    public Artifact getArtifact() {
        if (this.mapMcVersion == null) {
            throw new IllegalStateException("Unknown Parchment version: " + this.timestamp);
        }
        return Artifact.from(PARCHMENT_GROUP, "parchment-" + this.mapMcVersion, this.timestamp, "checked").withExtension("zip");
    }

    public Artifact getMappingArtifact(String mcpVersion) {
        String mcVersion = ParchmentVersion.stripMcp(mcpVersion);
        String artifactVersion = mcpVersion + "-" + this.timestamp;
        if (this.mapMcVersion != null && !mcVersion.equals(this.mapMcVersion)) {
            artifactVersion = artifactVersion + "-" + this.mapMcVersion;
        }
        return Artifact.from("net.minecraft", "mappings_parchment", artifactVersion).withExtension("zip");
    }
}

