/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.cli;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraftforge.mcmaven.impl.Mavenizer;
import net.minecraftforge.mcmaven.impl.MinecraftMaven;
import net.minecraftforge.mcmaven.impl.mappings.Mappings;
import net.minecraftforge.mcmaven.impl.mappings.ParchmentMappings;
import net.minecraftforge.mcmaven.impl.util.Artifact;
import net.minecraftforge.util.logging.Logger;

class MavenTask {
    MavenTask() {
    }

    static OptionParser run(String[] args, boolean getParser) throws Exception {
        Mavenizer.LOGGER.setEnabled(Logger.Level.INFO);
        OptionParser parser = new OptionParser();
        parser.allowsUnrecognizedOptions();
        AbstractOptionSpec helpO = parser.accepts("help", "Displays this help message and exits").forHelp();
        ArgumentAcceptingOptionSpec<File> cacheO = parser.accepts("cache", "Directory to store data needed for this program").withRequiredArg().ofType(File.class).defaultsTo(new File("cache"), (File[])new File[0]);
        ArgumentAcceptingOptionSpec<File> jdkCacheO = parser.accepts("jdk-cache", "Directory to store jdks downloaded from the disoco api").withRequiredArg().ofType(File.class).defaultsTo(new File("cache/jdks"), (File[])new File[0]);
        ArgumentAcceptingOptionSpec<String> versionO = parser.accepts("version", "The specific artifact version to generate").withOptionalArg().ofType(String.class);
        ArgumentAcceptingOptionSpec<String> artifactO = parser.accepts("artifact", "The artifact to attempt to generate, see the code for supported formats").withRequiredArg().ofType(String.class).defaultsTo("net.minecraftforge:forge", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<File> outputO = parser.accepts("output", "Root directory to generate the maven repository").withRequiredArg().ofType(File.class).defaultsTo(new File("output"), (File[])new File[0]);
        OptionSpecBuilder dependenciesOnlyO = parser.accepts("dependencies-only", "Outputs the maven containing only the Gradle Module and POM for the artifact's dependencies without outputting the artifact itself");
        AbstractOptionSpec offlineO = parser.accepts("offline", "Do not attempt to download anything (allows offline operations, if possible)").forHelp();
        OptionSpecBuilder cacheOnlyO = parser.accepts("cache-only", "Only use caches, fail if any downloads need to occur or if a task needs to do work");
        ArgumentAcceptingOptionSpec<String> mappingsO = parser.accepts("mappings", "Mappings to use for this artifact. Formatted as channel:version").withRequiredArg().ofType(String.class).defaultsTo("official", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<String> parchmentO = parser.accepts("parchment", "Version of parchment mappings to use, snapshots are not supported").availableUnless(mappingsO, new OptionSpec[0]).withRequiredArg();
        ArgumentAcceptingOptionSpec<String> foreignRepositoryO = parser.accepts("repository", "EXPERIMENTAL: URL of a foreign maven repository to use for dependencies. The format is \"name,url\". The name must not include any commas.").withRequiredArg().ofType(String.class);
        OptionSpecBuilder globalAuxiliaryVariantsO = parser.accepts("global-auxiliary-variants", "Declares sources and javadoc jars as global variants, no matter the mapping version. This is used to work around gradle/gradle#35065");
        OptionSpecBuilder disableGradleO = parser.accepts("disable-gradle", "Disabels the gradle module file, and writes all mappings to the main artifact files.");
        OptionSpecBuilder stubO = parser.accepts("stub", "Runs any generated jar through a stub tool, deleteing data files and stubing all class files. The resulting jar can be compiled against but is non-functional.");
        ArgumentAcceptingOptionSpec<File> accessTransformerO = parser.accepts("access-transformer", "An AccessTransformer config to apply to the artifacts have been built. This is a work around for Gradle's broken ArtifactTransformer system. https://github.com/MinecraftForge/ForgeGradle/issues/1023").availableUnless(stubO, new OptionSpec[0]).withRequiredArg().ofType(File.class);
        stubO.availableUnless(accessTransformerO, new OptionSpec[0]);
        ArgumentAcceptingOptionSpec<File> outputJsonO = parser.accepts("output-json", "File to write extended output data to. Not compatible with bulk operations.").withRequiredArg().ofType(File.class);
        HashMap<String, OptionSpecBuilder> shorthandOptions = new HashMap<String, OptionSpecBuilder>();
        Map<String, String> artifacts = Map.of("forge", "net.minecraftforge:forge", "fml", "net.minecraftforge:fmlonly", "mc", "net.minecraft:joined", "client", "net.minecraft:client", "server", "net.minecraft:server", "mapping-data", "net.minecraft:mappings");
        for (Map.Entry<String, String> entry : artifacts.entrySet()) {
            String key2 = entry.getKey();
            OptionSpecBuilder option2 = parser.accepts(entry.getKey(), "Shorthand for --artifact " + entry.getValue());
            shorthandOptions.put(key2, option2);
            option2.availableUnless(artifactO, new OptionSpec[0]);
        }
        shorthandOptions.forEach((key, option) -> {
            for (String other : shorthandOptions.keySet()) {
                if (other.equals(key)) continue;
                option.availableUnless(other, new String[0]);
            }
        });
        if (getParser) {
            return parser;
        }
        OptionSet options = parser.parse(args);
        if (options.has(helpO)) {
            parser.printHelpOn(Mavenizer.LOGGER.getInfo());
            Mavenizer.LOGGER.release();
            return parser;
        }
        if (options.has(offlineO)) {
            Mavenizer.setOffline();
        }
        if (options.has(cacheOnlyO)) {
            Mavenizer.setCacheOnly();
        }
        File output = options.valueOf(outputO);
        File cache = options.valueOf(cacheO);
        File jdkCache = !options.has(cacheO) || options.has(jdkCacheO) ? options.valueOf(jdkCacheO) : new File(cache, "jdks");
        Artifact artifact = null;
        for (Map.Entry<String, String> entry : artifacts.entrySet()) {
            if (!options.has(entry.getKey())) continue;
            artifact = Artifact.from(entry.getValue());
            break;
        }
        if (artifact == null) {
            artifact = Artifact.from(options.valueOf(artifactO));
        }
        if (artifact.getVersion() == null) {
            artifact = artifact.withVersion(options.valueOf(versionO));
        }
        Mappings mappings = options.has(parchmentO) ? new ParchmentMappings(options.valueOf(parchmentO)) : Mappings.of(options.valueOf(mappingsO));
        HashMap<String, String> foreignRepositories = new HashMap<String, String>();
        for (String s : options.valuesOf(foreignRepositoryO)) {
            String[] split = s.split(",", 2);
            foreignRepositories.put(split[0], split[1]);
        }
        MinecraftMaven mcmaven = new MinecraftMaven(output, options.has(dependenciesOnlyO), cache, jdkCache, mappings, foreignRepositories, options.has(globalAuxiliaryVariantsO), options.has(disableGradleO), options.has(stubO), options.valuesOf(accessTransformerO), options.valueOf(outputJsonO));
        mcmaven.run(artifact);
        return parser;
    }
}

