/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.repo.mcpconfig;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.minecraftforge.mcmaven.impl.Mavenizer;
import net.minecraftforge.mcmaven.impl.cache.Cache;
import net.minecraftforge.mcmaven.impl.mappings.Mappings;
import net.minecraftforge.mcmaven.impl.repo.Repo;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCP;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPSide;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPTaskFactory;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MinecraftTasks;
import net.minecraftforge.mcmaven.impl.tasks.RecompileTask;
import net.minecraftforge.mcmaven.impl.tasks.RenameTask;
import net.minecraftforge.mcmaven.impl.util.Artifact;
import net.minecraftforge.mcmaven.impl.util.POMBuilder;
import net.minecraftforge.mcmaven.impl.util.Task;
import net.minecraftforge.mcmaven.impl.util.Util;
import net.minecraftforge.util.download.DownloadUtils;
import net.minecraftforge.util.file.FileUtils;
import net.minecraftforge.util.hash.HashStore;

public final class MCPConfigRepo
extends Repo {
    private final Map<Artifact, MCP> versions = new HashMap<Artifact, MCP>();
    private final Map<String, MinecraftTasks> mcTasks = new HashMap<String, MinecraftTasks>();
    private final Task downloadLauncherManifest = Task.named("downloadLauncherManifest", this::downloadLauncherManifest);
    private final boolean dependenciesOnly;

    public MCPConfigRepo(Cache cache, boolean dependenciesOnly) {
        super(cache);
        this.dependenciesOnly = dependenciesOnly;
    }

    public MCP get(String version) {
        return this.get(MCP.artifact(version));
    }

    public MCP get(Artifact artifact) {
        return this.versions.computeIfAbsent(artifact, this::download);
    }

    private MCP download(Artifact artifact) {
        return new MCP(this, artifact);
    }

    public MinecraftTasks getMCTasks(String version) {
        return this.mcTasks.computeIfAbsent(version, string -> new MinecraftTasks(this.cache, version, this.downloadLauncherManifest));
    }

    public Task getLauncherManifestTask() {
        return this.downloadLauncherManifest;
    }

    private File downloadLauncherManifest() {
        File target = new File(this.cache.root(), "launcher_manifest.json");
        if (!target.exists() || !Mavenizer.isCacheOnly() && target.lastModified() < System.currentTimeMillis() - 3600000L) {
            try {
                if (Mavenizer.isCacheOnly()) {
                    Mavenizer.assertNotCacheOnly();
                }
                Mavenizer.assertOnline();
                DownloadUtils.downloadFile(target, "https://piston-meta.mojang.com/mc/game/version_manifest.json");
            }
            catch (IOException e) {
                Util.sneak(e);
            }
        }
        return target;
    }

    private void validate(Artifact artifact) {
        if (!"net.minecraft".equals(artifact.getGroup())) {
            throw new IllegalArgumentException("MCPConfigRepo cannot process modules that aren't for group net.minecraft");
        }
        switch (artifact.getName()) {
            case "client": 
            case "client-extra": 
            case "server": 
            case "server-extra": 
            case "joined": 
            case "joined-extra": 
            case "mappings": {
                return;
            }
        }
        throw new IllegalArgumentException("MCPConfigRepo does not support artifact: " + String.valueOf(artifact));
    }

    @Override
    public List<Repo.PendingArtifact> process(Artifact artifact, Mappings mappings, Map<String, Supplier<String>> outputJson) {
        this.validate(artifact);
        String version = artifact.getVersion();
        String side = artifact.getName();
        boolean isMappings = "mappings".equals(side);
        if (isMappings) {
            side = "joined";
        }
        if (side.endsWith("-extra")) {
            return this.processExtra("net.minecraft:" + side.substring(0, side.length() - "-extra".length()), version);
        }
        MCP mcp = this.get(MCP.artifact(version));
        MCPSide mcpSide = mcp.getSide(side);
        MCPTaskFactory mcpTasks = mcpSide.getTasks();
        File build = mcpSide.getBuildFolder();
        Artifact name = Artifact.from("net.minecraft", side, version);
        Repo.PendingArtifact pom = MCPConfigRepo.pending("Maven POM", MCPConfigRepo.pom(build, side, mcpSide, version), name.withExtension("pom"), false);
        Repo.PendingArtifact metadata = MCPConfigRepo.pending("Metadata", MCPConfigRepo.metadata(build, mcpSide), name.withClassifier("metadata").withExtension("zip"), false, this.metadataVariant());
        if (this.dependenciesOnly) {
            return List.of(pom.withVariants(() -> this.classVariants(mappings, mcpSide)), metadata);
        }
        List<Repo.PendingArtifact> mappingArtifacts = this.mappingArtifacts(build, mappings, mcpSide, outputJson);
        if (isMappings) {
            return mappingArtifacts;
        }
        return switch (mappings.channel()) {
            case "notch" -> List.of(MCPConfigRepo.pending("Classes", mcpTasks.getRawJar(), name.withClassifier("raw"), false, this.simpleVariant("obf-notch", new Mappings("notch", null))));
            case "srg", "searge" -> List.of(MCPConfigRepo.pending("Classes", mcpTasks.getSrgJar(), name.withClassifier("srg"), false, this.simpleVariant("obf-searge", new Mappings("searge", null))));
            default -> {
                ArrayList<Repo.PendingArtifact> pending = new ArrayList<Repo.PendingArtifact>();
                RenameTask sourcesTask = new RenameTask(build, name.getName(), mcpSide, mcpSide.getSources(), mappings, true);
                RecompileTask recompile = new RecompileTask(build, name, mcpSide.getMCP(), mcpSide::getClasspath, sourcesTask, mappings);
                Task classesTask = MCPConfigRepo.mergeExtra(build, side, recompile, mcpSide.getTasks().getExtra(), mappings);
                Repo.PendingArtifact sources = MCPConfigRepo.pending("Sources", (Task)sourcesTask, name.withClassifier("sources"), true, this.sourceVariant(mappings));
                Repo.PendingArtifact classes = MCPConfigRepo.pending("Classes", classesTask, name, false, () -> this.classVariants(mappings, mcpSide));
                pending.addAll(List.of(sources, classes, metadata, pom));
                pending.addAll(mappingArtifacts);
                yield pending;
            }
        };
    }

    public List<Repo.PendingArtifact> processWithoutMcp(Artifact artifact, Mappings mappings, Map<String, Supplier<String>> outputJson) {
        if (!"official".equals(mappings.channel())) {
            throw new IllegalArgumentException("MCPConfigRepo.processWithoutMcp only knows how to generate official named artifacts");
        }
        MinecraftTasks tasks = this.getMCTasks(artifact.getVersion());
        File cache = new File(this.cache.root(), "without_mcp");
        Artifact mapCoords = Artifact.from("net.minecraft", "mappings_official", artifact.getVersion()).withExtension("zip");
        Repo.PendingArtifact mapPom = MCPConfigRepo.pending("Mappings POM", MCPConfigRepo.simplePom(cache, mapCoords), mapCoords.withExtension("pom"), false);
        Repo.PendingArtifact m2o = MCPConfigRepo.pending("Mappings map2obf", tasks.mergeMappings(), mapCoords.withClassifier("map2obf").withExtension("tsrg.gz"), false);
        if (outputJson != null) {
            outputJson.put("mappings.channel", mappings::channel);
            outputJson.put("mappings.version", mappings::version);
            outputJson.put("mappings.obf.artifact", m2o.artifact()::toString);
            outputJson.put("mappings.obf.file", m2o.task().filePathSupplier());
        }
        if ("mappings".equals(artifact.getName())) {
            return List.of(mapPom, m2o);
        }
        if ("client".equals(artifact.getName())) {
            Repo.PendingArtifact pom = MCPConfigRepo.pending("Maven POM", tasks.clientPom(), artifact.withExtension("pom"), false);
            Repo.PendingArtifact jar = MCPConfigRepo.pending("Official Jar", tasks.renameClient(), artifact, false);
            return List.of(mapPom, m2o, pom, jar);
        }
        if ("server".equals(artifact.getName())) {
            Repo.PendingArtifact pom = MCPConfigRepo.pending("Maven POM", tasks.serverPom(), artifact.withExtension("pom"), false);
            Repo.PendingArtifact jar = MCPConfigRepo.pending("Official Jar", tasks.renameServer(), artifact, false);
            return List.of(mapPom, m2o, pom, jar);
        }
        throw new IllegalArgumentException("MCPConfigRepo does not support artifact: " + String.valueOf(artifact));
    }

    public List<Repo.PendingArtifact> processExtra(String module, String version) {
        if (!module.startsWith("net.minecraft:")) {
            throw new IllegalArgumentException("MCPConfigRepo cannot process modules that aren't for group net.minecraft");
        }
        String side = module.substring("net.minecraft:".length());
        String displayName = Character.toUpperCase(side.charAt(0)) + side.substring(1);
        MCP mcp = this.get(MCP.artifact(version));
        MCPSide mcpSide = mcp.getSide(side);
        File build = mcpSide.getBuildFolder();
        Artifact name = Artifact.from("net.minecraft", side + "-extra", version);
        Task extraTask = mcpSide.getTasks().getExtra();
        Task pomTask = MCPConfigRepo.pomExtra(build, side + "-extra", version);
        Repo.PendingArtifact extra = MCPConfigRepo.pending(displayName + " Extra", extraTask, name, false);
        Repo.PendingArtifact pom = MCPConfigRepo.pending(displayName + " Maven POM", pomTask, name.withExtension("pom"), false);
        return List.of(extra, pom);
    }

    private static Task mergeExtra(File build, String side, Task recompiled, Task extra, Mappings mappings) {
        return Task.named("mergeExtra[" + side + "][" + String.valueOf(mappings) + "]", Task.deps(extra, recompiled), () -> {
            File output = new File(mappings.getFolder(build), "recompiled-extra.jar");
            File recompiledF = recompiled.execute();
            File extraF = extra.execute();
            HashStore cache = HashStore.fromFile(output).add(recompiledF, extraF);
            if (output.exists() && cache.isSame()) {
                return output;
            }
            Mavenizer.assertNotCacheOnly();
            try {
                FileUtils.mergeJars(output, true, extraF, recompiledF);
            }
            catch (IOException e) {
                Util.sneak(e);
            }
            cache.save();
            return output;
        });
    }

    private static Task metadata(File build, MCPSide side) {
        MinecraftTasks minecraftTasks = side.getMCP().getMinecraftTasks();
        return Task.named("metadata[" + String.valueOf(side) + "]", Task.deps(minecraftTasks.versionJson), () -> {
            File output = new File(build, "metadata.zip");
            File metadataDir = new File(output.getParentFile(), "metadata");
            File versionProperties = new File(metadataDir, "version.properties");
            File minecraftDir = new File(metadataDir, "minecraft");
            File versionJson = minecraftTasks.versionJson.execute();
            HashStore cache = HashStore.fromFile(output).add(versionJson).add(versionProperties);
            if (output.exists() && cache.isSame()) {
                return output;
            }
            Mavenizer.assertNotCacheOnly();
            try {
                FileUtils.ensureParent(output);
                FileUtils.ensure(metadataDir);
                FileUtils.ensure(minecraftDir);
                try (FileWriter writer = new FileWriter(versionProperties);){
                    writer.append("version=1").append('\n').flush();
                }
                Files.copy(versionJson.toPath(), new File(minecraftDir, "version.json").toPath(), StandardCopyOption.REPLACE_EXISTING);
                cache.add(versionProperties);
                FileUtils.makeZip(metadataDir, output);
            }
            catch (IOException e) {
                Util.sneak(e);
            }
            cache.save();
            return output;
        });
    }

    private static Task pom(File build, String side, MCPSide mcpSide, String version) {
        return Task.named("pom[" + version + "][" + side + "]", () -> {
            File output = new File(build, side + ".pom");
            HashStore cache = HashStore.fromFile(output);
            if (output.exists() && cache.isSame()) {
                return output;
            }
            Mavenizer.assertNotCacheOnly();
            POMBuilder builder = new POMBuilder("net.minecraft", side, version).preferGradleModule().dependencies(dependencies -> mcpSide.forAllLibraries(dependencies::add, Artifact::hasNoOs));
            FileUtils.ensureParent(output);
            try (FileOutputStream os = new FileOutputStream(output);){
                os.write(builder.build().getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException | ParserConfigurationException | TransformerException e) {
                Util.sneak(e);
            }
            cache.save();
            return output;
        });
    }

    private static Task pomExtra(File build, String side, String version) {
        return Task.named("pom[" + side + "]", () -> {
            File output = new File(build, side + ".pom");
            HashStore cache = HashStore.fromFile(output);
            if (output.exists() && cache.isSame()) {
                return output;
            }
            Mavenizer.assertNotCacheOnly();
            POMBuilder builder = new POMBuilder("net.minecraft", side, version);
            FileUtils.ensureParent(output);
            try (FileOutputStream os = new FileOutputStream(output);){
                os.write(builder.build().getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException | ParserConfigurationException | TransformerException e) {
                Util.sneak(e);
            }
            cache.save();
            return output;
        });
    }
}

