/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.mappings;

import net.minecraftforge.mcmaven.impl.cache.MavenCache;
import net.minecraftforge.mcmaven.impl.mappings.Mappings;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPSide;
import net.minecraftforge.mcmaven.impl.util.Artifact;
import net.minecraftforge.mcmaven.impl.util.Task;
import org.jetbrains.annotations.Nullable;

public class MCPMappings
extends Mappings {
    public MCPMappings(String channel, @Nullable String version) {
        super(channel, version);
        if (version == null) {
            throw new IllegalArgumentException("MCP Mappings can not have a null version");
        }
    }

    @Override
    public Task getCsvZip(MCPSide side) {
        Mappings.Key key = new Mappings.Key(Mappings.Tasks.CSVs, side);
        Task ret = (Task)this.tasks.get(key);
        if (ret != null) {
            return ret;
        }
        Artifact artifact = Artifact.from("de.oceanlabs.mcp", "mcp_" + this.channel(), this.version(), null, "zip");
        MavenCache maven = side.getMCP().getCache().maven();
        ret = Task.named("srg2names[" + String.valueOf(this) + "]", () -> maven.download(artifact));
        this.tasks.put(key, ret);
        return ret;
    }

    @Override
    public Mappings withMCVersion(String version) {
        return this;
    }
}

