/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.cli;

import java.io.File;
import java.io.IOException;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraftforge.mcmaven.impl.Mavenizer;
import net.minecraftforge.mcmaven.impl.MinecraftMaven;
import net.minecraftforge.mcmaven.impl.cache.Cache;
import net.minecraftforge.mcmaven.impl.data.MCPSetupFiles;
import net.minecraftforge.mcmaven.impl.mappings.Mappings;
import net.minecraftforge.mcmaven.impl.mappings.ParchmentMappings;
import net.minecraftforge.mcmaven.impl.repo.forge.Patcher;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCP;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPConfigRepo;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPSide;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPTaskFactory;
import net.minecraftforge.mcmaven.impl.tasks.RenameTask;
import net.minecraftforge.mcmaven.impl.util.Artifact;
import net.minecraftforge.mcmaven.impl.util.Task;
import net.minecraftforge.mcmaven.impl.util.Util;
import net.minecraftforge.util.data.json.JsonData;
import net.minecraftforge.util.hash.HashFunction;
import net.minecraftforge.util.hash.HashStore;
import net.minecraftforge.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;

class MCPTask {
    MCPTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static OptionParser run(String[] args, boolean getParser) throws Exception {
        File sas;
        File jdkCacheRoot;
        Mavenizer.LOGGER.setEnabled(Logger.Level.INFO);
        OptionParser parser = new OptionParser();
        parser.allowsUnrecognizedOptions();
        AbstractOptionSpec helpO = parser.accepts("help", "Displays this help message and exits").forHelp();
        ArgumentAcceptingOptionSpec<File> cacheO = parser.accepts("cache", "Directory to store data needed for this program").withRequiredArg().ofType(File.class).defaultsTo(new File("cache"), (File[])new File[0]);
        ArgumentAcceptingOptionSpec<File> jdkCacheO = parser.accepts("jdk-cache", "Directory to store jdks downloaded from the disoco api").withRequiredArg().ofType(File.class).defaultsTo(new File("cache/jdks"), (File[])new File[0]);
        ArgumentAcceptingOptionSpec<File> outputO = parser.accepts("output", "File to output the final jar").withRequiredArg().ofType(File.class).defaultsTo(new File("output.jar"), (File[])new File[0]);
        ArgumentAcceptingOptionSpec<File> outputFilesO = parser.accepts("output-files", "File to output a JSON containing paths to extra files").withRequiredArg().ofType(File.class).defaultsTo(new File("files.json"), (File[])new File[0]);
        ArgumentAcceptingOptionSpec<String> artifactO = parser.accepts("artifact", "MCPConfig artifact coordinates").withRequiredArg();
        ArgumentAcceptingOptionSpec<String> versionO = parser.accepts("version", "MCPConfig artifact version").withRequiredArg();
        ArgumentAcceptingOptionSpec<String> pipelineO = parser.accepts("pipeline", "MCPConfig pipeline to run, typically [client|server|joined]").withRequiredArg().defaultsTo("joined", (String[])new String[0]);
        OptionSpecBuilder rawO = parser.accepts("raw", "Use to output a raw jar file without any MCPConfig transformations.");
        OptionSpecBuilder seargeO = parser.accepts("searge", "Use with --raw to output the raw jar file renamed with SRG names").availableIf(rawO, new OptionSpec[0]);
        ArgumentAcceptingOptionSpec<File> atO = parser.accepts("at", "Access Transformer config file to apply").availableUnless(rawO, new OptionSpec[0]).withOptionalArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<File> sasO = parser.accepts("sas", "Side Annotation Stripper confg file to apply").availableUnless(rawO, new OptionSpec[0]).withOptionalArg().ofType(File.class);
        OptionSpecBuilder mappingsO = parser.accepts("mappings", "Use to enable using official mappings").availableUnless(rawO, new OptionSpec[0]);
        ArgumentAcceptingOptionSpec<String> parchmentO = parser.accepts("parchment", "Version of parchment mappings to use, snapshots are not supported").availableIf(mappingsO, new OptionSpec[0]).withRequiredArg();
        if (getParser) {
            return parser;
        }
        OptionSet options = parser.parse(args);
        if (options.has(helpO)) {
            parser.printHelpOn(Mavenizer.LOGGER.getInfo());
            Mavenizer.LOGGER.release();
            return parser;
        }
        File output = options.valueOf(outputO);
        File outputFiles = options.valueOf(outputFilesO);
        File cacheRoot = options.valueOf(cacheO);
        File file = jdkCacheRoot = !options.has(cacheO) || options.has(jdkCacheO) ? options.valueOf(jdkCacheO) : new File(cacheRoot, "jdks");
        Artifact artifact = options.has(artifactO) ? Artifact.from(options.valueOf(artifactO)) : (options.has(versionO) ? MCP.artifact(options.valueOf(versionO)) : null);
        String pipeline = options.valueOf(pipelineO);
        File ats = options.has(atO) ? options.valueOf(atO) : null;
        File file2 = sas = options.has(sasO) ? options.valueOf(sasO) : null;
        if (artifact == null) {
            Mavenizer.LOGGER.error("Missing mcp --version or --artifact");
            Mavenizer.LOGGER.release();
            return parser;
        }
        MCPConfigRepo repo = new MCPConfigRepo(new Cache(cacheRoot, jdkCacheRoot), false);
        Mavenizer.LOGGER.info("  Output:     " + output.getAbsolutePath());
        Mavenizer.LOGGER.info("  Cache:      " + cacheRoot.getAbsolutePath());
        Mavenizer.LOGGER.info("  JDK Cache:  " + jdkCacheRoot.getAbsolutePath());
        Mavenizer.LOGGER.info("  Artifact:   " + String.valueOf(artifact));
        Mavenizer.LOGGER.info("  Pipeline:   " + pipeline);
        if (options.has(rawO)) {
            Mavenizer.LOGGER.info("  Raw Names:  " + (options.has(seargeO) ? "Searge" : "Notch"));
        } else {
            Mavenizer.LOGGER.info("  Access:     " + (ats == null ? null : ats.getAbsolutePath()));
            Mavenizer.LOGGER.info("  SAS:        " + (sas == null ? null : sas.getAbsolutePath()));
        }
        Mavenizer.LOGGER.info();
        MCP mcp = repo.get(artifact);
        MCPSide side = mcp.getSide(pipeline);
        if (options.has(rawO)) {
            File raw;
            boolean searge = options.has(seargeO);
            HashStore cache = HashStore.fromFile(output).addKnown("obfuscation", searge ? "srg" : "notch");
            Task rawTask = searge ? side.getTasks().getSrgJar() : side.getTasks().getRawJar();
            Mavenizer.LOGGER.info("Creating Raw Jar");
            byte indent = Mavenizer.LOGGER.push();
            try {
                raw = rawTask.execute();
                cache.add("raw", raw);
            }
            finally {
                Mavenizer.LOGGER.pop(indent);
            }
            if (!output.exists() || !cache.isSame()) {
                try {
                    FileUtils.copyFile(raw, output);
                    if (outputFiles != null) {
                        MCPTask.writeFiles(side.getTasks(), outputFiles);
                    }
                    cache.save();
                }
                catch (Throwable t) {
                    throw new RuntimeException("Failed to generate artifact: %s".formatted(artifact), t);
                }
            }
            return parser;
        }
        Task sourcesTask = side.getSources();
        if (ats != null || sas != null) {
            Task tmp;
            String hash = Util.hash(HashFunction.SHA1, ats, sas);
            File dir = new File(side.getBuildFolder(), hash);
            Task predecomp = side.getTasks().getPreDecompile();
            if (ats != null) {
                tmp = predecomp;
                predecomp = Task.named("modifyAccess", Task.deps(tmp), () -> Patcher.modifyAccess(dir, tmp, ats, repo.getCache()));
            }
            if (sas != null) {
                tmp = predecomp;
                predecomp = Task.named("stripSides", Task.deps(tmp), () -> Patcher.stripSides(dir, tmp, sas, repo.getCache()));
            }
            MCPTaskFactory factory = side.getTasks().child(dir, predecomp);
            sourcesTask = factory.getLastTask();
        }
        File sources = null;
        Mavenizer.LOGGER.info("Creating MCP Source Jar");
        byte indent = Mavenizer.LOGGER.push();
        try {
            sources = sourcesTask.execute();
        }
        finally {
            Mavenizer.LOGGER.pop(indent);
        }
        HashStore cache = HashStore.fromFile(output).add("sources", sources);
        if (options.has(mappingsO)) {
            Mavenizer.LOGGER.info("Renaming MCP Source Jar");
            byte indent2 = Mavenizer.LOGGER.push();
            try {
                ParchmentMappings mappings = options.has(parchmentO) ? new ParchmentMappings(options.valueOf(parchmentO)) : new Mappings("official", null).withMCVersion(MinecraftMaven.mcpToMcVersion(artifact.getVersion()));
                RenameTask renameTask = new RenameTask(side.getBuildFolder(), pipeline, side, sourcesTask, mappings, false);
                sources = renameTask.execute();
            }
            finally {
                Mavenizer.LOGGER.pop(indent2);
            }
            cache.add("renamed", sources);
        }
        if (!output.exists() || !cache.isSame()) {
            try {
                FileUtils.copyFile(sources, output);
                if (outputFiles != null) {
                    MCPTask.writeFiles(side.getTasks(), outputFiles);
                }
                cache.save();
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to generate artifact: %s".formatted(artifact), t);
            }
        }
        return parser;
    }

    private static void writeFiles(MCPTaskFactory mcpTaskFactory, File output) {
        MCPSetupFiles files = new MCPSetupFiles();
        files.versionManifest = MCPTask.getTaskPath(mcpTaskFactory, "downloadManifest");
        files.versionJson = MCPTask.getTaskPath(mcpTaskFactory, "downloadJson");
        files.clientRaw = MCPTask.getTaskPath(mcpTaskFactory, "downloadClient");
        files.serverRaw = MCPTask.getTaskPath(mcpTaskFactory, "downloadServer");
        files.serverExtracted = MCPTask.getTaskPath(mcpTaskFactory, "extractServer");
        files.clientMappings = mcpTaskFactory.downloadClientMappings().execute().getAbsolutePath();
        files.serverMappings = mcpTaskFactory.downloadServerMappings().execute().getAbsolutePath();
        files.librariesList = MCPTask.getTaskPath(mcpTaskFactory, "listLibraries");
        try {
            JsonData.toJson(files, output);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write extra files data: " + output.getPath(), e);
        }
    }

    @Nullable
    private static String getTaskPath(MCPTaskFactory mcpTaskFactory, String step) {
        try {
            return mcpTaskFactory.findStep(step).execute().getAbsolutePath();
        }
        catch (Exception e) {
            Mavenizer.LOGGER.error("Cannot serialize output path for MCP step: " + step);
            return null;
        }
    }
}

