/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.repo.forge;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraftforge.mcmaven.impl.Mavenizer;
import net.minecraftforge.mcmaven.impl.cache.Cache;
import net.minecraftforge.mcmaven.impl.mappings.Mappings;
import net.minecraftforge.mcmaven.impl.repo.forge.Patcher;
import net.minecraftforge.mcmaven.impl.util.Artifact;
import net.minecraftforge.mcmaven.impl.util.Task;
import net.minecraftforge.mcmaven.impl.util.Util;
import net.minecraftforge.util.file.FileUtils;
import net.minecraftforge.util.hash.HashStore;

public final class InjectTask
implements Task {
    private final File build;
    private final Artifact name;
    private final Cache cache;
    private final Patcher patcher;
    private final Mappings mappings;
    private final Task task;

    InjectTask(File build, Cache cache, Artifact name, Patcher patcher, Task input, Mappings mappings) {
        this.build = mappings.getFolder(build);
        this.name = name;
        this.cache = cache;
        this.patcher = patcher;
        this.mappings = mappings;
        this.task = this.injectData(input);
    }

    @Override
    public File execute() {
        return this.task.execute();
    }

    @Override
    public boolean resolved() {
        return this.task.resolved();
    }

    @Override
    public String name() {
        return this.task.name();
    }

    private Task injectData(Task input) {
        return Task.named("injectData[" + this.name.getName() + "][" + String.valueOf(this.mappings) + "]", Task.deps(input), () -> this.injectDataImpl(input, new File(this.build, "injected.jar")));
    }

    private File injectDataImpl(Task inputTask, File outputJar) {
        HashStore cache = HashStore.fromFile(outputJar);
        File recompiledJar = inputTask.execute();
        cache.add("recompiled", recompiledJar);
        ArrayList<File> universals = new ArrayList<File>();
        for (Patcher p : this.patcher.getStack()) {
            if (p.config.universal == null) continue;
            File universal = this.cache.maven().download(Artifact.from(p.config.universal));
            universals.add(universal);
            cache.add(universal);
        }
        if (outputJar.exists() && cache.isSame()) {
            return outputJar;
        }
        Mavenizer.assertNotCacheOnly();
        cache.clear().add("recompiled", recompiledJar);
        try {
            ArrayList<File> jars = new ArrayList<File>(universals);
            universals.forEach(cache::add);
            jars.add(recompiledJar);
            FileUtils.mergeJars(outputJar, true, (file, name) -> file == recompiledJar || !name.endsWith(".class"), (File[])jars.toArray(File[]::new));
        }
        catch (IOException e) {
            return (File)Util.sneak(e);
        }
        cache.save();
        return outputJar;
    }
}

