/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.cache;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import net.minecraftforge.mcmaven.impl.cache.MavenCache;
import net.minecraftforge.mcmaven.impl.util.Util;
import net.minecraftforge.util.data.MCJsonUtils;
import net.minecraftforge.util.data.json.MinecraftVersion;
import net.minecraftforge.util.file.FileUtils;
import net.minecraftforge.util.hash.HashFunction;
import net.minecraftforge.util.os.OS;

public final class MinecraftMavenCache
extends MavenCache {
    private static final HashFunction[] KNOWN_HASHES = new HashFunction[]{HashFunction.SHA1};
    private static final File LOCAL_MCLIBS = new File(MCJsonUtils.getMCDir(OS.current()), "libraries");

    public MinecraftMavenCache(File root) {
        super("mojang", "https://libraries.minecraft.net/", root, KNOWN_HASHES);
    }

    public File download(MinecraftVersion.LibraryDownload lib) {
        try {
            return this.download(false, lib.path);
        }
        catch (Exception e) {
            return (File)Util.sneak(e);
        }
    }

    @Override
    protected void downloadFile(File target, String path) throws IOException {
        if (!LOCAL_MCLIBS.exists()) {
            super.downloadFile(target, path);
            return;
        }
        File local = new File(LOCAL_MCLIBS, path.replace('/', File.separatorChar));
        if (local.exists()) {
            FileUtils.ensureParent(target);
            try {
                Files.copy(local.toPath(), target.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                Util.sneak(e);
            }
            return;
        }
        super.downloadFile(target, path);
    }
}

