/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.java_provisioner;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.java_provisioner.Disco;
import net.minecraftforge.java_provisioner.ProcessUtils;
import net.minecraftforge.java_provisioner.api.JavaInstall;
import net.minecraftforge.java_provisioner.api.JavaLocator;
import net.minecraftforge.java_provisioner.api.JavaProvisionerException;
import net.minecraftforge.util.os.OS;
import org.jetbrains.annotations.Nullable;

class JavaHomeLocator
implements JavaLocator {
    protected List<String> searched = new ArrayList<String>();

    JavaHomeLocator() {
    }

    @Override
    public File find(int version) throws JavaProvisionerException {
        String suffix = Disco.Arch.CURRENT.is64Bit() ? (Disco.Arch.CURRENT.isArm() ? "_arm64" : "_X64") : "";
        JavaInstall ret = this.fromEnv("JAVA_HOME_" + version + suffix, version);
        if (ret != null) {
            return ret.home();
        }
        ret = this.fromEnv("JAVA_HOME_" + version, version);
        if (ret != null) {
            return ret.home();
        }
        ret = this.fromEnv("JAVA_HOME", version);
        if (ret != null) {
            return ret.home();
        }
        for (String key : System.getenv().keySet()) {
            if (!key.startsWith("JAVA_HOME") || (ret = this.fromEnv("JAVA_HOME", version)) == null) continue;
            return ret.home();
        }
        throw new JavaProvisionerException("Failed to find any Java installations from JAVA_HOME environment variables", this.logOutput());
    }

    @Override
    public List<JavaInstall> findAll(int version) {
        ArrayList<String> keys = new ArrayList<String>(){

            @Override
            public boolean add(String o) {
                return !this.contains(o) && super.add(o);
            }
        };
        if (version >= 0) {
            String suffix = Disco.Arch.CURRENT.is64Bit() ? (Disco.Arch.CURRENT.isArm() ? "_arm64" : "_X64") : "";
            keys.add("JAVA_HOME_" + version + (String)suffix);
            keys.add("JAVA_HOME_" + version);
        }
        keys.add("JAVA_HOME");
        for (String key : System.getenv().keySet()) {
            if (!key.startsWith("JAVA_HOME")) continue;
            keys.add(key);
        }
        ArrayList<JavaInstall> ret = new ArrayList<JavaInstall>();
        for (String key : keys) {
            JavaInstall install = this.fromEnv(key, version);
            if (install == null) continue;
            ret.add(install);
        }
        if (ret.isEmpty()) {
            this.log("Failed to find any Java installations from JAVA_HOME environment variables");
        }
        return ret;
    }

    @Override
    public List<String> logOutput() {
        return this.searched;
    }

    protected void log(String line) {
        this.searched.add(line);
    }

    @Nullable
    JavaInstall fromEnv(String name, int version) {
        if (version < 0) {
            return this.fromEnv(name);
        }
        JavaInstall result = this.fromEnv(name);
        if (result == null) {
            return null;
        }
        if (result.majorVersion() != version) {
            this.log("  Wrong version: Was " + result.majorVersion() + " wanted " + version);
            return null;
        }
        return result;
    }

    @Nullable
    JavaInstall fromEnv(String name) {
        String env = System.getenv(name);
        if (env == null) {
            this.log("Environment: \"" + name + "\" Empty");
            return null;
        }
        this.log("Environment: \"" + name + "\"");
        this.log("  Value: \"" + env + "\"");
        return this.fromPath(env);
    }

    @Nullable
    JavaInstall fromPath(String path) {
        return this.fromPath(new File(path));
    }

    @Nullable
    JavaInstall fromPath(File path) {
        File exe = new File(path, "bin/java" + OS.current().exe());
        if (!exe.exists()) {
            this.log("  Missing Executable: " + exe);
            return null;
        }
        ProcessUtils.ProbeResult result = ProcessUtils.testJdk(path);
        if (result.exitCode != 0) {
            this.log("  Probe failed with exit code: " + result.exitCode);
            for (String line : result.lines) {
                this.searched.add("    " + line);
            }
        }
        return result.meta;
    }

    @Nullable
    JavaInstall fromPath(String path, int version) {
        return this.fromPath(new File(path), version);
    }

    @Nullable
    JavaInstall fromPath(File path, int version) {
        if (version < 0) {
            return this.fromPath(path);
        }
        JavaInstall result = this.fromPath(path);
        if (result == null) {
            return null;
        }
        if (result.majorVersion() != version) {
            this.log("  Wrong version: Was " + result.majorVersion() + " wanted " + version);
            return null;
        }
        return result;
    }
}

