/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.data;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Consumer;
import net.minecraftforge.mcmaven.impl.util.Artifact;
import net.minecraftforge.mcmaven.impl.util.Util;
import net.minecraftforge.util.hash.HashFunction;
import net.minecraftforge.util.hash.HashUtils;
import org.jetbrains.annotations.Nullable;

public class GradleModule {
    public String formatVersion = "1.1";
    public Component component;
    public CreatedBy createdBy;
    public List<Variant> variants;

    public static GradleModule of(Artifact artifact) {
        return GradleModule.of(artifact.getGroup(), artifact.getName(), artifact.getVersion());
    }

    public static GradleModule of(String group, String name, String version) {
        GradleModule module = new GradleModule();
        module.component = new Component(group, name, version);
        return module;
    }

    public Variant variant() {
        return this.variant(new Variant());
    }

    public Variant variant(Consumer<? super Variant> action) {
        return Util.make(this.variant(), action);
    }

    public Variant variant(Variant variant) {
        if (this.variants == null) {
            this.variants = new ArrayList<Variant>();
        }
        this.variants.removeIf(v -> Objects.equals(v.name, variant.name));
        this.variants.add(variant);
        return variant;
    }

    public static class Component {
        public String group;
        public String module;
        public String version;
        public String url;

        private Component(String group, String module, String version) {
            this.group = group;
            this.module = module;
            this.version = version;
        }
    }

    public static class Variant {
        public String name;
        public Map<String, Object> attributes;
        public List<File> files;
        public List<Dependency> dependencies;
        public List<DependencyConstraint> dependencyConstraints;
        public List<Capability> capabilities;
        public AvailableAt availableAt;

        public Variant() {
        }

        public Variant(String name) {
            this.name = name;
        }

        public void addDependency(Dependency dependency) {
            if (this.dependencies == null) {
                this.dependencies = new ArrayList<Dependency>();
            }
            this.dependencies.remove(dependency);
            this.dependencies.add(dependency);
        }

        public void addDependencies(Iterable<? extends Dependency> dependencies) {
            dependencies.forEach(this::addDependency);
        }

        public static Variant of(String name) {
            return new Variant(name);
        }

        public static Variant of(String name, Consumer<Variant> action) {
            Variant ret = new Variant(name);
            action.accept(ret);
            return ret;
        }

        public Variant attribute(Attribute attribute) {
            return this.attribute(attribute.getName(), attribute.getValue());
        }

        public Variant attribute(String key, @Nullable Object value) {
            if (value == null) {
                return this;
            }
            if (this.attributes == null) {
                this.attributes = new TreeMap<String, Object>();
            }
            this.attributes.put(key, value);
            return this;
        }

        public Variant deps(Iterable<? extends Artifact> artifacts) {
            for (Artifact artifact : artifacts) {
                this.addDependency(Dependency.of(artifact));
            }
            return this;
        }

        public Variant dep(Artifact artifact) {
            this.addDependency(Dependency.of(artifact));
            return this;
        }

        public Variant file(java.io.File file) {
            return this.file(new File(file));
        }

        public Variant file(File file) {
            if (this.files == null) {
                this.files = new ArrayList<File>();
            }
            this.files.add(file);
            return this;
        }

        public static class Dependency {
            public String group;
            public String module;
            public Version version;
            public List<Exclude> excludes;
            public String reason;
            public Map<String, Object> attributes;
            public List<Capability> requestedCapabilities;
            public Boolean endorseStrictVersions;
            public ThirdPartyCompatibility thirdPartyCompatibility;

            public String toString() {
                return "Dependency{group='" + this.group + "', module='" + this.module + "', version=" + String.valueOf(this.version) + ", attributes=" + String.valueOf(this.attributes) + ", requestedCapabilities=" + String.valueOf(this.requestedCapabilities) + ", thirdPartyCompatibility=" + String.valueOf(this.thirdPartyCompatibility) + "}";
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object obj) {
                if (this == obj) return true;
                if (!(obj instanceof Dependency)) return false;
                Dependency o = (Dependency)obj;
                if (!Objects.equals(this.group, o.group)) return false;
                if (!Objects.equals(this.module, o.module)) return false;
                if (!Objects.equals(this.attributes, o.attributes)) return false;
                if (!Objects.equals(this.thirdPartyCompatibility, o.thirdPartyCompatibility)) return false;
                return true;
            }

            public void setArtifactSelector(ThirdPartyCompatibility.ArtifactSelector selector) {
                if (this.thirdPartyCompatibility == null) {
                    this.thirdPartyCompatibility = new ThirdPartyCompatibility();
                }
                this.thirdPartyCompatibility.artifactSelector = selector;
            }

            public static Dependency of(Artifact artifact) {
                Dependency dependency = new Dependency();
                dependency.group = artifact.getGroup();
                dependency.module = artifact.getName();
                dependency.version = new Version();
                dependency.version.requires = artifact.getVersion();
                if (artifact.getClassifier() != null || !artifact.getExtension().equals("jar")) {
                    dependency.setArtifactSelector(ThirdPartyCompatibility.ArtifactSelector.of(artifact));
                }
                return dependency;
            }

            public static class Version {
                public String requires;
                public String prefers;
                public String strictly;
                public List<String> rejects;
            }

            public static class ThirdPartyCompatibility {
                public ArtifactSelector artifactSelector;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean equals(Object obj) {
                    if (this == obj) return true;
                    if (!(obj instanceof ThirdPartyCompatibility)) return false;
                    ThirdPartyCompatibility o = (ThirdPartyCompatibility)obj;
                    if (!Objects.equals(this.artifactSelector, o.artifactSelector)) return false;
                    return true;
                }

                public static class ArtifactSelector {
                    public String name;
                    public String type;
                    public String extension;
                    public String classifier;

                    public static ArtifactSelector of(Artifact artifact) {
                        return Util.make(new ArtifactSelector(), selector -> {
                            selector.name = artifact.getName();
                            selector.type = artifact.getExtension();
                            selector.extension = artifact.getExtension();
                            selector.classifier = artifact.getClassifier();
                        });
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean equals(Object obj) {
                        if (this == obj) return true;
                        if (!(obj instanceof ArtifactSelector)) return false;
                        ArtifactSelector o = (ArtifactSelector)obj;
                        if (!Objects.equals(this.name, o.name)) return false;
                        if (!Objects.equals(this.type, o.type)) return false;
                        if (!Objects.equals(this.extension, o.extension)) return false;
                        if (!Objects.equals(this.classifier, o.classifier)) return false;
                        return true;
                    }
                }
            }

            public static class Exclude {
                public String group;
                public String module;
            }
        }

        public static class File {
            public String name;
            public String url;
            public Long size;
            public String sha1;
            public String sha256;
            public String sha512;
            public String md5;

            public File(java.io.File file) {
                this(file.getName(), file);
            }

            public File(String name, java.io.File file) {
                this.name = this.url = name;
                this.size = file.length();
                try {
                    String[] hashes = HashUtils.bulkHash(file, HashFunction.SHA1, HashFunction.SHA256, HashFunction.SHA512, HashFunction.MD5);
                    this.sha1 = hashes[0];
                    this.sha256 = hashes[1];
                    this.sha512 = hashes[2];
                    this.md5 = hashes[3];
                }
                catch (IOException e) {
                    Util.sneak(e);
                }
            }
        }

        public static class AvailableAt {
            public String url;
            public String group;
            public String module;
            public String version;
        }

        public static class Capability {
            public String group;
            public String name;
            public String version;
        }

        public static class DependencyConstraint {
            public String group;
            public String module;
            public Version version;
            public String reason;
            public Map<String, Object> attributes;

            public static class Version {
                public String requires;
                public String prefers;
                public String strictly;
                public List<String> rejects;
            }
        }
    }

    public static interface Attribute {
        public String getName();

        public Object getValue();
    }

    public static class CreatedBy {
        public Gradle gradle;

        public static class Gradle {
            public String version;
            public String buildId;
        }
    }
}

