/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraftforge.mcmaven.impl.Mavenizer;
import net.minecraftforge.mcmaven.impl.cache.MinecraftMavenCache;
import net.minecraftforge.mcmaven.impl.util.Artifact;
import net.minecraftforge.mcmaven.impl.util.Util;
import net.minecraftforge.util.download.DownloadUtils;
import net.minecraftforge.util.hash.HashFunction;
import net.minecraftforge.util.hash.HashUtils;
import org.jetbrains.annotations.ApiStatus;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public sealed class MavenCache
permits MinecraftMavenCache {
    private static final HashFunction[] DEFAULT_HASHES = new HashFunction[]{HashFunction.SHA1};
    private final HashFunction[] knownHashes;
    private final File cache;
    private final String repo;
    private final List<MavenCache> foreignRepositories;

    public MavenCache(String name, String repo, File root) {
        this(name, repo, root, DEFAULT_HASHES);
    }

    @ApiStatus.Experimental
    public MavenCache(String name, String repo, File root, Map<String, String> foreignRepositories) {
        this(name, repo, root, foreignRepositories, DEFAULT_HASHES);
    }

    public MavenCache(String name, String repo, File root, HashFunction ... knownHashes) {
        this(name, repo, root, Map.of(), knownHashes);
    }

    public MavenCache(String name, String repo, File root, Map<String, String> foreignRepositories, HashFunction ... knownHashes) {
        this.cache = new File(root, "maven/" + name);
        this.repo = repo;
        this.foreignRepositories = new ArrayList<MavenCache>(foreignRepositories.size());
        for (Map.Entry<String, String> entry : foreignRepositories.entrySet()) {
            String n = entry.getKey();
            String r = entry.getValue();
            this.foreignRepositories.add(new MavenCache(n, r, root));
        }
        this.knownHashes = knownHashes;
    }

    public final File getFolder() {
        return this.cache;
    }

    public final File download(Artifact artifact) {
        try {
            return this.download(false, artifact.getPath());
        }
        catch (Exception e) {
            if (!this.foreignRepositories.isEmpty()) {
                for (MavenCache repo : this.foreignRepositories) {
                    try {
                        return repo.download(artifact);
                    }
                    catch (Exception s) {
                        e.addSuppressed(s);
                    }
                }
            }
            return (File)Util.sneak(e);
        }
    }

    public final File downloadMeta(Artifact artifact) {
        try {
            return this.download(true, artifact.getGroup().replace('.', '/') + "/" + artifact.getName() + "/maven-metadata.xml");
        }
        catch (Exception e) {
            if (!this.foreignRepositories.isEmpty()) {
                for (MavenCache repo : this.foreignRepositories) {
                    try {
                        return repo.downloadMeta(artifact);
                    }
                    catch (Exception s) {
                        e.addSuppressed(s);
                    }
                }
            }
            return (File)Util.sneak(e);
        }
    }

    public final File downloadVersionMeta(Artifact artifact) {
        try {
            return this.download(true, artifact.getFolder() + "/maven-metadata.xml");
        }
        catch (Exception e) {
            if (!this.foreignRepositories.isEmpty()) {
                for (MavenCache repo : this.foreignRepositories) {
                    try {
                        return repo.downloadVersionMeta(artifact);
                    }
                    catch (Exception s) {
                        e.addSuppressed(s);
                    }
                }
            }
            return (File)Util.sneak(e);
        }
    }

    protected File download(boolean changing, String path) throws IOException {
        File target = new File(this.cache, path);
        if (target.exists()) {
            boolean invalidHash = false;
            if (!invalidHash && changing) {
                for (HashFunction func : this.knownHashes) {
                    String rhash;
                    if (Mavenizer.isOffline() || (rhash = DownloadUtils.tryDownloadString(this.repo + path + "." + func.extension())) == null) continue;
                    try {
                        String chash = func.hash(target);
                        if (chash.equals(rhash)) break;
                        Mavenizer.LOGGER.error("Outdated cached file: " + target.getAbsolutePath());
                        Mavenizer.LOGGER.error("Expected: " + rhash);
                        Mavenizer.LOGGER.error("Actual:   " + chash);
                        invalidHash = true;
                        break;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Could not download " + this.repo + path + ", Error reading cached file", e);
                    }
                }
            }
            if (!invalidHash) {
                return target;
            }
            Mavenizer.assertNotCacheOnly();
            target.delete();
        }
        Mavenizer.assertNotCacheOnly();
        Mavenizer.assertOnline();
        this.downloadFile(target, path);
        HashUtils.updateHash(target, this.knownHashes);
        return target;
    }

    protected void downloadFile(File target, String path) throws IOException {
        DownloadUtils.downloadFile(target, this.repo + path);
    }

    public List<String> getVersions(Artifact artifact) {
        ArrayList<String> arrayList;
        File meta = this.downloadMeta(artifact);
        FileInputStream input = new FileInputStream(meta);
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(input);
            NodeList lst = doc.getElementsByTagName("version");
            ArrayList<String> ret = new ArrayList<String>();
            for (int x = 0; x < lst.getLength(); ++x) {
                ret.add(lst.item(x).getTextContent());
            }
            arrayList = ret;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)input).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw new RuntimeException("Failed to parse " + meta.getAbsolutePath(), e);
            }
        }
        ((InputStream)input).close();
        return arrayList;
    }
}

