/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.util.logging;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import net.minecraftforge.util.logging.DelegatePrintStream;
import net.minecraftforge.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLogger
implements Logger {
    @Nullable
    private static Logger.Level enabled = Logger.Level.INFO;
    final String tag;
    private static final String INDENT_STRING = "  ";
    @Nullable
    private static final String[] INDENT_CACHE = new String[127];
    private static byte indentLevel;
    @Nullable
    private static Queue<Map.Entry<Consumer<? super String>, String>> captured;
    static final DelegatePrintStream.Empty EMPTY;

    protected AbstractLogger() {
        this.tag = "";
    }

    protected AbstractLogger(String tag) {
        this.tag = '[' + tag + "] ";
    }

    @Nullable
    static Logger.Level getEnabledImpl() {
        return enabled;
    }

    static void setEnabledImpl(@Nullable Logger.Level level) {
        enabled = level;
    }

    static boolean isEnabledImpl(Logger.Level level) {
        return enabled != null && level.compareTo(enabled) >= 0;
    }

    static byte pushImpl() {
        byte by = indentLevel;
        indentLevel = (byte)(by + 1);
        return by;
    }

    static byte popImpl() {
        if ((indentLevel = (byte)(indentLevel - 1)) < 0) {
            throw new IllegalStateException("Cannot pop Log below 0");
        }
        return indentLevel;
    }

    static byte popImpl(byte indent) {
        if (indent < 0) {
            throw new IllegalArgumentException("Cannot pop Log below 0");
        }
        indentLevel = indent;
        return indentLevel;
    }

    final String getIndentationImpl() {
        String ret = INDENT_CACHE[indentLevel];
        return ret == null ? AbstractLogger.getIndentation(indentLevel) : ret;
    }

    private static String getIndentation(byte indent) {
        StringBuilder builder = new StringBuilder(INDENT_STRING.length() * indent);
        for (int i = 0; i < indent; ++i) {
            builder.append(INDENT_STRING);
        }
        return builder.toString();
    }

    static boolean isCapturingImpl() {
        return captured != null;
    }

    static void captureImpl() {
        if (captured != null) {
            return;
        }
        captured = new ConcurrentLinkedQueue<Map.Entry<Consumer<? super String>, String>>();
    }

    static void tryCapture(Consumer<? super String> logger, String message) {
        if (captured != null) {
            captured.add(new AbstractMap.SimpleImmutableEntry<Consumer<? super String>, String>(logger, message));
        } else {
            logger.accept(message);
        }
    }

    static void dropImpl() {
        captured = null;
    }

    static void releaseImpl() {
        if (captured == null) {
            return;
        }
        for (Map.Entry entry : captured) {
            ((Consumer)entry.getKey()).accept(entry.getValue());
        }
        captured = null;
    }

    static {
        AbstractLogger.INDENT_CACHE[0] = "";
        AbstractLogger.INDENT_CACHE[1] = INDENT_STRING;
        EMPTY = DelegatePrintStream.EMPTY;
    }
}

