/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.repo;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.minecraftforge.mcmaven.impl.Mavenizer;
import net.minecraftforge.mcmaven.impl.cache.Cache;
import net.minecraftforge.mcmaven.impl.data.GradleModule;
import net.minecraftforge.mcmaven.impl.mappings.Mappings;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPSide;
import net.minecraftforge.mcmaven.impl.util.Artifact;
import net.minecraftforge.mcmaven.impl.util.GradleAttributes;
import net.minecraftforge.mcmaven.impl.util.POMBuilder;
import net.minecraftforge.mcmaven.impl.util.Task;
import net.minecraftforge.mcmaven.impl.util.Util;
import net.minecraftforge.util.data.json.JsonData;
import net.minecraftforge.util.file.FileUtils;
import net.minecraftforge.util.hash.HashStore;
import net.minecraftforge.util.os.OS;
import org.jetbrains.annotations.Nullable;

public abstract class Repo {
    protected final Cache cache;

    protected Repo(Cache cache) {
        this.cache = cache;
    }

    public final Cache getCache() {
        return this.cache;
    }

    public abstract List<PendingArtifact> process(Artifact var1, Mappings var2);

    protected static PendingArtifact pending(String message, Task task, Artifact artifact, boolean auxiliary) {
        return Repo.pending(message, task, artifact, auxiliary, (Task)null);
    }

    protected static PendingArtifact pending(String message, Task task, Artifact artifact, boolean auxiliary, Supplier<GradleModule.Variant[]> variants) {
        return Repo.pending(message, task, artifact, auxiliary, Repo.variantTask(task, variants));
    }

    protected static PendingArtifact pending(String message, Task task, Artifact artifact, boolean auxiliary, @Nullable Task variants) {
        return new PendingArtifact(message, task, artifact, auxiliary, variants);
    }

    protected Supplier<GradleModule.Variant[]> sourceVariant(Mappings mappings) {
        return () -> new GradleModule.Variant[]{GradleModule.Variant.of("sources").attribute("org.gradle.status", "release").attribute("org.gradle.usage", "java-runtime").attribute("org.gradle.category", "documentation").attribute("org.gradle.dependency.bundling", "external").attribute("org.gradle.docstype", "sources").attribute("org.gradle.libraryelements", "jar").attribute("net.minecraftforge.mappings.channel", mappings.channel()).attribute("net.minecraftforge.mappings.version", mappings.version())};
    }

    protected Supplier<GradleModule.Variant[]> metadataVariant() {
        return () -> new GradleModule.Variant[]{GradleModule.Variant.of("metadata").attribute("org.gradle.status", "release").attribute("org.gradle.usage", "metadata")};
    }

    protected static Task variantTask(Task parent, Supplier<GradleModule.Variant[]> supplier) {
        return Task.named(parent.name() + "[variants]", Task.deps(parent), () -> {
            GradleModule.Variant[] variants = (GradleModule.Variant[])supplier.get();
            File variantFile = new File(parent.execute().getAbsolutePath() + ".variants");
            try {
                FileUtils.ensureParent(variantFile);
                JsonData.toJson(variants, variantFile);
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to write artifact variants: %s".formatted(variantFile), t);
            }
            return variantFile;
        });
    }

    protected Supplier<GradleModule.Variant[]> simpleVariant(String name, Mappings mappings) {
        return () -> new GradleModule.Variant[]{GradleModule.Variant.of(name).attribute("org.gradle.status", "release").attribute("org.gradle.category", "library").attribute("org.gradle.libraryelements", "jar").attribute("net.minecraftforge.mappings.channel", mappings.channel()).attribute("net.minecraftforge.mappings.version", mappings.version())};
    }

    protected GradleModule.Variant[] classVariants(Mappings mappings, MCPSide side) {
        return this.classVariants(mappings, side, List.of(), List.of(), List.of());
    }

    protected GradleModule.Variant[] classVariants(Mappings mappings, MCPSide side, Collection<Artifact> extraDeps, Collection<Artifact> extraCompileDeps, Collection<Artifact> extraRuntimeDeps) {
        Object variant;
        ArrayList<Artifact> all = new ArrayList<Artifact>();
        HashMap<GradleAttributes.OperatingSystemFamily, List> natives = new HashMap<GradleAttributes.OperatingSystemFamily, List>();
        for (Artifact artifact : side.getMCLibraries()) {
            EnumSet<GradleAttributes.OperatingSystemFamily> osVariants = EnumSet.noneOf(GradleAttributes.OperatingSystemFamily.class);
            for (OS oS : artifact.getOs()) {
                variant = GradleAttributes.OperatingSystemFamily.from(oS);
                if (variant == null) continue;
                osVariants.add((GradleAttributes.OperatingSystemFamily)variant);
            }
            if (osVariants.isEmpty()) {
                all.add(artifact);
                continue;
            }
            for (GradleAttributes.OperatingSystemFamily operatingSystemFamily2 : osVariants) {
                natives.computeIfAbsent(operatingSystemFamily2, operatingSystemFamily -> new ArrayList()).add(artifact);
            }
        }
        all.addAll(side.getMCPConfigLibraries());
        for (Artifact extra : extraDeps) {
            if (extra == null) continue;
            all.add(extra);
        }
        Integer java = Util.replace(JsonData.minecraftVersion(side.getMCP().getMinecraftTasks().versionJson.execute()), v -> v.javaVersion != null ? Integer.valueOf(v.javaVersion.majorVersion) : null);
        Consumer<GradleModule.Variant> common = v -> {
            v.attribute("org.gradle.status", "release").attribute("org.gradle.usage", "java-runtime").attribute("org.gradle.category", "library").attribute("org.gradle.dependency.bundling", "external").attribute("org.gradle.libraryelements", "jar").attribute("org.gradle.jvm.environment", "standard-jvm").attribute("net.minecraftforge.mappings.channel", mappings.channel()).attribute("net.minecraftforge.mappings.version", mappings.version());
            if (java != null) {
                v.attribute("org.gradle.jvm.version", java);
            }
            v.deps(all);
        };
        ArrayList<Object> variants = new ArrayList<Object>();
        for (Map.Entry entry : natives.entrySet()) {
            variant = GradleModule.Variant.of("classes-" + ((GradleAttributes.OperatingSystemFamily)entry.getKey()).getValue(), common);
            ((GradleModule.Variant)variant).attribute((GradleModule.Attribute)entry.getKey());
            ((GradleModule.Variant)variant).deps((Iterable)entry.getValue());
            variants.add(variant);
        }
        GradleModule.Variant apiVariant = GradleModule.Variant.of("api-classes", common);
        apiVariant.attribute("org.gradle.usage", "java-api");
        apiVariant.deps(extraCompileDeps);
        variants.add(apiVariant);
        return variants.toArray(new GradleModule.Variant[0]);
    }

    protected static Task simplePom(File build, Artifact artifact) {
        return Task.named("pom[" + artifact.getName() + "]", () -> {
            File output = new File(build, artifact.getName() + "-" + artifact.getVersion() + ".pom");
            HashStore cache = HashStore.fromFile(output);
            if (output.exists() && cache.isSame()) {
                return output;
            }
            Mavenizer.assertNotCacheOnly();
            POMBuilder builder = new POMBuilder(artifact.getGroup(), artifact.getName(), artifact.getVersion());
            FileUtils.ensureParent(output);
            try (FileOutputStream os = new FileOutputStream(output);){
                os.write(builder.build().getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException | ParserConfigurationException | TransformerException e) {
                Util.sneak(e);
            }
            cache.save();
            return output;
        });
    }

    protected List<PendingArtifact> mappingArtifacts(File cache, Mappings mappings, MCPSide side) {
        Artifact coords = mappings.getArtifact(side);
        PendingArtifact csvs = Repo.pending("Mappings Zip", mappings.getCsvZip(side), coords, false);
        PendingArtifact pom = Repo.pending("Mappings POM", Repo.simplePom(cache, coords), coords.withExtension("pom"), false);
        PendingArtifact m2o = Repo.pending("Mappings map2obf", mappings.getMapped2Obf(side), coords.withClassifier("map2obf").withExtension("tsrg.gz"), false);
        PendingArtifact m2s = Repo.pending("Mappings map2srg", mappings.getMapped2Srg(side), coords.withClassifier("map2srg").withExtension("tsrg.gz"), false);
        return List.of(csvs, pom, m2o, m2s);
    }

    public record PendingArtifact(String message, Task task, Artifact artifact, boolean auxiliary, @Nullable Task variants) implements Supplier<File>
    {
        @Override
        public File get() {
            if (this.task.resolved()) {
                return this.task.execute();
            }
            try {
                Mavenizer.LOGGER.info(this.message);
                Mavenizer.LOGGER.push();
                File file = this.task.execute();
                return file;
            }
            finally {
                if (this.variants != null) {
                    this.variants.execute();
                }
                Mavenizer.LOGGER.pop();
            }
        }

        public Task getAsTask() {
            return this.task;
        }

        public PendingArtifact withVariants(Supplier<GradleModule.Variant[]> variants) {
            return new PendingArtifact(this.message, this.task, this.artifact, this.auxiliary, Repo.variantTask(this.task, variants));
        }
    }
}

