/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.mappings;

import de.siegmar.fastcsv.reader.CsvReader;
import de.siegmar.fastcsv.reader.NamedCsvRecord;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.mcmaven.impl.Mavenizer;
import net.minecraftforge.mcmaven.impl.mappings.ParchmentMappings;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPSide;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MinecraftTasks;
import net.minecraftforge.mcmaven.impl.util.Artifact;
import net.minecraftforge.mcmaven.impl.util.Constants;
import net.minecraftforge.mcmaven.impl.util.ProcessUtils;
import net.minecraftforge.mcmaven.impl.util.Task;
import net.minecraftforge.mcmaven.impl.util.Util;
import net.minecraftforge.srgutils.IMappingFile;
import net.minecraftforge.srgutils.IRenamer;
import net.minecraftforge.util.hash.HashStore;
import org.jetbrains.annotations.Nullable;

public class Mappings {
    public static final String CHANNEL_ATTR = "net.minecraftforge.mappings.channel";
    public static final String VERSION_ATTR = "net.minecraftforge.mappings.version";
    protected final Map<Key, Task> tasks = new HashMap<Key, Task>();
    private final String channel;
    @Nullable
    private final String version;

    public static Mappings of(String mappingsNotation) {
        String[] split = mappingsNotation.split(":", 2);
        String channel = split[0];
        String version = split.length > 1 ? split[1] : null;
        return "parchment".equalsIgnoreCase(channel) ? new ParchmentMappings(version) : new Mappings(channel, version);
    }

    public static Data load(File data) throws IOException {
        HashMap<String, String> names = new HashMap<String, String>();
        HashMap<String, String> docs = new HashMap<String, String>();
        try (ZipFile zip = new ZipFile(data);){
            List<ZipEntry> entries = zip.stream().filter(e -> e.getName().endsWith(".csv")).toList();
            for (ZipEntry entry : entries) {
                CsvReader<NamedCsvRecord> reader = CsvReader.builder().ofNamedCsvRecord(new InputStreamReader(zip.getInputStream(entry)));
                try {
                    for (NamedCsvRecord row : reader) {
                        String desc;
                        List<String> header = row.getHeader();
                        String obf = header.contains("searge") ? "searge" : "param";
                        String searge = row.getField(obf);
                        names.put(searge, row.getField("name"));
                        if (!header.contains("desc") || (desc = row.getField("desc")).isBlank()) continue;
                        docs.put(searge, desc);
                    }
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
        }
        return new Data(names, docs);
    }

    public Mappings(String channel, @Nullable String version) {
        this.channel = channel;
        this.version = version;
    }

    public String channel() {
        return this.channel;
    }

    @Nullable
    public String version() {
        return this.version;
    }

    public String toString() {
        return this.channel() + (String)(this.version() == null ? "" : "-" + this.version());
    }

    public File getFolder(File root) {
        return new File(root, this.channel() + "/" + this.version());
    }

    public boolean isPrimary() {
        return true;
    }

    public Mappings withMCVersion(String version) {
        return new Mappings(this.channel(), version);
    }

    public Artifact getArtifact(MCPSide side) {
        String mcpVersion = side.getMCP().getName().getVersion();
        String mcVersion = side.getMCP().getConfig().version;
        Object artifactVersion = mcpVersion;
        if (this.version != null && !mcVersion.equals(this.version)) {
            artifactVersion = mcpVersion + "-" + this.version;
        }
        return Artifact.from("net.minecraft", "mappings_" + this.channel, (String)artifactVersion).withExtension("zip");
    }

    public Task getCsvZip(MCPSide side) {
        Key key = new Key(Tasks.CSVs, side);
        Task ret = this.tasks.get(key);
        if (ret != null) {
            return ret;
        }
        MinecraftTasks mc = side.getMCP().getMinecraftTasks();
        Task srg = side.getTasks().getMappings();
        Task client = mc.versionFile(MinecraftTasks.Files.CLIENT_MAPPINGS);
        Task server = mc.versionFile(MinecraftTasks.Files.SERVER_MAPPINGS);
        ret = Task.named("srg2names[" + String.valueOf(this) + "]", Task.deps(srg, client, server), () -> this.getMappings(side, srg, client, server));
        this.tasks.put(key, ret);
        return ret;
    }

    public Task getMapped2Srg(MCPSide side) {
        return this.getTsrg(side, Tasks.MappedToSrg);
    }

    public Task getMapped2Obf(MCPSide side) {
        return this.getTsrg(side, Tasks.MappedToObf);
    }

    private Task getTsrg(MCPSide side, Tasks type) {
        Key key = new Key(type, side);
        Task ret = this.tasks.get(key);
        if (ret != null) {
            return ret;
        }
        Task srg = side.getTasks().getMappings();
        Task csv = this.getCsvZip(side);
        ret = Task.named(type.name + "[" + String.valueOf(this) + "]", Task.deps(srg, csv), () -> this.makeTsrg(side, srg, csv, type == Tasks.MappedToObf));
        this.tasks.put(key, ret);
        return ret;
    }

    private File getMappings(MCPSide side, Task srgMappings, Task clientTask, Task serverTask) {
        File jdk;
        File tool = side.getMCP().getCache().maven().download(Constants.INSTALLER_TOOLS);
        File root = this.getFolder(new File(side.getMCP().getBuildFolder(), "data/mapings"));
        File output = new File(root, "official.zip");
        File log = new File(root, "official.log");
        File mappings = srgMappings.execute();
        File client = clientTask.execute();
        File server = serverTask.execute();
        HashStore cache = HashStore.fromFile(output);
        cache.add("tool", tool);
        cache.add("mappings", mappings);
        cache.add("client", client);
        cache.add("server", server);
        if (output.exists() && cache.isSame()) {
            return output;
        }
        Mavenizer.assertNotCacheOnly();
        List<String> args = List.of("--task", "MAPPINGS_CSV", "--srg", mappings.getAbsolutePath(), "--client", client.getAbsolutePath(), "--server", server.getAbsolutePath(), "--output", output.getAbsolutePath());
        try {
            jdk = side.getMCP().getCache().jdks().get(8);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to find JDK for version 8", e);
        }
        ProcessUtils.Result ret = ProcessUtils.runJar(jdk, log.getParentFile(), log, tool, Collections.emptyList(), args);
        if (ret.exitCode != 0) {
            throw new IllegalStateException("Failed to run MCP Step (exit code " + ret.exitCode + "), See log: " + log.getAbsolutePath());
        }
        cache.save();
        return output;
    }

    private File makeTsrg(MCPSide side, Task srgTask, Task csvTask, boolean toObf) {
        File root = this.getFolder(new File(side.getMCP().getBuildFolder(), "data/mapings"));
        File output = new File(root, this.channel() + "-" + this.version + "-" + (toObf ? "srg" : "obf") + ".tsrg.gz");
        File srg = srgTask.execute();
        File csv = csvTask.execute();
        HashStore cache = HashStore.fromFile(output).add("srg", srg).add("csv", csv);
        if (output.exists() && cache.isSame()) {
            return output;
        }
        try {
            final Map<String, String> names = Mappings.load(csv).names();
            IMappingFile map = IMappingFile.load(srg);
            if (!toObf) {
                map = map.reverse().chain(map);
            }
            map = map.rename(new IRenamer(){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public String rename(IMappingFile.IField value) {
                    return names.getOrDefault(value.getMapped(), value.getMapped());
                }

                @Override
                public String rename(IMappingFile.IMethod value) {
                    return names.getOrDefault(value.getMapped(), value.getMapped());
                }

                @Override
                public String rename(IMappingFile.IParameter value) {
                    return names.getOrDefault(value.getMapped(), value.getMapped());
                }
            });
            map.write(output.getAbsoluteFile().toPath(), IMappingFile.Format.TSRG2, true);
        }
        catch (IOException e) {
            Util.sneak(e);
        }
        cache.save();
        return output;
    }

    public record Data(Map<String, String> names, Map<String, String> docs) {
    }

    protected record Key(Tasks type, MCPSide side) {
    }

    protected static enum Tasks {
        CSVs("srg2names"),
        MappedToSrg("mapped2srg"),
        MappedToObf("mapped2obf");

        private final String name;

        private Tasks(String name) {
            this.name = name;
        }
    }
}

