/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.cli;

import java.time.Duration;
import java.util.ArrayList;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraftforge.mcmaven.cli.JarVersionInfo;
import net.minecraftforge.mcmaven.cli.Tasks;
import net.minecraftforge.mcmaven.impl.Mavenizer;

public class Main {
    private static final String DISPLAY_NAME = "Minecraft Mavenizer";

    public static void main(String[] args) throws Exception {
        long start = System.nanoTime();
        try {
            Mavenizer.LOGGER.capture();
            Mavenizer.LOGGER.info(JarVersionInfo.of(DISPLAY_NAME, Main.class).implementation());
            Main.run(args);
        }
        catch (Throwable e) {
            Mavenizer.LOGGER.release();
            throw e;
        }
        Duration time = Duration.ofNanos(System.nanoTime() - start);
        if (Mavenizer.LOGGER.isCapturing()) {
            Mavenizer.LOGGER.drop();
            Mavenizer.LOGGER.getInfo().print("Minecraft Maven is up-to-date");
        } else {
            Mavenizer.LOGGER.getInfo().print("Minecraft Maven has finished");
        }
        Mavenizer.LOGGER.getInfo().printf(", took %d:%02d.%03d%n", time.toMinutesPart(), time.toSecondsPart(), time.toMillisPart());
    }

    private static void run(String[] args) throws Exception {
        OptionParser parser = new OptionParser();
        parser.allowsUnrecognizedOptions();
        Tasks[] tasks = Tasks.values();
        ArrayList<OptionSpecBuilder> opts = new ArrayList<OptionSpecBuilder>();
        for (Tasks task : tasks) {
            opts.add(parser.accepts(task.key, task.description));
        }
        for (OptionSpecBuilder opt : opts) {
            for (OptionSpecBuilder o : opts) {
                if (o == opt) continue;
                opt.availableUnless(o, new OptionSpec[0]);
            }
        }
        OptionSet options = parser.parse(args);
        for (Tasks task : tasks) {
            if (!options.has(task.key)) continue;
            task.callback.run(args);
            return;
        }
        parser.printHelpOn(Mavenizer.LOGGER.getInfo());
        Mavenizer.LOGGER.release();
    }
}

