/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.util.data.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.ToNumberPolicy;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraftforge.util.data.json.AssetsIndex;
import net.minecraftforge.util.data.json.Config;
import net.minecraftforge.util.data.json.LauncherManifest;
import net.minecraftforge.util.data.json.MCPConfig;
import net.minecraftforge.util.data.json.MinecraftVersion;
import net.minecraftforge.util.data.json.PatcherConfig;
import net.minecraftforge.util.data.json.PromosSlim;
import net.minecraftforge.util.data.json.RunConfig;

public class JsonData {
    private static final Gson GSON = new GsonBuilder().setObjectToNumberStrategy(JsonData::readNumber).setPrettyPrinting().create();

    private static Number readNumber(JsonReader in) throws IOException {
        try {
            return ToNumberPolicy.LONG_OR_DOUBLE.readNumber(in);
        }
        catch (Throwable suppressed) {
            try {
                return ToNumberPolicy.BIG_DECIMAL.readNumber(in);
            }
            catch (Throwable e) {
                IOException throwing = new IOException("Failed to read number from " + in, e);
                throwing.addSuppressed(suppressed);
                throw throwing;
            }
        }
    }

    public static AssetsIndex assetsIndex(File file) {
        return JsonData.fromJson(file, AssetsIndex.class);
    }

    public static AssetsIndex assetsIndex(InputStream stream) {
        return JsonData.fromJson(stream, AssetsIndex.class);
    }

    public static AssetsIndex assetsIndex(byte[] data) {
        return JsonData.fromJson(data, AssetsIndex.class);
    }

    public static int configSpec(File file) {
        return JsonData.fromJson((File)file, Config.class).spec;
    }

    public static int configSpec(InputStream stream) {
        return JsonData.fromJson((InputStream)stream, Config.class).spec;
    }

    public static int configSpec(byte[] data) {
        return JsonData.fromJson((byte[])data, Config.class).spec;
    }

    public static LauncherManifest launcherManifest(File file) {
        return JsonData.fromJson(file, LauncherManifest.class);
    }

    public static LauncherManifest launcherManifest(InputStream stream) {
        return JsonData.fromJson(stream, LauncherManifest.class);
    }

    public static LauncherManifest launcherManifest(byte[] data) {
        return JsonData.fromJson(data, LauncherManifest.class);
    }

    public static MCPConfig mcpConfig(File file) {
        return JsonData.fromJson(file, MCPConfig.class);
    }

    public static MCPConfig mcpConfig(InputStream stream) {
        return JsonData.fromJson(stream, MCPConfig.class);
    }

    public static MCPConfig mcpConfig(byte[] data) {
        return JsonData.fromJson(data, MCPConfig.class);
    }

    public static MCPConfig.V2 mcpConfigV2(File file) {
        return JsonData.fromJson(file, MCPConfig.V2.class);
    }

    public static MCPConfig.V2 mcpConfigV2(InputStream stream) {
        return JsonData.fromJson(stream, MCPConfig.V2.class);
    }

    public static MCPConfig.V2 mcpConfigV2(byte[] data) {
        return JsonData.fromJson(data, MCPConfig.V2.class);
    }

    public static MinecraftVersion minecraftVersion(File file) {
        return JsonData.fromJson(file, MinecraftVersion.class);
    }

    public static MinecraftVersion minecraftVersion(InputStream stream) {
        return JsonData.fromJson(stream, MinecraftVersion.class);
    }

    public static MinecraftVersion minecraftVersion(byte[] data) {
        return JsonData.fromJson(data, MinecraftVersion.class);
    }

    public static PatcherConfig patcherConfig(File file) {
        return JsonData.fromJson(file, PatcherConfig.class);
    }

    public static PatcherConfig patcherConfig(InputStream stream) {
        return JsonData.fromJson(stream, PatcherConfig.class);
    }

    public static PatcherConfig patcherConfig(byte[] data) {
        return JsonData.fromJson(data, PatcherConfig.class);
    }

    public static PatcherConfig.V2 patcherConfigV2(File file) {
        return JsonData.fromJson(file, PatcherConfig.V2.class);
    }

    public static PatcherConfig.V2 patcherConfigV2(InputStream stream) {
        return JsonData.fromJson(stream, PatcherConfig.V2.class);
    }

    public static PatcherConfig.V2 patcherConfigV2(byte[] data) {
        return JsonData.fromJson(data, PatcherConfig.V2.class);
    }

    public static PromosSlim promosSlim(File file) {
        return JsonData.fromJson(file, PromosSlim.class);
    }

    public static PromosSlim promosSlim(InputStream stream) {
        return JsonData.fromJson(stream, PromosSlim.class);
    }

    public static PromosSlim promosSlim(byte[] data) {
        return JsonData.fromJson(data, PromosSlim.class);
    }

    public static PromosSlim promosSlim(String data) {
        return JsonData.fromJson(data, PromosSlim.class);
    }

    public static RunConfig runConfig(File file) {
        return JsonData.fromJson(file, RunConfig.class);
    }

    public static RunConfig runConfig(InputStream stream) {
        return JsonData.fromJson(stream, RunConfig.class);
    }

    public static RunConfig runConfig(byte[] data) {
        return JsonData.fromJson(data, RunConfig.class);
    }

    public static RunConfig runConfig(String data) {
        return JsonData.fromJson(data, RunConfig.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T fromJson(File file, Class<T> classOfT) throws JsonSyntaxException, JsonIOException {
        try (FileInputStream stream = new FileInputStream(file);){
            T t = JsonData.fromJson((InputStream)stream, classOfT);
            return t;
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    public static <T> T fromJson(byte[] data, Class<T> classOfT) throws JsonSyntaxException, JsonIOException {
        return JsonData.fromJson((InputStream)new ByteArrayInputStream(data), classOfT);
    }

    public static <T> T fromJson(InputStream stream, Class<T> classOfT) throws JsonSyntaxException, JsonIOException {
        return GSON.fromJson((Reader)new InputStreamReader(stream), classOfT);
    }

    public static <T> T fromJson(String data, Class<T> classOfT) throws JsonSyntaxException, JsonIOException {
        return GSON.fromJson(data, classOfT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T fromJson(File file, TypeToken<T> classOfT) throws JsonSyntaxException, JsonIOException {
        try (FileInputStream stream = new FileInputStream(file);){
            T t = JsonData.fromJson((InputStream)stream, classOfT);
            return t;
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    public static <T> T fromJson(byte[] data, TypeToken<T> classOfT) throws JsonSyntaxException, JsonIOException {
        return JsonData.fromJson((InputStream)new ByteArrayInputStream(data), classOfT);
    }

    public static <T> T fromJson(InputStream stream, TypeToken<T> classOfT) throws JsonSyntaxException, JsonIOException {
        return GSON.fromJson((Reader)new InputStreamReader(stream), classOfT);
    }

    public static <T> T fromJson(String data, TypeToken<T> classOfT) throws JsonSyntaxException, JsonIOException {
        return GSON.fromJson(data, classOfT);
    }

    public static String toJson(Object src) {
        return GSON.toJson(src);
    }

    public static void toJson(Object src, File file) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(src, (Appendable)writer);
        }
    }
}

