/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.util;

import java.io.File;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.SequencedCollection;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import net.minecraftforge.mcmaven.impl.Mavenizer;
import net.minecraftforge.mcmaven.impl.util.Util;

public interface Task {
    public File execute();

    public boolean resolved();

    public String name();

    public static Task named(String name, Callable<File> supplier) {
        return Task.named(name, List.of(), supplier);
    }

    public static Task named(String name, SequencedCollection<? extends Supplier<? extends Task>> deps, Callable<File> supplier) {
        return new Simple(name, deps, supplier);
    }

    public static SequencedCollection<Supplier<Task>> deps(Task ... tasks) {
        return Arrays.stream(tasks).map(Util::supplyingSelf).toList();
    }

    @SafeVarargs
    public static SequencedCollection<? extends Supplier<? extends Task>> deps(Supplier<? extends Task> ... tasks) {
        return List.of(tasks);
    }

    public static SequencedCollection<Supplier<Task>> deps(Iterable<?> tasks) {
        return StreamSupport.stream(tasks.spliterator(), false).map(Task::cast).toList();
    }

    private static Supplier<Task> cast(Object obj) {
        return () -> {
            Object object;
            if (obj instanceof Supplier) {
                Supplier supplier = (Supplier)obj;
                object = supplier.get();
            } else {
                object = obj;
            }
            Object ret = object;
            try {
                return (Task)Objects.requireNonNull(ret);
            }
            catch (ClassCastException | NullPointerException e) {
                throw new IllegalArgumentException("Expected Task or Supplier<Task>, found %s".formatted(ret != null ? ret.getClass() : "null"));
            }
        };
    }

    public static final class Simple
    implements Task {
        private final String name;
        private final SequencedCollection<? extends Supplier<? extends Task>> deps;
        private final Callable<File> supplier;
        private File file;

        private Simple(String name, SequencedCollection<? extends Supplier<? extends Task>> deps, Callable<File> supplier) {
            this.name = name;
            this.deps = deps;
            this.supplier = supplier;
        }

        @Override
        public File execute() {
            if (this.file == null) {
                for (Supplier supplier : this.deps) {
                    Task task = (Task)supplier.get();
                    if (task == null) continue;
                    try {
                        task.execute();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to execute task `%s` which is required by task `%s`".formatted(task.name(), this.name()), e);
                    }
                }
                Mavenizer.LOGGER.info(this.name);
                byte indent = Mavenizer.LOGGER.push();
                long l = System.nanoTime();
                try {
                    this.file = this.supplier.call();
                    Duration time = Duration.ofNanos(System.nanoTime() - l);
                    Mavenizer.LOGGER.debug(String.format("-> took %d:%02d.%03d", time.toMinutesPart(), time.toSecondsPart(), time.toMillisPart()));
                    Mavenizer.LOGGER.debug("-> " + this.file.getAbsolutePath());
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to execute task `%s`".formatted(this.name()), e);
                }
                finally {
                    Mavenizer.LOGGER.pop(indent);
                }
            }
            return this.file;
        }

        @Override
        public boolean resolved() {
            return this.file != null;
        }

        @Override
        public String name() {
            return this.name;
        }

        public String toString() {
            return "Task[" + this.name + "]";
        }
    }

    public record Existing(String name, File execute) implements Task
    {
        @Override
        public boolean resolved() {
            return true;
        }

        @Override
        public String toString() {
            return "Task[" + this.name + "]";
        }
    }
}

