/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.cache;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraftforge.java_provisioner.api.JavaInstall;
import net.minecraftforge.java_provisioner.api.JavaLocator;
import net.minecraftforge.java_provisioner.api.JavaProvisioner;
import net.minecraftforge.mcmaven.impl.Mavenizer;
import net.minecraftforge.util.logging.Logger;

public final class JDKCache {
    private boolean attemptedLocate = false;
    private final List<Throwable> attemptedLocateErrors = new ArrayList<Throwable>();
    private final File root;
    private final Map<Integer, File> jdks = new HashMap<Integer, File>();
    private final JavaProvisioner disco;

    public JDKCache(File cache) {
        this.root = cache;
        this.disco = JavaLocator.disco(cache, Mavenizer.isOffline());
    }

    public File root() {
        return this.root;
    }

    public File get(int version) throws Exception {
        File ret;
        if (!this.attemptedLocate) {
            this.attemptLocate();
        }
        if ((ret = this.jdks.get(version)) != null) {
            return ret;
        }
        try {
            ret = this.disco.provision(version).home();
        }
        catch (Exception e) {
            Mavenizer.LOGGER.error("Failed to provision JDK " + version);
            e.printStackTrace(Mavenizer.LOGGER.getLog(Logger.Level.ERROR));
            throw e;
        }
        File old = this.jdks.putIfAbsent(version, ret);
        if (old != null) {
            Mavenizer.LOGGER.error("JDKCache: Downloaded JDK " + version + " is replacing an existing download! It was probably downloaded by another thread.");
            Mavenizer.LOGGER.error("JDKCache: Old JDK: " + String.valueOf(old));
        }
        return ret;
    }

    private void attemptLocate() {
        if (this.attemptedLocate) {
            return;
        }
        this.attemptedLocate = true;
        ArrayList<JavaLocator> locators = new ArrayList<JavaLocator>();
        locators.add(JavaLocator.home());
        locators.add(JavaLocator.gradle());
        locators.add(this.disco);
        ArrayList<JavaInstall> installs = new ArrayList<JavaInstall>();
        for (JavaLocator locator : locators) {
            try {
                installs.addAll(locator.findAll());
            }
            catch (Exception e) {
                this.attemptedLocateErrors.add(e);
            }
        }
        HashSet seen = new HashSet();
        installs.removeIf(install -> !seen.add(install.home()));
        Collections.sort(installs);
        for (JavaInstall install2 : installs) {
            if (!install2.isJdk() || install2.majorVersion() <= 0) continue;
            this.jdks.putIfAbsent(install2.majorVersion(), install2.home());
        }
    }
}

