/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.java_provisioner;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.java_provisioner.DiscoLocator;
import net.minecraftforge.java_provisioner.GradleLocator;
import net.minecraftforge.java_provisioner.JavaDirectoryLocator;
import net.minecraftforge.java_provisioner.JavaHomeLocator;
import net.minecraftforge.java_provisioner.JavaVersion;
import net.minecraftforge.java_provisioner.ProcessUtils;
import net.minecraftforge.java_provisioner.api.Distro;
import net.minecraftforge.java_provisioner.api.JavaLocator;
import net.minecraftforge.java_provisioner.api.JavaProvisioner;
import net.minecraftforge.util.download.DownloadUtils;
import net.minecraftforge.util.hash.HashFunction;
import net.minecraftforge.util.os.OS;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.kamranzafar.jtar.TarEntry;
import org.kamranzafar.jtar.TarInputStream;

@VisibleForTesting
public class Disco {
    private static final int CACHE_TIMEOUT = 43200000;
    private static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().registerTypeAdapter((Type)((Object)String.class), new TypeAdapter<String>(){

        @Override
        public void write(JsonWriter out, String value) throws IOException {
            if (value == null || value.isEmpty()) {
                out.nullValue();
            } else {
                TypeAdapters.STRING.write(out, value);
            }
        }

        @Override
        public String read(JsonReader in) throws IOException {
            String value = TypeAdapters.STRING.read(in);
            return value != null && value.isEmpty() ? null : value;
        }
    }).create();
    private final File cache;
    private final String provider;
    private final boolean offline;

    public Disco(File cache) {
        this(cache, "https://api.foojay.io/disco/v3.0");
    }

    public Disco(File cache, boolean offline) {
        this(cache, "https://api.foojay.io/disco/v3.0", offline);
    }

    public Disco(File cache, String provider) {
        this(cache, provider, false);
    }

    public Disco(File cache, String provider, boolean offline) {
        this.cache = cache;
        this.provider = provider;
        this.offline = offline;
    }

    protected void debug(String message) {
        System.out.println(message);
    }

    protected void error(String message) {
        System.err.println(message);
    }

    public List<Package> getPackages() {
        Response<Package> resp;
        String data;
        File tmp = new File(this.cache, "packages.json");
        List<Package> ret = this.readJson(tmp, new TypeToken<List<Package>>(){});
        if (ret != null) {
            return ret;
        }
        if (this.offline) {
            this.error("Cannot download package list while offline");
            return Collections.emptyList();
        }
        String url = this.provider + "/packages/?&package_type=jdk&directly_downloadable=true&archive_type=zip,tar,tar.gz,tgz";
        this.debug("Downloading package list");
        try {
            data = DownloadUtils.downloadString(url);
        }
        catch (IOException e) {
            this.error("Failed to download package list from " + url + ": " + e);
            return Collections.emptyList();
        }
        try {
            resp = Response.of(data, Package.class);
        }
        catch (Exception e) {
            this.error("Failed to parse package list from " + url + ": " + e);
            return Collections.emptyList();
        }
        if (resp.entries().isEmpty()) {
            this.error("Failed to download any packages from " + url);
            return Collections.emptyList();
        }
        try {
            Disco.writeJson(tmp, resp.entries(), List.class);
        }
        catch (IOException e) {
            this.error("Failed to write package list to " + tmp.getAbsolutePath() + ": " + e);
            return Collections.emptyList();
        }
        return resp.entries();
    }

    public List<Package> getPackages(int version) {
        return this.getPackages(version, OS.current(), null, Arch.CURRENT);
    }

    public List<Package> getPackages(int version, OS os, Distro distro, Arch arch) {
        List<Package> jdks = this.getPackages();
        if (jdks == null) {
            return null;
        }
        int max_jdk_version = -1;
        ArrayList<Package> ret = new ArrayList<Package>();
        for (Package pkg : jdks) {
            Arch parch;
            if (version != -1 && pkg.jdk_version != version || os != null && pkg.os() != os || distro != null && pkg.distro() != distro || arch != null && arch != (parch = pkg.arch()) && (arch.parent == null || arch.parent != parch) || LibC.CURRENT != LibC.MUSL && pkg.libC() == LibC.MUSL) continue;
            if (max_jdk_version < pkg.jdk_version) {
                max_jdk_version = pkg.jdk_version;
            }
            ret.add(pkg);
        }
        if (version == -1) {
            Iterator itr = ret.iterator();
            while (itr.hasNext()) {
                Package pkg;
                pkg = (Package)itr.next();
                if (pkg.jdk_version >= max_jdk_version) continue;
                itr.remove();
            }
        }
        Collections.sort(ret);
        return ret;
    }

    @Nullable
    public PackageInfo getInfo(Package pkg) {
        Response<PackageInfo> resp;
        String data;
        File tmp = new File(this.cache, pkg.filename + ".json");
        DownloadInfo ret = this.readJson(tmp, TypeToken.get(DownloadInfo.class));
        if (ret != null) {
            return ret.info;
        }
        this.error("Failed to read package info from " + tmp.getAbsolutePath());
        if (this.offline) {
            this.error("Cannot download package info while offline");
            return null;
        }
        String url = this.provider + "/ids/" + pkg.id;
        try {
            data = DownloadUtils.downloadString(url);
        }
        catch (IOException e) {
            this.error("Failed to download package info from " + url + " : " + e);
            return null;
        }
        try {
            resp = Response.of(data, PackageInfo.class);
        }
        catch (Exception e) {
            this.error("Failed to parse package info from " + url + " : " + e);
            return null;
        }
        if (resp.entries().isEmpty()) {
            this.error("Failed to download any packages from " + url);
            return null;
        }
        if (resp.entries().size() != 1) {
            this.debug("Warning: Multiple package infos returned from " + url);
        }
        ret = new DownloadInfo(pkg, resp.entries().get(0));
        try {
            Disco.writeJson(tmp, ret, DownloadInfo.class);
        }
        catch (IOException e) {
            this.error("Failed to write package info to " + tmp.getAbsolutePath() + " : " + e);
            return null;
        }
        return ret.info;
    }

    @Nullable
    public File download(Package pkg) {
        HashFunction func;
        EnumMap<HashFunction, String> checksums = new EnumMap<HashFunction, String>(HashFunction.class);
        String download = pkg.links.pkg_download_redirect;
        try {
            PackageInfo info = this.getInfo(pkg);
            if (info.checksum != null && info.checksum_type != null) {
                HashFunction func2 = HashFunction.find(info.checksum_type);
                if (func2 != null) {
                    checksums.put(func2, info.checksum);
                } else {
                    this.debug("Unknown Checksum " + info.checksum_type + ": " + info.checksum);
                }
            } else if (info.checksum_uri != null && !this.offline) {
                try {
                    String raw = DownloadUtils.downloadString(info.checksum_uri);
                    String checksum = raw.split(" ")[0];
                    func = HashFunction.findByHash(checksum);
                    if (func != null) {
                        checksums.put(func, checksum);
                    } else {
                        this.debug("Unknown Checksum " + checksum);
                    }
                }
                catch (IOException e) {
                    this.error("Failed to download checksum from " + info.checksum_uri + " : " + e);
                }
            }
            if (info.direct_download_uri != null) {
                download = info.direct_download_uri;
            }
        }
        catch (Exception e) {
            this.debug("Failed to download package info for \"" + pkg.filename + "\" (" + pkg.id + ") , assuming redirect link is valid : " + e);
        }
        File archive = new File(this.cache, pkg.filename);
        if (!archive.exists()) {
            if (download == null) {
                String message = this.offline ? "Offline mode, can't download " + pkg.filename + " (" + pkg.id + ")" : "Failed to find download link for " + pkg.filename + " (" + pkg.id + ")";
                this.error(message);
                return null;
            }
            this.debug("Downloading " + download);
            try {
                DownloadUtils.downloadFile(archive, download);
            }
            catch (Exception e) {
                String message = "Failed to download " + pkg.filename + " from " + download;
                this.error(message);
                return null;
            }
        }
        if (!checksums.isEmpty()) {
            this.debug("Verifying checksums");
            for (Map.Entry entry : checksums.entrySet()) {
                func = (HashFunction)((Object)entry.getKey());
                try {
                    String actual = func.hash(archive);
                    String expected = (String)entry.getValue();
                    if (expected.equals(actual)) {
                        this.debug("  " + func.name() + " Validated");
                        continue;
                    }
                    this.debug("  " + func.name() + " Invalid");
                    this.debug("    Expected: " + expected);
                    this.debug("    Actual:   " + actual);
                    return null;
                }
                catch (Exception e) {
                    String message = "Failed to calculate " + func.name() + " checksum";
                    this.error(message + " : " + e);
                    return null;
                }
            }
        } else {
            this.debug("  No checksum found, assuming existing file is valid");
        }
        return archive;
    }

    private File getExtractedDir(Package pkg) {
        String filename = pkg.filename;
        Archive format = pkg.archive();
        if (format == null) {
            format = Archive.byFilename(filename);
        }
        if (filename.endsWith(".tar.gz")) {
            filename = filename.substring(0, filename.length() - 7);
        } else {
            int idx = filename.lastIndexOf(46);
            if (idx != -1) {
                filename = filename.substring(0, idx);
            }
        }
        return new File(this.cache, filename);
    }

    @Nullable
    public File extract(Package pkg) {
        File archive = new File(this.cache, pkg.filename);
        if (!archive.exists() && (archive = this.download(pkg)) == null) {
            this.error("Failed to download package: " + pkg.id);
            return null;
        }
        File extracted = this.getExtractedDir(pkg);
        return this.extract(archive, extracted, pkg.os(), pkg.archive());
    }

    @Nullable
    private File extract(File archive, File target, OS os, Archive format) {
        String exeName = "bin/java" + OS.current().exe();
        File exe = new File(target, exeName);
        if (exe.exists()) {
            return target;
        }
        this.debug("Extracting " + archive + " to: " + target);
        target = target.getAbsoluteFile();
        if (!target.exists() && !target.mkdirs()) {
            this.error("Failed to create target directory: " + target);
            return null;
        }
        if (format == Archive.TAR || format == Archive.TGZ || format == Archive.TAR_GZ) {
            this.extractTar(exeName, archive, target, os, format == Archive.TGZ || format == Archive.TAR_GZ);
        } else if (format == Archive.ZIP) {
            this.extractZip(exeName, archive, target);
        } else {
            this.error("    Unknown archive format.. can't continue");
            return null;
        }
        if (!exe.exists()) {
            this.error("    Extracting failed to produce expected java executable: " + exe.getAbsolutePath());
            return null;
        }
        return target;
    }

    private void extractZip(String exeName, File archive, File target) {
        boolean posix = Files.getFileAttributeView(target.toPath(), PosixFileAttributeView.class, new LinkOption[0]) != null;
        try (ZipFile zip = new ZipFile(archive);){
            ArrayList<? extends ZipEntry> entries = Collections.list(zip.entries());
            String prefix = null;
            for (ZipEntry zipEntry : entries) {
                String name = zipEntry.getName().replace('\\', '/');
                if (!name.endsWith(exeName)) continue;
                prefix = name.substring(0, name.length() - exeName.length());
                break;
            }
            if (prefix != null) {
                this.debug("  Prefix: " + prefix);
            }
            for (ZipEntry zipEntry : entries) {
                boolean isDir;
                int bits = Disco.getZipMode(zipEntry.getExtra());
                InputStream stream = zip.getInputStream(zipEntry);
                String name = zipEntry.getName().replace('\\', '/');
                boolean bl = isDir = zipEntry.isDirectory() || name.endsWith("/");
                if (this.extractFile(archive, posix, target, prefix, name, stream, bits, isDir)) continue;
                return;
            }
        }
        catch (IOException e) {
            this.error("  Failed to extract zip file: " + archive.getName() + " : " + e);
        }
    }

    private static int getZipMode(byte[] data) throws IOException {
        int bits = 493;
        if (data == null) {
            return bits;
        }
        DataInputStream bin = new DataInputStream(new ByteArrayInputStream(data));
        while (bin.available() > 0) {
            int id = bin.readUnsignedShort();
            int len = bin.readUnsignedShort();
            if (id == 30062) {
                bin.skip(4L);
                bits = bin.readUnsignedShort() & 0x1FF;
                bin.skip(len - 6);
                continue;
            }
            bin.skip(len);
        }
        return bits;
    }

    private boolean extractFile(File archive, boolean posix, File target, String prefix, String name, InputStream stream, int bits, boolean isDir) throws IOException {
        File out;
        if (isDir) {
            return true;
        }
        if (prefix != null) {
            if (!name.startsWith(prefix)) {
                return true;
            }
            name = name.substring(prefix.length());
        }
        if (!(out = new File(target, name).getAbsoluteFile()).getAbsolutePath().startsWith(target.getAbsolutePath())) {
            this.error("Failed to extract " + archive);
            this.error("  Invalid file! " + name);
            this.error("    Would not be extracted to target directory, could be malicious archive! Exiting");
            return false;
        }
        File parent = out.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            this.error("Failed to create directory: " + parent);
            return false;
        }
        Files.copy(stream, out.toPath(), StandardCopyOption.REPLACE_EXISTING);
        if (posix) {
            EnumSet<PosixFilePermission> perms = EnumSet.noneOf(PosixFilePermission.class);
            int mask = 256;
            for (PosixFilePermission perm : PosixFilePermission.values()) {
                if ((bits & mask) != 0) {
                    perms.add(perm);
                }
                mask >>= 1;
            }
            Files.setPosixFilePermissions(out.toPath(), perms);
        }
        return true;
    }

    private static InputStream getFileStream(File file, boolean gzipped) throws IOException {
        InputStream stream = new FileInputStream(file);
        if (gzipped) {
            stream = new GZIPInputStream(stream);
        }
        return stream;
    }

    private void extractTar(String exeName, File archive, File target, OS os, boolean gziped) {
        String prefix = null;
        try (TarInputStream tar = new TarInputStream(Disco.getFileStream(archive, gziped));){
            TarEntry entry = tar.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                if (name.endsWith(exeName)) {
                    prefix = name.substring(0, name.length() - exeName.length());
                    break;
                }
                entry = tar.getNextEntry();
            }
        }
        catch (IOException e) {
            this.error("  Failed to read tar file: " + archive + " : " + e);
            return;
        }
        if (prefix != null) {
            this.debug("  Prefix: " + prefix);
        }
        boolean posix = Files.getFileAttributeView(target.toPath(), PosixFileAttributeView.class, new LinkOption[0]) != null;
        try (TarInputStream tar = new TarInputStream(Disco.getFileStream(archive, gziped));){
            TarEntry entry = tar.getNextEntry();
            while (entry != null) {
                int bits = entry.getHeader().mode;
                boolean isDir = entry.isDirectory();
                String name = entry.getName();
                if (!this.extractFile(archive, posix, target, prefix, name, tar, bits, isDir)) {
                    return;
                }
                entry = tar.getNextEntry();
            }
        }
        catch (IOException e) {
            this.error("  Failed to extract: " + archive + " : " + e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private <T> T readJson(File input, TypeToken<T> type) {
        if (!input.exists()) {
            this.error("Failed to find cache file: " + input);
            return null;
        }
        if (!this.offline && input.lastModified() < System.currentTimeMillis() - 43200000L) {
            this.error("Cache file is stale, please redownload");
            return null;
        }
        try (FileReader reader = new FileReader(input);){
            T t = GSON.fromJson(new JsonReader(reader), type);
            return t;
        }
        catch (Exception e) {
            this.error("Failed to read cache file: " + input + " : " + e);
            return null;
        }
    }

    private static <T> void writeJson(File output, T data, Class<T> type) throws IOException {
        File parent = output.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("Failed to create directory: " + parent);
        }
        try (BufferedWriter out = Files.newBufferedWriter(output.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            GSON.toJson(data, type, GSON.newJsonWriter(out));
        }
    }

    private static class DownloadInfo {
        private Package pkg;
        private PackageInfo info;

        private DownloadInfo(Package pkg, PackageInfo info) {
            this.pkg = pkg;
            this.info = info;
        }
    }

    public static class PackageInfo {
        public String filename;
        public String direct_download_uri;
        public String download_side_uri;
        public String signature_uri;
        public String checksum_uri;
        public String checksum;
        public String checksum_type;
    }

    public static class Package
    implements Comparable<Package> {
        public String id;
        public int major_version;
        public int jdk_version;
        public boolean javafx_bundled;
        public String filename;
        public Links links;
        public int size;
        public String java_version;
        private transient JavaVersion javaVersion;
        public String archive_type;
        private transient Archive archive;
        public String distribution;
        private transient Distro distro;
        public String operating_system;
        private transient OS os;
        public String lib_c_type;
        private transient LibC libC;
        public String architecture;
        private transient Arch arch;

        public JavaVersion javaVersion() {
            if (this.javaVersion == null && this.java_version != null) {
                this.javaVersion = JavaVersion.parse(this.java_version);
            }
            return this.javaVersion;
        }

        public Archive archive() {
            if (this.archive == null && this.archive_type != null) {
                this.archive = Archive.byKey(this.archive_type);
                if (this.archive == null && this.filename != null) {
                    this.archive = Archive.byFilename(this.filename);
                }
            }
            return this.archive;
        }

        public Distro distro() {
            if (this.distro == null && this.distribution != null) {
                this.distro = Distro.byKey(this.distribution);
            }
            return this.distro;
        }

        public OS os() {
            if (this.os == null && this.operating_system != null) {
                this.os = OS.byKey(this.operating_system);
            }
            return this.os;
        }

        public LibC libC() {
            if (this.libC == null && this.lib_c_type != null) {
                this.libC = LibC.byKey(this.lib_c_type);
            }
            return this.libC;
        }

        public Arch arch() {
            if (this.arch == null && this.architecture != null) {
                this.arch = Arch.byKey(this.architecture);
            }
            return this.arch;
        }

        @Override
        public int compareTo(Package o) {
            if (o == null) {
                return -1;
            }
            if (this.jdk_version != o.jdk_version) {
                return o.jdk_version - this.jdk_version;
            }
            if (this.compare(this.distro(), o.distro()) != 0) {
                return this.compare(this.distro(), o.distro());
            }
            if (this.compare(this.libC(), o.libC()) != 0) {
                return this.compare(this.libC(), o.libC());
            }
            if (this.javaVersion() != null) {
                return this.javaVersion().compareTo(o.javaVersion());
            }
            if (o.javaVersion() != null) {
                return -1;
            }
            return 0;
        }

        private <T extends Enum<T>> int compare(T e1, T e2) {
            if (e1 == null && e2 != null) {
                return 1;
            }
            if (e1 != null && e2 == null) {
                return -1;
            }
            if (e1 == e2) {
                return 0;
            }
            return e1.compareTo(e2);
        }

        public static final class Links {
            public String pkg_info_uri;
            public String pkg_download_redirect;
        }
    }

    private static class Response<T> {
        @Nullable
        private final String message;
        private final List<T> entries;

        static <T> Response<T> of(String raw, Class<T> clazz) throws Exception {
            return Response.of(raw, (JsonElement e) -> GSON.fromJson(e, clazz));
        }

        static <T> Response<T> of(String raw, Parser<T> converter) throws Exception {
            JsonObject root = GSON.fromJson(raw, JsonObject.class);
            String message = root.has("message") ? root.get("message").getAsString() : null;
            JsonArray result = root.getAsJsonArray("result");
            if (result == null) {
                throw new Exception("Failed to parse response");
            }
            ArrayList<T> entries = new ArrayList<T>();
            for (JsonElement entry : result) {
                entries.add(converter.apply(entry));
            }
            return new Response(message, entries);
        }

        private Response(@Nullable String message, List<T> entries) throws JsonParseException {
            this.message = message;
            this.entries = entries;
        }

        @Nullable
        public String message() {
            return this.message;
        }

        public List<T> entries() {
            return this.entries;
        }

        public static interface Parser<T> {
            public T apply(JsonElement var1) throws JsonSyntaxException;
        }
    }

    public static enum LibC {
        GLIBC,
        LIBC,
        MUSL,
        C_STD_LIB;

        private static final LibC[] $values;
        private final String key = this.name().toLowerCase(Locale.ENGLISH);
        public static final LibC CURRENT;

        public static LibC byKey(String key) {
            for (LibC value : $values) {
                if (!value.key.equals(key)) continue;
                return value;
            }
            return null;
        }

        private static LibC getCurrent() {
            if (OS.current() == OS.MUSL) {
                return MUSL;
            }
            if (OS.current() != OS.LINUX && OS.current() != OS.ALPINE) {
                return GLIBC;
            }
            ProcessUtils.Result getconf = ProcessUtils.runCommand("getconf", "GNU_LIBC_VERSION");
            if (getconf.exitCode == 0) {
                for (String line : getconf.lines) {
                    if (!line.toLowerCase(Locale.ENGLISH).contains("musl")) continue;
                    return MUSL;
                }
            } else {
                System.err.println("Failed to run `getconf GNU_LIBC_VERSION`: " + getconf.lines.get(0));
            }
            ProcessUtils.Result ldd = ProcessUtils.runCommand("ldd", "--version");
            if (ldd.exitCode == 0) {
                for (String line : ldd.lines) {
                    if (!line.toLowerCase(Locale.ENGLISH).contains("musl")) continue;
                    return MUSL;
                }
            } else {
                System.err.println("Failed to run `ldd --version`: " + ldd.lines.get(0));
            }
            return GLIBC;
        }

        static {
            $values = LibC.values();
            CURRENT = LibC.getCurrent();
        }
    }

    public static enum Archive {
        APK,
        CAB,
        DEB,
        DMG,
        EXE,
        MSI,
        PKG,
        RPM,
        TAR,
        TAR_GZ("tar.gz"),
        TGZ,
        ZIP;

        private static final Archive[] $values;
        private final String key;

        private Archive() {
            this.key = this.name().toLowerCase(Locale.ENGLISH);
        }

        private Archive(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }

        public static Archive byFilename(String name) {
            name = name.toLowerCase(Locale.ENGLISH);
            for (Archive value : $values) {
                if (!name.endsWith("." + value.key())) continue;
                return value;
            }
            return null;
        }

        public static Archive byKey(String key) {
            for (Archive value : $values) {
                if (!value.key.equals(key)) continue;
                return value;
            }
            return null;
        }

        static {
            $values = Archive.values();
        }
    }

    public static enum Arch {
        X86("x86", "x86", "x32", "286"),
        X64,
        AARCH32,
        AARCH64,
        PPC,
        PPC64,
        AMD64(X64, "amd64", "amd64", "_amd64"),
        ARM,
        ARM32("arm32", "arm32", "aarch32", "armv6", "armv7l", "armv7"),
        ARM64("arm64", "arm64", "armv8"),
        MIPS,
        PPC64EL(PPC64),
        PPC64LE(PPC64),
        RISCV64(AARCH64, "riscv64", "riscv64", "risc-v", "riscv"),
        S390,
        S390X,
        SPARC,
        SPARC_V9("sparcv9", new String[0]),
        X86_64(X64, "x86-64", "x86-64", "x86_64", "x86lx64"),
        X86_32(X86, "x86-32", "x86-32", "x86_32", "x86lx32"),
        I386(X86, "i386", "i396", "386"),
        I486(X86, "i486", "i496", "486"),
        I586(X86, "i586", "i596", "586"),
        I686(X86, "i686", "i696", "686"),
        UNKNOWN;

        private static final Arch[] $values;
        private final Arch parent;
        private final String key;
        private final String[] names;
        public static final Arch CURRENT;

        private Arch() {
            this(null);
        }

        private Arch(Arch parent) {
            this.parent = parent;
            this.key = this.name().toLowerCase(Locale.ENGLISH);
            this.names = new String[]{this.key};
        }

        private Arch(String key, String ... names) {
            this((Arch)null, key, names);
        }

        private Arch(Arch parent, String key, String ... names) {
            this.parent = parent;
            this.key = key;
            this.names = names;
        }

        public boolean is64Bit() {
            return this == X64 || this == AMD64 || this == ARM64 || this == X86_64 || this == AARCH64 || this == PPC64 || this == PPC64EL || this == RISCV64;
        }

        public boolean isArm() {
            return this == ARM || this == ARM32 || this == ARM64 || this == AARCH32 || this == AARCH64 || this == RISCV64;
        }

        public String key() {
            return this.key;
        }

        public static Arch byKey(String key) {
            for (Arch value : $values) {
                if (!value.key.equals(key)) continue;
                return value;
            }
            return null;
        }

        private static Arch getCurrent() {
            String prop = System.getProperty("os.arch").toLowerCase(Locale.ENGLISH);
            for (Arch value : $values) {
                for (String name : value.names) {
                    if (!prop.equals(name)) continue;
                    return value;
                }
            }
            return UNKNOWN;
        }

        static {
            $values = Arch.values();
            CURRENT = Arch.getCurrent();
        }
    }

    public static final class Locators {
        private Locators() {
        }

        public static JavaLocator gradle() {
            return new GradleLocator();
        }

        public static JavaLocator home() {
            return new JavaHomeLocator();
        }

        public static JavaLocator paths() {
            return new JavaDirectoryLocator();
        }

        public static JavaLocator paths(File ... dirs) {
            return new JavaDirectoryLocator(Arrays.asList(dirs));
        }

        public static JavaProvisioner disco(File cache) {
            return new DiscoLocator(cache);
        }

        public static JavaProvisioner disco(File cache, boolean offline) {
            return new DiscoLocator(cache, offline);
        }
    }
}

