/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.java_provisioner;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import joptsimple.util.EnumConverter;
import net.minecraftforge.java_provisioner.Disco;
import net.minecraftforge.java_provisioner.ProcessUtils;
import net.minecraftforge.java_provisioner.api.Distro;
import net.minecraftforge.util.os.OS;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
public final class DiscoMain {
    private DiscoMain() {
    }

    public static void main(String[] args) throws Exception {
        OptionParser parser = new OptionParser();
        parser.allowsUnrecognizedOptions();
        OptionSpecBuilder helpO = parser.accepts("help", "Displays this help message and exits");
        parser.accepts("disco-main", "Use the DiscoMain entry point");
        ArgumentAcceptingOptionSpec<File> cacheO = parser.accepts("cache", "Directory to store data needed for this program").withRequiredArg().ofType(File.class).defaultsTo(new File("cache"), (File[])new File[0]);
        OptionSpecBuilder downloadJdkO = parser.accepts("download-jdk", "Download an extracts a JDK");
        ArgumentAcceptingOptionSpec<Integer> javeVersionO = parser.accepts("java-version", "Major version of java to download, will attempt the highest version avalible if unspecified").withOptionalArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec<Disco.Arch> archO = parser.acceptsAll(DiscoMain.l("arch", "architecture"), "Architecture for use in Disco api").withRequiredArg().withValuesConvertedBy(DiscoMain.converter(Disco.Arch.class)).defaultsTo(Disco.Arch.CURRENT, (Disco.Arch[])new Disco.Arch[0]);
        ArgumentAcceptingOptionSpec<OS> osO = parser.acceptsAll(DiscoMain.l("os", "operating-system"), "Operating System for use in Disco api").withRequiredArg().withValuesConvertedBy(DiscoMain.converter(OS.class)).defaultsTo(OS.current(), (OS[])new OS[0]);
        ArgumentAcceptingOptionSpec<Distro> distroO = parser.acceptsAll(DiscoMain.l("distro", "distribution"), "Distribution for use in Disco api").withRequiredArg().withValuesConvertedBy(DiscoMain.converter(Distro.class)).defaultsTo(Distro.MICROSOFT, (Distro[])new Distro[0]);
        OptionSpecBuilder autoO = parser.accepts("auto", "Auto select a JDK to download without prompting if there are multiple options");
        OptionSet options = parser.parse(args);
        File cache = (File)cacheO.value(options);
        boolean success = true;
        if (options.has(helpO)) {
            parser.printHelpOn(System.out);
        } else if (options.has(downloadJdkO)) {
            success = DiscoMain.downloadJdk(options.hasArgument(javeVersionO) ? (Integer)javeVersionO.value(options) : -1, (Disco.Arch)((Object)archO.value(options)), (OS)((Object)osO.value(options)), (Distro)distroO.value(options), options.has(autoO), cache);
        } else {
            parser.printHelpOn(System.out);
        }
        if (!success) {
            System.exit(1);
        }
    }

    private static List<String> l(String ... strings) {
        return Arrays.asList(strings);
    }

    private static boolean downloadJdk(int javaVersion, Disco.Arch arch, OS os, Distro distro, boolean auto, File cache) {
        File java_home;
        Disco.Package pkg;
        if (arch == Disco.Arch.UNKNOWN) {
            arch = Disco.Arch.X64;
            System.out.println("Unknown Architecture (" + System.getProperty("os.arch") + ") Defaulting to " + arch.name() + ". Use --arch to specify an alternative.");
        }
        if (os == OS.UNKNOWN) {
            os = OS.LINUX;
            System.out.println("Unknown Operating System (" + System.getProperty("os.name") + ") Defaulting to " + os.name() + ". Use --os to specify an alternative.");
        }
        System.out.println("Downloading JDK:");
        System.out.println("  Version: " + (javaVersion == -1 ? "latest" : Integer.valueOf(javaVersion)));
        System.out.println("  Arch:    " + (arch == null ? "null" : arch.name()));
        System.out.println("  OS:      " + (os == null ? "null" : os.name()));
        System.out.println("  Distro:  " + (distro == null ? "null" : distro.name()));
        System.out.println("  Cache:   " + cache.getAbsolutePath());
        Disco disco = new Disco(new File(cache, "jdks"));
        List<Disco.Package> jdks = disco.getPackages(javaVersion, os, distro, arch);
        if (jdks.isEmpty()) {
            System.err.println("Failed to find any download, try specifying a different java version or distro");
            return false;
        }
        if (jdks.size() == 1 || auto) {
            pkg = jdks.get(0);
        } else {
            for (int x = 0; x < jdks.size(); ++x) {
                Disco.Package jdk = jdks.get(x);
                System.out.printf("[%2d] %s: %s%n", x + 1, jdk.distribution, jdk.filename);
            }
            Scanner scan = new Scanner(System.in);
            System.out.print("Select Download: ");
            String line = scan.nextLine();
            int selected = -1;
            try {
                selected = Integer.parseInt(line);
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid selection \"" + line + "\" is not a number.");
            }
            if (selected <= 0 || selected > jdks.size()) {
                System.err.println("Invalid selection, must be between 1 and " + jdks.size());
                return false;
            }
            pkg = jdks.get(selected - 1);
        }
        System.out.println();
        try {
            java_home = disco.extract(pkg);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to extract downloaded package", e);
        }
        ProcessUtils.ProbeResult result = ProcessUtils.testJdk(java_home);
        if (result.exitCode != 0) {
            System.err.println("Failed to run extracted java:");
            for (String line : result.lines) {
                System.err.println("  " + line);
            }
            return false;
        }
        return true;
    }

    private static <T extends Enum<T>> EnumConverter<T> converter(Class<T> clazz) {
        return new EnumConverter<T>(clazz){

            @Override
            public T convert(String value) {
                if ("null".equals(value)) {
                    return null;
                }
                return super.convert(value);
            }
        };
    }
}

