/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.repo.mcpconfig;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.mcmaven.impl.cache.Cache;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPConfigRepo;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPSide;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MinecraftTasks;
import net.minecraftforge.mcmaven.impl.util.Artifact;
import net.minecraftforge.util.data.json.JsonData;
import net.minecraftforge.util.data.json.MCPConfig;

public class MCP {
    private final MCPConfigRepo repo;
    private final Artifact name;
    private final File data;
    private final MCPConfig.V2 config;
    private final File build;
    private final MinecraftTasks mcTasks;
    private final Map<String, MCPSide> sides = new HashMap<String, MCPSide>();

    public static Artifact artifact(String version) {
        return Artifact.from("de.oceanlabs.mcp", "mcp_config", version, null, "zip");
    }

    public MCP(MCPConfigRepo repo, Artifact name) {
        this.repo = repo;
        this.name = name;
        this.data = this.getCache().maven().download(name);
        if (!this.data.exists()) {
            throw new IllegalStateException("Failed to download " + String.valueOf(name));
        }
        this.config = MCP.loadConfig(name, this.data);
        this.validateConfig();
        this.build = new File(this.repo.getCache().root(), "mcp/" + this.name.getFolder());
        this.mcTasks = this.repo.getMCTasks(this.config.version);
        for (String side : this.config.steps.keySet()) {
            this.sides.put(side, new MCPSide(this, side));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static MCPConfig.V2 loadConfig(Artifact name, File data) {
        try (ZipFile zip = new ZipFile(data);){
            ZipEntry entry = zip.getEntry("config.json");
            if (entry == null) {
                throw new IllegalStateException("Invalid MCPConfig dependency: " + String.valueOf(name) + " - Missing config.json");
            }
            byte[] cfg_data = zip.getInputStream(entry).readAllBytes();
            int spec = JsonData.configSpec(cfg_data);
            if (spec == 2 || spec == 3 || spec == 4) {
                MCPConfig.V2 v2 = JsonData.mcpConfigV2(zip.getInputStream(entry));
                return v2;
            }
            if (spec != 1) throw new IllegalStateException("Invalid MCP Config: " + String.valueOf(name) + " - Unknown Spec: " + spec);
            MCPConfig.V2 v2 = new MCPConfig.V2(JsonData.mcpConfig(zip.getInputStream(entry)));
            return v2;
        }
        catch (IOException e) {
            throw new RuntimeException("Invalid MCPConfig dependency: " + String.valueOf(name), e);
        }
    }

    private void validateConfig() {
        if (this.config.steps == null || this.config.steps.isEmpty()) {
            throw new IllegalStateException("Invalid MCP Config: " + String.valueOf(this.name) + " - Missing steps");
        }
        for (String side : this.config.steps.keySet()) {
            List steps = (List)this.config.steps.get(side);
            block10: for (int x = 0; x < steps.size(); ++x) {
                String type = (String)((Map)steps.get(x)).get("type");
                if (type == null) {
                    throw new IllegalStateException("Invalid MCP Config: " + String.valueOf(this.name) + " - Step " + side + "[" + x + "] Missing `type`");
                }
                switch (type) {
                    case "downloadClientMappings": 
                    case "downloadServerMappings": {
                        if (this.config.spec >= 2) continue block10;
                        throw new IllegalStateException("Invalid MCP Config: " + String.valueOf(this.name) + " - Step " + side + "[" + x + "] `" + type + "` is only supported on spec 2 or higher, found spec: " + this.config.spec);
                    }
                    case "listLibraries": {
                        if (this.config.spec >= 3 || !((Map)steps.get(x)).containsKey("bundle")) continue block10;
                        throw new IllegalStateException("Invalid MCP Config: " + String.valueOf(this.name) + " - Step " + side + "[" + x + "] `listLibraries.bundle` is only supported on spec 3 or higher, found spec: " + this.config.spec);
                    }
                }
            }
        }
        if (this.config.spec < 4 && this.config.functions != null) {
            for (MCPConfig.Function func : this.config.functions.values()) {
                if (func.java_version == null) continue;
                throw new IllegalStateException("Invalid MCP Config: " + String.valueOf(this.name) + " - Function `java_version` property is only supported on spec 4 or higher, found spec: " + this.config.spec);
            }
        }
    }

    public MCPConfig.V2 getConfig() {
        return this.config;
    }

    public File getData() {
        return this.data;
    }

    public MCPSide getSide(String side) {
        MCPSide ret = this.sides.get(side);
        if (ret == null) {
            throw new IllegalArgumentException("Invalid MCP Side: " + side);
        }
        return ret;
    }

    public Artifact getName() {
        return this.name;
    }

    public MinecraftTasks getMinecraftTasks() {
        return this.mcTasks;
    }

    public Cache getCache() {
        return this.repo.getCache();
    }

    public File getBuildFolder() {
        return this.build;
    }
}

