/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.fastcsv.reader;

import de.siegmar.fastcsv.reader.CommentStrategy;
import de.siegmar.fastcsv.reader.CsvCallbackHandler;
import de.siegmar.fastcsv.reader.CsvParseException;
import de.siegmar.fastcsv.util.Limits;
import de.siegmar.fastcsv.util.Preconditions;
import de.siegmar.fastcsv.util.Util;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;

final class CsvParser
implements Closeable {
    private static final int STATUS_LAST_CHAR_WAS_CR = 32;
    private static final int STATUS_COMMENTED_RECORD = 16;
    private static final int STATUS_NEW_FIELD = 8;
    private static final int STATUS_QUOTED_MODE = 4;
    private static final int STATUS_QUOTED_FIELD = 2;
    private static final int STATUS_DATA_FIELD = 1;
    private static final int STATUS_RESET = 0;
    private final char fsep;
    private final char qChar;
    private final CommentStrategy cStrat;
    private final char cChar;
    private final boolean acceptCharsAfterQuotes;
    private final CsvCallbackHandler<?> callbackHandler;
    private final CsvBuffer csvBuffer;
    private long startingLineNumber;
    private int lines = 1;
    private int status;
    private boolean finished;

    CsvParser(char fieldSeparator, char quoteCharacter, CommentStrategy commentStrategy, char commentCharacter, boolean acceptCharsAfterQuotes, CsvCallbackHandler<?> callbackHandler, Reader reader) {
        this.assertFields(fieldSeparator, quoteCharacter, commentCharacter);
        this.fsep = fieldSeparator;
        this.qChar = quoteCharacter;
        this.cStrat = commentStrategy;
        this.cChar = commentCharacter;
        this.acceptCharsAfterQuotes = acceptCharsAfterQuotes;
        this.callbackHandler = callbackHandler;
        this.csvBuffer = new CsvBuffer(reader);
    }

    CsvParser(char fieldSeparator, char quoteCharacter, CommentStrategy commentStrategy, char commentCharacter, boolean acceptCharsAfterQuotes, CsvCallbackHandler<?> callbackHandler, String data) {
        this.assertFields(fieldSeparator, quoteCharacter, commentCharacter);
        this.fsep = fieldSeparator;
        this.qChar = quoteCharacter;
        this.cStrat = commentStrategy;
        this.cChar = commentCharacter;
        this.acceptCharsAfterQuotes = acceptCharsAfterQuotes;
        this.callbackHandler = callbackHandler;
        this.csvBuffer = new CsvBuffer(data);
    }

    private void assertFields(char fieldSeparator, char quoteCharacter, char commentCharacter) {
        Preconditions.checkArgument(!Util.isNewline(fieldSeparator), "fieldSeparator must not be a newline char");
        Preconditions.checkArgument(!Util.isNewline(quoteCharacter), "quoteCharacter must not be a newline char");
        Preconditions.checkArgument(!Util.isNewline(commentCharacter), "commentCharacter must not be a newline char");
        Preconditions.checkArgument(!Util.containsDupe(fieldSeparator, quoteCharacter, commentCharacter), "Control characters must differ (fieldSeparator=%s, quoteCharacter=%s, commentCharacter=%s)", Character.valueOf(fieldSeparator), Character.valueOf(quoteCharacter), Character.valueOf(commentCharacter));
    }

    boolean parse() throws IOException {
        if (this.finished) {
            return false;
        }
        this.startingLineNumber += (long)this.lines;
        this.lines = 1;
        this.callbackHandler.beginRecord(this.startingLineNumber);
        do {
            if (this.csvBuffer.len != this.csvBuffer.pos || this.csvBuffer.fetchData()) continue;
            this.finished = true;
            return this.processBufferTail();
        } while (this.consume(this.csvBuffer.buf, this.csvBuffer.len));
        return true;
    }

    private boolean processBufferTail() {
        if (this.csvBuffer.begin < this.csvBuffer.pos) {
            this.materialize(this.csvBuffer.buf, this.csvBuffer.begin, this.csvBuffer.pos, this.status, this.qChar);
            return true;
        }
        if ((this.status & 8) != 0 || (this.status & 0x10) != 0) {
            this.materialize(this.csvBuffer.buf, 0, 0, this.status, this.qChar);
            return true;
        }
        return false;
    }

    boolean consume(char[] lBuf, int lLen) {
        boolean moreDataNeeded;
        int lBegin;
        int lPos;
        block21: {
            lPos = this.csvBuffer.pos;
            lBegin = this.csvBuffer.begin;
            int lStatus = this.status;
            moreDataNeeded = true;
            block0: do {
                char lookAhead;
                char c;
                if ((lStatus & 4) != 0) {
                    while (lPos < lLen) {
                        if ((c = lBuf[lPos++]) == this.qChar) {
                            lStatus &= 0xFFFFFFFB;
                            continue block0;
                        }
                        if (c == '\r') {
                            lStatus |= 0x20;
                            ++this.lines;
                            continue;
                        }
                        if (c == '\n') {
                            if ((lStatus & 0x20) == 0) {
                                ++this.lines;
                                continue;
                            }
                            lStatus &= 0xFFFFFFDF;
                            continue;
                        }
                        while (lPos < lLen && (lookAhead = lBuf[lPos]) != this.qChar && lookAhead != '\n' && lookAhead != '\r') {
                            ++lPos;
                        }
                    }
                    continue;
                }
                if ((lStatus & 0x10) != 0) {
                    while (lPos < lLen) {
                        char lookAhead2;
                        if ((lookAhead2 = lBuf[lPos++]) == '\r') {
                            this.materialize(lBuf, lBegin, lPos - 1, lStatus, this.qChar);
                            this.status = 32;
                            lBegin = lPos;
                            moreDataNeeded = false;
                        } else {
                            if (lookAhead2 != '\n') continue;
                            this.materialize(lBuf, lBegin, lPos - 1, lStatus, this.qChar);
                            this.status = 0;
                            lBegin = lPos;
                            moreDataNeeded = false;
                        }
                        break block21;
                    }
                    continue;
                }
                while (lPos < lLen) {
                    if ((c = lBuf[lPos++]) == this.fsep) {
                        this.materialize(lBuf, lBegin, lPos - 1, lStatus, this.qChar);
                        lStatus = 8;
                        lBegin = lPos;
                        continue;
                    }
                    if (c == '\r') {
                        this.materialize(lBuf, lBegin, lPos - 1, lStatus, this.qChar);
                        this.status = 32;
                        lBegin = lPos;
                        moreDataNeeded = false;
                        break block21;
                    }
                    if (c == '\n') {
                        if ((lStatus & 0x20) == 0) {
                            this.materialize(lBuf, lBegin, lPos - 1, lStatus, this.qChar);
                            this.status = 0;
                            lBegin = lPos;
                            moreDataNeeded = false;
                            break block21;
                        }
                        lStatus = 0;
                        lBegin = lPos;
                        continue;
                    }
                    if (this.cStrat != CommentStrategy.NONE && c == this.cChar && (lStatus == 0 || lStatus == 32)) {
                        lBegin = lPos;
                        lStatus = 16;
                        continue block0;
                    }
                    if (c == this.qChar && (lStatus & 1) == 0) {
                        lStatus = 6;
                        continue block0;
                    }
                    if ((lStatus & 2) == 0) {
                        lStatus = 1;
                        while (lPos < lLen && (lookAhead = lBuf[lPos]) != this.fsep && lookAhead != '\n' && lookAhead != '\r') {
                            ++lPos;
                        }
                        continue;
                    }
                    if (this.acceptCharsAfterQuotes) continue;
                    throw new CsvParseException("Unexpected character after closing quote: " + c);
                }
            } while (lPos < lLen);
            this.status = lStatus;
        }
        this.csvBuffer.pos = lPos;
        this.csvBuffer.begin = lBegin;
        return moreDataNeeded;
    }

    private void materialize(char[] lBuf, int lBegin, int lPos, int lStatus, char quoteCharacter) {
        if ((lStatus & 2) != 0) {
            int beginAfterQuote = lBegin + 1;
            int endAfterField = lPos - (lBuf[lPos - 1] == quoteCharacter ? 1 : 0);
            this.callbackHandler.addField(lBuf, beginAfterQuote, CsvParser.cleanDelimiters(lBuf, beginAfterQuote, endAfterField, quoteCharacter), true);
            return;
        }
        if ((lStatus & 0x10) != 0) {
            this.callbackHandler.setComment(lBuf, lBegin, lPos - lBegin);
            return;
        }
        this.callbackHandler.addField(lBuf, lBegin, lPos - lBegin, false);
    }

    private static int cleanDelimiters(char[] buf, int begin, int end, char quoteCharacter) {
        int i;
        for (i = begin; i < end && buf[i] != quoteCharacter; ++i) {
        }
        int newPos = i;
        boolean escape = false;
        while (i < end) {
            block5: {
                char c;
                block4: {
                    c = buf[i];
                    if (c != quoteCharacter) break block4;
                    boolean bl = escape = !escape;
                    if (escape) break block5;
                }
                buf[newPos++] = c;
            }
            ++i;
        }
        return newPos - begin;
    }

    public long getStartingLineNumber() {
        return this.startingLineNumber;
    }

    void reset(long startingLineNumber) {
        this.startingLineNumber = startingLineNumber;
        this.csvBuffer.reset();
    }

    @Override
    public void close() throws IOException {
        this.csvBuffer.close();
    }

    String peekLine() throws IOException {
        char c;
        int savedPos = this.csvBuffer.pos;
        while ((this.csvBuffer.pos < this.csvBuffer.len || this.csvBuffer.fetchData()) && (c = this.csvBuffer.buf[this.csvBuffer.pos]) != '\r' && c != '\n') {
            ++this.csvBuffer.pos;
        }
        String s = new String(this.csvBuffer.buf, this.csvBuffer.begin, this.csvBuffer.pos - this.csvBuffer.begin);
        this.csvBuffer.pos = savedPos;
        return s;
    }

    boolean skipLine(int numCharsToSkip) throws IOException {
        this.csvBuffer.pos += numCharsToSkip;
        while (this.csvBuffer.pos < this.csvBuffer.len || this.csvBuffer.fetchData()) {
            char c;
            if ((c = this.csvBuffer.buf[this.csvBuffer.pos++]) == '\r') {
                if (this.csvBuffer.pos >= this.csvBuffer.len && !this.csvBuffer.fetchData() || this.csvBuffer.buf[this.csvBuffer.pos] != '\n') break;
                ++this.csvBuffer.pos;
                break;
            }
            if (c != '\n') continue;
            break;
        }
        if (this.csvBuffer.begin < this.csvBuffer.pos) {
            this.csvBuffer.begin = this.csvBuffer.pos;
            ++this.startingLineNumber;
            return true;
        }
        return false;
    }

    private static class CsvBuffer
    implements Closeable {
        private static final int READ_SIZE = 8192;
        private static final int BUFFER_SIZE = 8192;
        char[] buf;
        int len;
        int begin;
        int pos;
        private final Reader reader;

        CsvBuffer(Reader reader) {
            this.reader = reader;
            this.buf = new char[8192];
        }

        CsvBuffer(String data) {
            this.reader = null;
            this.buf = data.toCharArray();
            this.len = data.length();
        }

        private boolean fetchData() throws IOException {
            int cnt;
            if (this.reader == null) {
                return false;
            }
            if (this.begin < this.pos) {
                if (8192 > this.buf.length - this.pos) {
                    int lenToCopy = this.pos - this.begin;
                    if (8192 > this.buf.length - lenToCopy) {
                        this.buf = CsvBuffer.extendAndRelocate(this.buf, this.begin);
                    } else {
                        System.arraycopy(this.buf, this.begin, this.buf, 0, lenToCopy);
                    }
                    this.pos -= this.begin;
                    this.begin = 0;
                }
            } else {
                this.begin = 0;
                this.pos = 0;
            }
            if ((cnt = this.reader.read(this.buf, this.pos, 8192)) == -1) {
                return false;
            }
            this.len = this.pos + cnt;
            return true;
        }

        private static char[] extendAndRelocate(char[] buf, int begin) {
            int newBufferSize = buf.length * 2;
            if (newBufferSize > Limits.MAX_FIELD_SIZE) {
                throw new CsvParseException(String.format("The maximum buffer size of %d is insufficient to read the data of a single field. This issue typically arises when a quotation begins but does not conclude within the confines of this buffer's maximum limit.", Limits.MAX_FIELD_SIZE));
            }
            char[] newBuf = new char[newBufferSize];
            System.arraycopy(buf, begin, newBuf, 0, buf.length - begin);
            return newBuf;
        }

        private void reset() {
            this.len = 0;
            this.begin = 0;
            this.pos = 0;
        }

        @Override
        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
            }
        }
    }
}

