/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.repo.forge;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.minecraftforge.mcmaven.impl.Mavenizer;
import net.minecraftforge.mcmaven.impl.cache.Cache;
import net.minecraftforge.mcmaven.impl.data.GradleModule;
import net.minecraftforge.mcmaven.impl.mappings.Mappings;
import net.minecraftforge.mcmaven.impl.repo.Repo;
import net.minecraftforge.mcmaven.impl.repo.forge.FGVersion;
import net.minecraftforge.mcmaven.impl.repo.forge.InjectTask;
import net.minecraftforge.mcmaven.impl.repo.forge.Patcher;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPConfigRepo;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPSide;
import net.minecraftforge.mcmaven.impl.tasks.RecompileTask;
import net.minecraftforge.mcmaven.impl.tasks.RenameTask;
import net.minecraftforge.mcmaven.impl.util.Artifact;
import net.minecraftforge.mcmaven.impl.util.ComparableVersion;
import net.minecraftforge.mcmaven.impl.util.POMBuilder;
import net.minecraftforge.mcmaven.impl.util.Task;
import net.minecraftforge.mcmaven.impl.util.Util;
import net.minecraftforge.util.data.json.JsonData;
import net.minecraftforge.util.file.FileUtils;
import net.minecraftforge.util.hash.HashStore;

public final class ForgeRepo
extends Repo {
    private static final ComparableVersion USERDEV3_START = new ComparableVersion("1.12.2-14.23.5.2851");
    private static final ComparableVersion USERDEV3_END = new ComparableVersion("1.12.3");
    final MCPConfigRepo mcpconfig;
    final File globalBuild;

    public ForgeRepo(Cache cache, MCPConfigRepo mcpconfig) {
        super(cache);
        this.mcpconfig = mcpconfig;
        this.globalBuild = new File(cache.root(), "forge/.global");
    }

    @Override
    public List<Repo.PendingArtifact> process(Artifact artifact, Mappings mappings) {
        String module = artifact.getGroup() + ":" + artifact.getName();
        String version = artifact.getVersion();
        if (!"net.minecraftforge:forge".equals(module)) {
            throw new IllegalArgumentException("Unknown or unsupported module: " + module);
        }
        FGVersion fg = FGVersion.fromForge(version);
        Mavenizer.LOGGER.info("Processing Minecraft Forge (userdev): " + version);
        byte indent = Mavenizer.LOGGER.push();
        try {
            if (fg == null) {
                throw new IllegalArgumentException("Python version unsupported!");
            }
            if (fg.ordinal() < FGVersion.v3.ordinal()) {
                throw new IllegalArgumentException("Only FG 3+ currently supported");
            }
            if (fg.ordinal() <= FGVersion.v6.ordinal()) {
                List<Repo.PendingArtifact> list = this.processV3(version, mappings);
                return list;
            }
            throw new IllegalArgumentException("Forge version %s is not supported yet".formatted(version));
        }
        finally {
            Mavenizer.LOGGER.pop(indent);
        }
    }

    private static Artifact getUserdev(String forge) {
        ComparableVersion forgever = new ComparableVersion(forge);
        boolean userdev3 = forgever.compareTo(USERDEV3_START) >= 0 && forgever.compareTo(USERDEV3_END) < 0;
        return Artifact.from("net.minecraftforge", "forge", forge, userdev3 ? "userdev3" : "userdev", "jar");
    }

    private List<Repo.PendingArtifact> processV3(String version, Mappings mappings) {
        Artifact name = Artifact.from("net.minecraftforge", "forge", version);
        Artifact userdev = ForgeRepo.getUserdev(version);
        File build = new File(this.cache.root(), "forge/" + userdev.getFolder());
        Patcher patcher = new Patcher(build, this, userdev);
        MCPSide joined = patcher.getMCP().getSide("joined");
        RenameTask sourcesTask = new RenameTask(build, userdev.getName(), joined, patcher.get(), mappings, true);
        RecompileTask recompile = new RecompileTask(build, name, patcher.getMCP(), patcher::getClasspath, sourcesTask, mappings);
        InjectTask classesTask = new InjectTask(build, this.cache, name, patcher, recompile, mappings);
        Artifact extraCoords = Artifact.from("net.minecraft", "client-extra", patcher.getMCP().getName().getVersion());
        Artifact mappingCoords = mappings.getArtifact(joined);
        List<Repo.PendingArtifact> mappingArtifacts = this.mappingArtifacts(build, mappings, joined);
        Repo.PendingArtifact sources = ForgeRepo.pending("Sources", (Task)sourcesTask, name.withClassifier("sources"), true, this.sourceVariant(mappings));
        Repo.PendingArtifact classes = ForgeRepo.pending("Classes", (Task)classesTask, name, false, () -> this.classVariants(mappings, patcher, extraCoords, mappingCoords));
        Repo.PendingArtifact metadata = ForgeRepo.pending("Metadata", ForgeRepo.metadata(build, patcher), name.withClassifier("metadata").withExtension("zip"), false, this.metadataVariant());
        Repo.PendingArtifact pom = ForgeRepo.pending("Maven POM", ForgeRepo.pom(build, patcher, version, extraCoords, mappingCoords), name.withExtension("pom"), false);
        List<Repo.PendingArtifact> extraOutput = this.mcpconfig.processExtra("net.minecraft:client", patcher.getMCP().getName().getVersion());
        ArrayList<Repo.PendingArtifact> ret = new ArrayList<Repo.PendingArtifact>();
        ret.addAll(mappingArtifacts);
        ret.addAll(extraOutput);
        ret.addAll(List.of(sources, classes, pom, metadata));
        return ret;
    }

    private static Task metadata(File build, Patcher patcher) {
        return Task.named("metadata[forge]", Task.deps(patcher.getMCP().getMinecraftTasks().versionJson), () -> {
            File output = new File(build, "metadata.zip");
            File metadataDir = new File(output.getParentFile(), "metadata");
            File versionProperties = new File(metadataDir, "version.properties");
            File launcherDir = new File(metadataDir, "launcher");
            String runsJsonStr = JsonData.toJson(patcher.config.runs);
            File minecraftDir = new File(metadataDir, "minecraft");
            File versionJson = patcher.getMCP().getMinecraftTasks().versionJson.execute();
            HashStore cache = HashStore.fromFile(output).add(versionJson).add(versionProperties).add("data", patcher.getDataHash()).addKnown("version", "1");
            if (output.exists() && cache.isSame()) {
                return output;
            }
            Mavenizer.assertNotCacheOnly();
            try {
                FileUtils.ensureParent(output);
                FileUtils.ensure(metadataDir);
                FileUtils.ensure(launcherDir);
                FileUtils.ensure(minecraftDir);
                try (FileWriter writer = new FileWriter(versionProperties);){
                    writer.append("version=1").append('\n').flush();
                }
                Files.writeString(new File(launcherDir, "runs.json").toPath(), (CharSequence)runsJsonStr, StandardCharsets.UTF_8, new OpenOption[0]);
                Files.copy(versionJson.toPath(), new File(minecraftDir, "version.json").toPath(), StandardCopyOption.REPLACE_EXISTING);
                cache.add(versionProperties);
                FileUtils.makeZip(metadataDir, output);
            }
            catch (IOException e) {
                Util.sneak(e);
            }
            cache.save();
            return output;
        });
    }

    private static Task pom(File build, Patcher patcher, String version, Artifact clientExtra, Artifact mappings) {
        return Task.named("pom[forge]", () -> {
            File output = new File(build, "forge.pom");
            HashStore cache = HashStore.fromFile(output).addKnown("data", patcher.getDataHash()).addKnown("extra", Util.replace(clientExtra, Object::toString)).addKnown("mappings", Util.replace(mappings, Object::toString));
            if (output.exists() && cache.isSame()) {
                return output;
            }
            Mavenizer.assertNotCacheOnly();
            POMBuilder builder = new POMBuilder("net.minecraftforge", "forge", version).preferGradleModule().dependencies(dependencies -> {
                if (clientExtra != null) {
                    dependencies.add(clientExtra);
                }
                if (mappings != null) {
                    dependencies.add(mappings);
                }
                patcher.forAllLibraries(dependencies::add, Artifact::hasNoOs);
            });
            FileUtils.ensureParent(output);
            try (FileOutputStream os = new FileOutputStream(output);){
                os.write(builder.build().getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException | ParserConfigurationException | TransformerException e) {
                Util.sneak(e);
            }
            cache.save();
            return output;
        });
    }

    protected GradleModule.Variant[] classVariants(Mappings mappings, Patcher patcher, Artifact ... extraDeps) {
        ArrayList<Artifact> extra = new ArrayList<Artifact>(Arrays.asList(extraDeps));
        extra.addAll(patcher.getArtifacts());
        ArrayList<Artifact> extraCompile = new ArrayList<Artifact>();
        ArrayList<Artifact> extraRuntime = new ArrayList<Artifact>();
        if (patcher.config.extraDependencies != null) {
            if (patcher.config.extraDependencies.compileOnly != null) {
                for (String descriptor : patcher.config.extraDependencies.compileOnly) {
                    extraCompile.add(Artifact.from(descriptor));
                }
            }
            if (patcher.config.extraDependencies.runtimeOnly != null) {
                for (String descriptor : patcher.config.extraDependencies.runtimeOnly) {
                    extraRuntime.add(Artifact.from(descriptor));
                }
            }
        }
        return super.classVariants(mappings, patcher.getMCPSide(), extra, extraCompile, extraRuntime);
    }
}

