/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.minecraftforge.mcmaven.impl.Mavenizer;
import net.minecraftforge.mcmaven.impl.cache.Cache;
import net.minecraftforge.mcmaven.impl.data.GradleModule;
import net.minecraftforge.mcmaven.impl.mappings.Mappings;
import net.minecraftforge.mcmaven.impl.repo.Repo;
import net.minecraftforge.mcmaven.impl.repo.forge.FGVersion;
import net.minecraftforge.mcmaven.impl.repo.forge.ForgeRepo;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCP;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPConfigRepo;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MinecraftTasks;
import net.minecraftforge.mcmaven.impl.util.Artifact;
import net.minecraftforge.mcmaven.impl.util.ComparableVersion;
import net.minecraftforge.mcmaven.impl.util.Constants;
import net.minecraftforge.mcmaven.impl.util.ProcessUtils;
import net.minecraftforge.srgutils.MinecraftVersion;
import net.minecraftforge.util.data.json.JsonData;
import net.minecraftforge.util.data.json.LauncherManifest;
import net.minecraftforge.util.file.FileUtils;
import net.minecraftforge.util.hash.HashStore;
import net.minecraftforge.util.hash.HashUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public record MinecraftMaven(File output, boolean dependenciesOnly, Cache cache, Mappings mappings, Map<String, String> foreignRepositories, boolean globalAuxiliaryVariants, boolean disableGradle, boolean stubJars, Set<String> mcpConfigVersions) {
    private static final MinecraftVersion MIN_OFFICIAL_MAPPINGS = MinecraftVersion.from("1.14.4");
    private static final ComparableVersion MIN_SUPPORTED_FORGE = new ComparableVersion("1.14.4");

    public MinecraftMaven(File output, boolean dependenciesOnly, File cacheRoot, File jdkCacheRoot, Mappings mappings, Map<String, String> foreignRepositories, boolean globalAuxiliaryVariants, boolean disableGradle, boolean stubJars) {
        this(output, dependenciesOnly, new Cache(cacheRoot, jdkCacheRoot, foreignRepositories), mappings, foreignRepositories, globalAuxiliaryVariants, disableGradle, stubJars, new HashSet<String>());
    }

    public MinecraftMaven {
        Mavenizer.LOGGER.info("  Output:            " + output.getAbsolutePath());
        Mavenizer.LOGGER.info("  Dependencies Only: " + dependenciesOnly);
        Mavenizer.LOGGER.info("  Cache:             " + cache.root().getAbsolutePath());
        Mavenizer.LOGGER.info("  JDK Cache:         " + cache.jdks().root().getAbsolutePath());
        Mavenizer.LOGGER.info("  Offline:           " + Mavenizer.isOffline());
        Mavenizer.LOGGER.info("  Cache Only:        " + Mavenizer.isCacheOnly());
        Mavenizer.LOGGER.info("  Mappings:          " + String.valueOf(mappings));
        if (!foreignRepositories.isEmpty()) {
            Mavenizer.LOGGER.info("  Foreign Repos:     [" + String.join((CharSequence)", ", foreignRepositories.values()) + "]");
        }
        Mavenizer.LOGGER.info("  GradleVariantHack: " + globalAuxiliaryVariants);
        Mavenizer.LOGGER.info("  Disable Gradle:    " + disableGradle);
        Mavenizer.LOGGER.info("  Stub Jars:         " + stubJars);
        Mavenizer.LOGGER.info();
    }

    public void run(Artifact artifact) {
        String module = artifact.getGroup() + ":" + artifact.getName();
        String version = artifact.getVersion();
        Mavenizer.LOGGER.info("Processing Minecraft dependency: %s:%s".formatted(module, version));
        MCPConfigRepo mcprepo = new MCPConfigRepo(this.cache, this.dependenciesOnly);
        if ("net.minecraftforge".equals(artifact.getGroup()) && "forge".equals(artifact.getName())) {
            ForgeRepo repo = new ForgeRepo(this.cache, mcprepo);
            this.createForge(artifact, mcprepo, repo);
        } else if ("net.minecraft".equals(artifact.getGroup())) {
            this.createMinecraft(artifact, mcprepo);
        } else {
            throw new IllegalArgumentException("Artifact '%s' is currently Unsupported. Will add later".formatted(module));
        }
    }

    protected void createForge(Artifact artifact, MCPConfigRepo mcprepo, ForgeRepo repo) {
        if (this.dependenciesOnly) {
            throw new IllegalArgumentException("ForgeRepo doesn't currently support dependenciesOnly");
        }
        String version = artifact.getVersion();
        if (version == null) {
            throw new IllegalArgumentException("No version specified for Forge");
        }
        if ("all".equals(version)) {
            List<String> versions = this.cache.maven().getVersions(artifact);
            HashMap<String, Mappings> mappingCache = new HashMap<String, Mappings>();
            for (String ver : versions.reversed()) {
                FGVersion fg;
                ComparableVersion cver = new ComparableVersion(ver);
                if (cver.compareTo(MIN_SUPPORTED_FORGE) < 0 || (fg = FGVersion.fromForge(ver)) == null || fg.ordinal() < FGVersion.v3.ordinal()) continue;
                Mappings mappings = mappingCache.computeIfAbsent(MinecraftMaven.forgeToMcVersion(ver), this.mappings::withMCVersion);
                Artifact art = artifact.withVersion(ver);
                List<Repo.PendingArtifact> artifacts = repo.process(art, mappings);
                this.finalize(art, mappings, artifacts);
            }
        } else {
            Mappings mappings = this.mappings.withMCVersion(MinecraftMaven.forgeToMcVersion(version));
            List<Repo.PendingArtifact> artifacts = repo.process(artifact, mappings);
            this.finalize(artifact, mappings, artifacts);
        }
    }

    protected void createMinecraft(Artifact artifact, MCPConfigRepo mcprepo) {
        if (artifact.getVersion() == null) {
            throw new IllegalArgumentException("No version specified for MCPConfig");
        }
        String version = artifact.getVersion();
        if (version == null) {
            throw new IllegalArgumentException("No version specified for Forge");
        }
        if ("all".equals(version)) {
            File manifestFile = mcprepo.getLauncherManifestTask().execute();
            LauncherManifest manifest = JsonData.launcherManifest(manifestFile);
            for (LauncherManifest.VersionInfo ver : manifest.versions) {
                try {
                    MinecraftVersion cver = MinecraftVersion.from(ver.id);
                    if (cver.compareTo(MIN_OFFICIAL_MAPPINGS) < 0) {
                    }
                }
                catch (IllegalArgumentException e) {}
                continue;
                Artifact versioned = artifact.withVersion(ver.id);
                List<Repo.PendingArtifact> artifacts = null;
                if (this.hasMcp(mcprepo, ver.id)) {
                    artifacts = mcprepo.process(versioned, this.mappings.withMCVersion(ver.id));
                } else if (this.mappings.channel().equals("official") && MinecraftMaven.hasOfficialMappings(mcprepo, ver.id)) {
                    artifacts = mcprepo.processWithoutMcp(versioned, this.mappings.withMCVersion(ver.id));
                } else {
                    Mavenizer.LOGGER.info("Skipping " + String.valueOf(versioned) + " no mcp config");
                    continue;
                }
                this.finalize(artifact, this.mappings, artifacts);
            }
        } else {
            String mcVersion = MinecraftMaven.mcpToMcVersion(version);
            Mappings mappings = this.mappings.withMCVersion(mcVersion);
            List<Repo.PendingArtifact> artifacts = null;
            if (this.hasMcp(mcprepo, version)) {
                artifacts = mcprepo.process(artifact, mappings);
            } else if (mappings.channel().equals("official") && MinecraftMaven.hasOfficialMappings(mcprepo, mcVersion)) {
                artifacts = mcprepo.processWithoutMcp(artifact, mappings);
            } else {
                throw new IllegalStateException("Can not process " + String.valueOf(artifact) + " as it does not have a MCPConfig ror official mappings");
            }
            this.finalize(artifact, mappings, artifacts);
        }
    }

    private boolean hasMcp(MCPConfigRepo repo, String version) {
        if (this.mcpConfigVersions.isEmpty()) {
            List<String> versions = repo.getCache().maven().getVersions(MCP.artifact("1.21.11"));
            this.mcpConfigVersions.addAll(versions);
        }
        return this.mcpConfigVersions.contains(version);
    }

    private static boolean hasOfficialMappings(MCPConfigRepo repo, String version) {
        MinecraftTasks tasks = repo.getMCTasks(version);
        File versionF = tasks.versionJson.execute();
        net.minecraftforge.util.data.json.MinecraftVersion json = JsonData.minecraftVersion(versionF);
        return json.getDownload(MinecraftTasks.Files.CLIENT_MAPPINGS.key) != null || json.getDownload(MinecraftTasks.Files.SERVER_MAPPINGS.key) != null;
    }

    private static String forgeToMcVersion(String version) {
        int idx = version.indexOf(45);
        if (idx == -1) {
            throw new IllegalArgumentException("Invalid Forge version: " + version);
        }
        return version.substring(0, idx).replace('_', '-');
    }

    public static String mcpToMcVersion(String version) {
        int idx = version.lastIndexOf(45);
        if (idx < 0) {
            return version;
        }
        if (!version.substring(idx + 1).matches("\\d{8}\\.\\d{6}")) {
            return version;
        }
        return version.substring(0, idx);
    }

    protected void finalize(Artifact module, Mappings mappings, List<Repo.PendingArtifact> artifacts) {
        HashSet<Artifact> variants = new HashSet<Artifact>();
        for (Repo.PendingArtifact pending : artifacts) {
            if (pending == null) continue;
            Artifact artifact = pending.artifact();
            if (this.stubJars && "jar".equals(artifact.getExtension()) && "sources".equals(artifact.getClassifier())) continue;
            String suffix = null;
            if (!this.disableGradle && pending.variants() != null && !mappings.isPrimary()) {
                File primaryTarget = new File(this.output, artifact.getLocalPath());
                if (!primaryTarget.exists()) {
                    this.updateFile(primaryTarget, pending.get(), pending.artifact());
                }
                suffix = mappings.channel() + "-" + mappings.version();
                artifact = artifact.getClassifier() == null ? artifact.withClassifier(suffix) : artifact.withClassifier(artifact.getClassifier() + "-" + suffix);
            }
            File target = new File(this.output, artifact.getLocalPath());
            this.updateFile(target, pending.get(), pending.artifact());
            File varTarget = new File(this.output, artifact.getLocalPath() + ".variants");
            if (this.disableGradle || pending.variants() == null) continue;
            File source = pending.variants().execute();
            HashStore cache = HashStore.fromFile(varTarget).add("source", source);
            if (varTarget.exists() && cache.isSame()) continue;
            variants.add(Artifact.from(artifact.getGroup(), artifact.getName(), artifact.getVersion()));
            try {
                GradleModule.Variant[] data = JsonData.fromJson(source, GradleModule.Variant[].class);
                if (!this.dependenciesOnly) {
                    GradleModule.Variant.File file = new GradleModule.Variant.File(target);
                    for (GradleModule.Variant variant : data) {
                        variant.file(file);
                        if (suffix == null || pending.auxiliary() && this.globalAuxiliaryVariants) continue;
                        variant.name = variant.name + "-" + suffix;
                    }
                }
                Arrays.sort(data, (a, b) -> a.name.compareTo(b.name));
                JsonData.toJson(data, varTarget);
                cache.save();
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to write artifact variants: %s".formatted(artifact), t);
            }
        }
        for (Artifact artifact : variants) {
            this.updateVariants(artifact);
        }
    }

    private void updateFile(File target, File source, Artifact artifact) {
        boolean write;
        if (this.stubJars && "jar".equals(artifact.getExtension())) {
            this.writeStub(target, source, artifact);
            return;
        }
        HashStore cache = HashStore.fromFile(target).add("source", source);
        boolean isPom = "pom".equals(artifact.getExtension());
        if (isPom) {
            cache.addKnown("disableGradle", Boolean.toString(this.disableGradle));
            write = !target.exists() || (this.disableGradle || this.mappings.isPrimary()) && !cache.isSame();
        } else {
            boolean bl = write = !target.exists() || !cache.isSame();
        }
        if (write) {
            try {
                if (this.disableGradle && isPom) {
                    this.makeNonGradlePom(source, target);
                } else {
                    org.apache.commons.io.FileUtils.copyFile(source, target);
                }
                HashUtils.updateHash(target);
                cache.save();
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to generate artifact: %s".formatted(artifact), t);
            }
        }
    }

    private void writeStub(File target, File source, Artifact artifact) {
        File jdk;
        File tool = this.cache.maven().download(Constants.STUBIFY);
        HashStore cache = HashStore.fromFile(target).add("tool", tool).add("source", source);
        if (target.exists() && cache.isSame()) {
            return;
        }
        try {
            jdk = this.cache.jdks().get(25);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to find JDK for version 25", e);
        }
        File log = new File(source.getAbsolutePath() + ".stubify.log");
        ProcessUtils.Result ret = ProcessUtils.runJar(jdk, source.getParentFile(), log, tool, Collections.emptyList(), List.of("--input", source.getAbsolutePath(), "--output", target.getAbsolutePath()));
        if (ret.exitCode != 0) {
            throw new IllegalStateException("Failed to stubify jar file (exit code " + ret.exitCode + "), See log: " + log.getAbsolutePath());
        }
        try {
            cache.save();
            HashUtils.updateHash(target);
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to generate artifact: %s".formatted(artifact), t);
        }
    }

    private void updateVariants(Artifact artifact) {
        File root = new File(this.output, artifact.getFolder());
        ArrayList<File> inputs = new ArrayList<File>();
        for (File file : root.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".variants")) continue;
            inputs.add(file);
        }
        File target = new File(this.output, artifact.withExtension("module").getLocalPath());
        HashStore cache = HashStore.fromFile(target);
        for (File file : inputs) {
            cache.add(file);
        }
        if (target.exists() && cache.isSame()) {
            return;
        }
        GradleModule module = GradleModule.of(artifact);
        for (File input : inputs) {
            try {
                GradleModule.Variant[] data;
                for (GradleModule.Variant variant : data = JsonData.fromJson(input, GradleModule.Variant[].class)) {
                    module.variant(variant);
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to read artifact variants: %s".formatted(input), t);
            }
        }
        try {
            JsonData.toJson(module, target);
            HashUtils.updateHash(target);
            cache.save();
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Failed to write artifact module: %s".formatted(artifact), throwable);
        }
    }

    private void makeNonGradlePom(File source, File target) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(source);
        boolean modified = false;
        NodeList projects = doc.getElementsByTagName("project");
        for (int x = 0; x < projects.getLength(); ++x) {
            Node project = projects.item(x);
            NodeList children = project.getChildNodes();
            for (int y = 0; y < children.getLength(); ++y) {
                String content;
                Node child = children.item(y);
                if (child.getNodeType() != 8 || !(content = child.getTextContent()).equals(" do_not_remove: published-with-gradle-metadata ")) continue;
                project.removeChild(child);
                --y;
                modified = true;
            }
        }
        if (!modified) {
            org.apache.commons.io.FileUtils.copyFile(source, target);
            return;
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(new StreamSource(new StringReader("<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n    <xsl:strip-space elements=\"*\"/>\n    <xsl:output method=\"xml\" encoding=\"UTF-8\"/>\n\n    <xsl:template match=\"@*|node()\">\n        <xsl:copy>\n            <xsl:apply-templates select=\"@*|node()\"/>\n        </xsl:copy>\n    </xsl:template>\n</xsl:stylesheet>\n")));
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        transformer.transform(new DOMSource(doc), new StreamResult(output));
        byte[] data = output.toString().getBytes(StandardCharsets.UTF_8);
        FileUtils.ensureParent(target);
        try (FileOutputStream os = new FileOutputStream(target);){
            os.write(data);
        }
    }
}

