/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.java_provisioner;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraftforge.java_provisioner.JavaHomeLocator;
import net.minecraftforge.java_provisioner.api.JavaInstall;
import net.minecraftforge.java_provisioner.api.JavaProvisionerException;
import net.minecraftforge.util.os.OS;
import org.jetbrains.annotations.Nullable;

final class GradleLocator
extends JavaHomeLocator {
    private static final String GRADLE_FROMENV = "org.gradle.java.installations.fromEnv";
    private static final String GRADLE_PATHS = "org.gradle.java.installations.paths";
    private static final String MARKER_FILE = ".ready";
    private static final String LEGACY_MARKER_FILE = "provisioned.ok";
    private static final String MAC_JAVA_HOME_FOLDER = "Contents/Home";
    private static final Pattern GRADLE_ENV = Pattern.compile("JDK\\d\\d*");

    GradleLocator() {
    }

    @Override
    public File find(int version) throws JavaProvisionerException {
        JavaInstall ret = this.fromGradleEnv(null, version);
        if (ret != null) {
            return ret.home();
        }
        ret = this.fromPaths(null, version);
        if (ret != null) {
            return ret.home();
        }
        for (String key : System.getenv().keySet()) {
            if (!GRADLE_ENV.matcher(key).matches() || (ret = this.fromEnv(key, version)) == null) continue;
            return ret.home();
        }
        ret = this.fromGradleHome(null, version);
        if (ret != null) {
            return ret.home();
        }
        throw new JavaProvisionerException("Failed to find any Java installations from Gradle paths and properties");
    }

    @Override
    public List<JavaInstall> findAll(int version) {
        ArrayList<JavaInstall> ret = new ArrayList<JavaInstall>();
        this.fromGradleEnv(ret, version);
        this.fromPaths(ret, version);
        for (String key : System.getenv().keySet()) {
            JavaInstall install;
            if (!GRADLE_ENV.matcher(key).matches() || (install = this.fromEnv(key, version)) == null) continue;
            ret.add(install);
        }
        this.fromGradleHome(ret, version);
        if (ret.isEmpty()) {
            this.log("Failed to find any Java installations from Gradle paths and properties");
        }
        return ret;
    }

    @Nullable
    private JavaInstall fromGradleEnv(@Nullable List<JavaInstall> results, int version) {
        String prop = System.getProperty(GRADLE_FROMENV);
        this.log("Property: org.gradle.java.installations.fromEnv = " + prop);
        if (prop == null) {
            this.log("Could not find org.gradle.java.installations.fromEnv in system properties");
            return null;
        }
        String[] envs = prop.split(",");
        ArrayList<JavaInstall> found = new ArrayList<JavaInstall>(envs.length);
        for (String env : envs) {
            JavaInstall install = this.fromEnv(env, version);
            if (install == null) continue;
            if (results == null) {
                return install;
            }
            found.add(install);
        }
        if (found.isEmpty()) {
            this.log("Could not find any of " + prop + " in " + GRADLE_FROMENV);
            return null;
        }
        results.addAll(found);
        return null;
    }

    @Nullable
    private JavaInstall fromPaths(@Nullable List<JavaInstall> results, int version) {
        String prop = System.getProperty(GRADLE_PATHS);
        this.log("Property: org.gradle.java.installations.paths = " + prop);
        if (prop == null) {
            this.log("Could not find org.gradle.java.installations.paths in system properties");
            return null;
        }
        String[] envs = prop.split(",");
        ArrayList<JavaInstall> found = new ArrayList<JavaInstall>(envs.length);
        for (String path : envs) {
            JavaInstall install = this.fromPath(path, version);
            if (install == null) continue;
            if (results == null) {
                return install;
            }
            found.add(install);
        }
        if (found.isEmpty()) {
            this.log("Could not find any of " + prop + " in " + GRADLE_PATHS);
            return null;
        }
        results.addAll(found);
        return null;
    }

    private File getGradleHome() {
        String home = System.getProperty("gradle.user.home");
        if (home == null && (home = System.getenv("GRADLE_USER_HOME")) == null) {
            home = System.getProperty("user.home") + "/.gradle";
        }
        File ret = new File(home);
        try {
            return ret.getCanonicalFile();
        }
        catch (IOException e) {
            this.log("Could not get canonical path for Gradle home: " + ret);
            return ret.getAbsoluteFile();
        }
    }

    @Nullable
    private JavaInstall fromGradleHome(@Nullable List<JavaInstall> results, int version) {
        File gradleHome = this.getGradleHome();
        if (!gradleHome.exists() || !gradleHome.isDirectory()) {
            this.log("Gradle home: \"" + gradleHome.getAbsolutePath() + "\" Does not exist");
            return null;
        }
        File jdks = new File(gradleHome, "jdks");
        if (!jdks.exists() || !jdks.isDirectory()) {
            this.log("Gradle Home JDKs: \"" + jdks.getAbsolutePath() + "\" Does not exist");
            return null;
        }
        File[] listFiles = jdks.listFiles();
        if (listFiles == null) {
            this.log("Gradle Home JDKs: \"" + jdks.getAbsolutePath() + "\" Cannot be queried");
            return null;
        }
        ArrayList<@Nullable JavaInstall> found = new ArrayList<JavaInstall>(listFiles.length);
        for (File dir : listFiles) {
            if (!dir.isDirectory()) continue;
            List<File> markers = this.findMarkers(dir);
            for (File marked : markers) {
                if (OS.current() == OS.MACOS) {
                    marked = this.findMacHome(dir);
                }
                this.log("Gradle Home JDK: \"" + marked.getAbsolutePath() + "\"");
                JavaInstall install = this.fromPath(marked, version);
                if (install == null) continue;
                if (results == null) {
                    return install;
                }
                found.add(install);
            }
        }
        if (found.isEmpty()) {
            this.log("Could not find any Java installations in " + jdks.getAbsolutePath());
            return null;
        }
        results.addAll(found);
        return null;
    }

    private List<File> findMarkers(File root) {
        File[] listFiles;
        ArrayList<File> ret = new ArrayList<File>();
        if (new File(root, MARKER_FILE).exists() || new File(root, LEGACY_MARKER_FILE).exists()) {
            ret.add(root);
        }
        if ((listFiles = root.listFiles()) == null) {
            this.log("An unexpected error occured trying to find markers in: " + root);
            return ret;
        }
        for (File child : listFiles) {
            if (!child.isDirectory() || !new File(child, MARKER_FILE).exists() && !new File(child, LEGACY_MARKER_FILE).exists()) continue;
            ret.add(child);
        }
        return ret;
    }

    private File findMacHome(File root) {
        File tmp = new File(root, MAC_JAVA_HOME_FOLDER);
        if (tmp.exists()) {
            return tmp;
        }
        File[] listFiles = root.listFiles();
        if (listFiles == null) {
            this.log("An unexpected error occurred trying to find the macOS home of: " + root);
            return root;
        }
        for (File child : listFiles) {
            if (!child.isDirectory() || !(tmp = new File(child, MAC_JAVA_HOME_FOLDER)).exists()) continue;
            return tmp;
        }
        return root;
    }
}

