/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.cli;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraftforge.mcmaven.impl.Mavenizer;
import net.minecraftforge.mcmaven.impl.MinecraftMaven;
import net.minecraftforge.mcmaven.impl.cache.Cache;
import net.minecraftforge.mcmaven.impl.mappings.Mappings;
import net.minecraftforge.mcmaven.impl.mappings.ParchmentMappings;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCP;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPConfigRepo;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPSide;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MinecraftTasks;
import net.minecraftforge.mcmaven.impl.util.Artifact;
import net.minecraftforge.mcmaven.impl.util.Task;
import net.minecraftforge.srgutils.IMappingFile;
import net.minecraftforge.srgutils.IRenamer;
import net.minecraftforge.util.logging.Logger;

public class MCPDataTask {
    public static void run(String[] args) throws Exception {
        int ret = MCPDataTask.runI(args);
        if (ret != 0) {
            Mavenizer.LOGGER.release();
        }
    }

    private static int runI(String[] args) throws Exception {
        Artifact artifact;
        File jdkCacheRoot;
        Mavenizer.LOGGER.setEnabled(Logger.Level.INFO);
        OptionParser parser = new OptionParser();
        parser.allowsUnrecognizedOptions();
        AbstractOptionSpec helpO = parser.accepts("help", "Displays this help message and exits").forHelp();
        ArgumentAcceptingOptionSpec<File> cacheO = parser.accepts("cache", "Directory to store data needed for this program").withRequiredArg().ofType(File.class).defaultsTo(new File("cache"), (File[])new File[0]);
        ArgumentAcceptingOptionSpec<File> jdkCacheO = parser.accepts("jdk-cache", "Directory to store jdks downloaded from the disoco api").withRequiredArg().ofType(File.class).defaultsTo(new File("cache/jdks"), (File[])new File[0]);
        ArgumentAcceptingOptionSpec<File> outputO = parser.accepts("output", "File to place output data into").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<String> artifactO = parser.accepts("artifact", "MCPConfig artifact coordinates").withRequiredArg();
        ArgumentAcceptingOptionSpec<String> versionO = parser.accepts("version", "MCPConfig artifact version").availableUnless(artifactO, new OptionSpec[0]).withRequiredArg();
        OptionSpecBuilder officialO = parser.accepts("mappings", "Use to enable using official mappings");
        ArgumentAcceptingOptionSpec<String> parchmentO = parser.accepts("parchment", "Version of parchment mappings to use, snapshots are not supported").availableUnless(officialO, new OptionSpec[0]).withRequiredArg();
        officialO.availableUnless(parchmentO, new OptionSpec[0]);
        ArgumentAcceptingOptionSpec<String> keyO = parser.accepts("key", "The key for which data file to extract").withRequiredArg();
        OptionSet options = parser.parse(args);
        if (options.has(helpO)) {
            parser.printHelpOn(Mavenizer.LOGGER.getInfo());
            return -1;
        }
        File output = options.valueOf(outputO);
        File cacheRoot = options.valueOf(cacheO);
        File file = jdkCacheRoot = !options.has(cacheO) || options.has(jdkCacheO) ? options.valueOf(jdkCacheO) : new File(cacheRoot, "jdks");
        Artifact artifact2 = options.has(artifactO) ? Artifact.from(options.valueOf(artifactO)) : (artifact = options.has(versionO) ? Artifact.from("de.oceanlabs.mcp", "mcp_config", options.valueOf(versionO), null, "zip") : null);
        if (artifact == null) {
            Mavenizer.LOGGER.error("Missing mcp --version or --artifact");
            return -2;
        }
        String mcVersion = MinecraftMaven.mcpToMcVersion(artifact.getVersion());
        Mappings mappings = options.has(officialO) ? new Mappings("official", null).withMCVersion(mcVersion) : (options.has(parchmentO) ? new ParchmentMappings(options.valueOf(parchmentO)).withMCVersion(mcVersion) : null);
        String key = options.valueOf(keyO);
        if (key == null) {
            Mavenizer.LOGGER.error("Missing --key option");
            return -3;
        }
        MCPConfigRepo repo = new MCPConfigRepo(new Cache(cacheRoot, jdkCacheRoot), false);
        Mavenizer.LOGGER.info("  Output:     " + output.getAbsolutePath());
        Mavenizer.LOGGER.info("  Cache:      " + cacheRoot.getAbsolutePath());
        Mavenizer.LOGGER.info("  JDK Cache:  " + jdkCacheRoot.getAbsolutePath());
        Mavenizer.LOGGER.info("  Artifact:   " + String.valueOf(artifact));
        Mavenizer.LOGGER.info("  Key:        " + key);
        if (mappings != null) {
            Mavenizer.LOGGER.info("  Mappings:   " + String.valueOf(mappings));
        }
        Mavenizer.LOGGER.info();
        MCP mcp = repo.get(artifact);
        MCPSide side = mcp.getSide("joined");
        Map<String, String> cfg = mcp.getConfig().getData("joined");
        String path = cfg.get(key);
        if (path == null && "statics".equals(key)) {
            path = "config/static_methods.txt";
        }
        if (path == null) {
            Mavenizer.LOGGER.error("Could not find data entry for '%s'".formatted(key));
            return -4;
        }
        try (ZipFile zip = new ZipFile(mcp.getData());){
            ZipEntry entry = zip.getEntry(path);
            if (entry == null) {
                Mavenizer.LOGGER.error("Invalid config zip, missing file: " + path);
                int n = -5;
                return n;
            }
            if ("mappings".equals(key)) {
                IMappingFile ret = IMappingFile.load(zip.getInputStream(entry));
                if (mcp.getConfig().official) {
                    MinecraftTasks mc = mcp.getMinecraftTasks();
                    Task client = mc.versionFile("client_mappings", "txt");
                    Task server = mc.versionFile("server_mappings", "txt");
                    IMappingFile obf2OffClient = IMappingFile.load(client.execute());
                    IMappingFile obf2OffServer = IMappingFile.load(server.execute());
                    final IMappingFile obf2Off = obf2OffClient.merge(obf2OffServer).reverse();
                    ret = ret.rename(new IRenamer(){

                        @Override
                        public String rename(IMappingFile.IClass value) {
                            return obf2Off.remapClass(value.getOriginal());
                        }
                    });
                }
                if (mappings != null) {
                    File csv = mappings.getCsvZip(side).execute();
                    final Map<String, String> names = Mappings.load(csv).names();
                    ret = ret.rename(new IRenamer(){

                        @Override
                        public String rename(IMappingFile.IField value) {
                            return names.getOrDefault(value.getMapped(), value.getMapped());
                        }

                        @Override
                        public String rename(IMappingFile.IMethod value) {
                            return names.getOrDefault(value.getMapped(), value.getMapped());
                        }

                        @Override
                        public String rename(IMappingFile.IParameter value) {
                            return names.getOrDefault(value.getMapped(), value.getMapped());
                        }
                    });
                }
                ret.write(output.getAbsoluteFile().toPath(), IMappingFile.Format.TSRG2, false);
            } else {
                Files.copy(zip.getInputStream(entry), output.toPath(), new CopyOption[0]);
            }
        }
        return 0;
    }
}

