/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.cli;

import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

record JarVersionInfo(String specificationTitle, String specificationVendor, String specificationVersion, String implementationTitle, String implementationVendor, String implementationVersion) {
    JarVersionInfo(String title) {
        this("", "", "Undefined", title, "", "Undefined");
    }

    JarVersionInfo(String fallbackTitle, @Nullable String specificationTitle, @Nullable String specificationVendor, @Nullable String specificationVersion, @Nullable String implementationTitle, @Nullable String implementationVendor, @Nullable String implementationVersion) {
        this(JarVersionInfo.notNullOrEmpty(specificationTitle, ""), JarVersionInfo.notNullOrEmpty(specificationVendor, ""), JarVersionInfo.notNullOrEmpty(specificationVersion, "Undefined"), JarVersionInfo.notNullOrEmpty(implementationTitle, fallbackTitle), JarVersionInfo.notNullOrEmpty(implementationVendor, ""), JarVersionInfo.notNullOrEmpty(implementationVersion, "Undefined"));
    }

    String implementation() {
        int size = this.implementationTitle.length() + this.implementationVersion.length() + this.implementationVendor.length() + 5;
        StringBuilder ret = new StringBuilder(size).append(this.implementationTitle);
        if (JarVersionInfo.notEmptyOrUndefined(this.implementationVersion)) {
            ret.append(' ').append(this.implementationVersion);
        }
        if (JarVersionInfo.notEmptyOrUndefined(this.implementationVendor)) {
            ret.append(" by ").append(this.implementationVendor);
        }
        return ret.toString();
    }

    static JarVersionInfo of(String fallbackTitle, String packageName) {
        return JarVersionInfo.of(fallbackTitle, Package.getPackage(packageName));
    }

    static JarVersionInfo of(String fallbackTitle, Object object) {
        return JarVersionInfo.of(fallbackTitle, object.getClass());
    }

    static JarVersionInfo of(String fallbackTitle, Class<?> clazz) {
        return JarVersionInfo.of(fallbackTitle, clazz.getPackage());
    }

    static JarVersionInfo of(String fallbackTitle, @UnknownNullability Package pkg) {
        if (pkg == null) {
            return new JarVersionInfo(fallbackTitle);
        }
        return new JarVersionInfo(fallbackTitle, pkg.getSpecificationTitle(), pkg.getSpecificationVendor(), pkg.getSpecificationVersion(), pkg.getImplementationTitle(), pkg.getImplementationVendor(), pkg.getImplementationVersion());
    }

    private static String notNullOrEmpty(@Nullable String value, String defaultValue) {
        return value == null || value.isBlank() ? defaultValue : value;
    }

    private static boolean notEmptyOrUndefined(String value) {
        return !value.isEmpty() && !"Undefined".equals(value);
    }
}

