/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.repo.mcpconfig;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.mcmaven.impl.Mavenizer;
import net.minecraftforge.mcmaven.impl.util.Task;
import net.minecraftforge.mcmaven.impl.util.Util;
import net.minecraftforge.util.data.json.JsonData;
import net.minecraftforge.util.data.json.LauncherManifest;
import net.minecraftforge.util.data.json.MinecraftVersion;
import net.minecraftforge.util.download.DownloadUtils;
import net.minecraftforge.util.hash.HashStore;

public class MinecraftTasks {
    private final File cache;
    private final String version;
    public final Task launcherManifest;
    public final Task versionJson;
    private final Map<String, Task> versionFiles = new HashMap<String, Task>();

    MinecraftTasks(File cache, String version) {
        this.cache = new File(cache, "minecraft_tasks");
        this.version = version;
        this.launcherManifest = Task.named("downloadLauncherManifest", this::downloadLauncherManifest);
        this.versionJson = Task.named("downloadVersionJson[" + version + "]", this::downloadVersionJson);
    }

    private File downloadLauncherManifest() {
        File target = new File(this.cache, "launcher_manifest.json");
        if (!target.exists() || !Mavenizer.isCacheOnly() && target.lastModified() < System.currentTimeMillis() - 3600000L) {
            try {
                Mavenizer.assertNotCacheOnly();
                Mavenizer.assertOnline();
                DownloadUtils.downloadFile(target, "https://piston-meta.mojang.com/mc/game/version_manifest.json");
            }
            catch (IOException e) {
                Util.sneak(e);
            }
        }
        return target;
    }

    private File downloadVersionJson() {
        File target = new File(this.cache, this.version + "/version.json");
        File manifestF = this.downloadLauncherManifest();
        HashStore cache = HashStore.fromFile(target);
        cache.add("manifest", manifestF);
        if (target.exists() && cache.isSame()) {
            return target;
        }
        Mavenizer.assertNotCacheOnly();
        Mavenizer.assertOnline();
        LauncherManifest manifest = JsonData.launcherManifest(manifestF);
        URL url = manifest.getUrl(this.version);
        if (url == null) {
            throw new IllegalStateException("Failed to find url for " + this.version + " version.json");
        }
        try {
            DownloadUtils.downloadFile(target, url.toExternalForm());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to download " + String.valueOf(url), e);
        }
        cache.save();
        return target;
    }

    public Task versionFile(String key, String ext) {
        return this.versionFiles.computeIfAbsent(key, k -> Task.named("download[" + this.version + "][" + key + "]", () -> this.downloadVersionFile(key, ext)));
    }

    private File downloadVersionFile(String key, String ext) {
        File target = new File(this.cache, this.version + "/" + key + "." + ext);
        File manifestF = this.downloadVersionJson();
        HashStore cache = HashStore.fromFile(target);
        cache.add("manifest", manifestF);
        if (target.exists() && cache.isSame()) {
            return target;
        }
        Mavenizer.assertNotCacheOnly();
        Mavenizer.assertOnline();
        MinecraftVersion manifest = JsonData.minecraftVersion(manifestF);
        MinecraftVersion.Download dl = manifest.getDownload(key);
        if (dl == null || dl.url == null) {
            throw new IllegalStateException("Missing '" + key + "' from " + manifestF.getAbsolutePath());
        }
        try {
            DownloadUtils.downloadFile(target, dl.url.toExternalForm());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to download " + String.valueOf(dl.url), e);
        }
        cache.save();
        return target;
    }
}

