/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.mcmaven.impl.Mavenizer;
import net.minecraftforge.mcmaven.impl.mappings.Mappings;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPSide;
import net.minecraftforge.mcmaven.impl.tasks.MCPNames;
import net.minecraftforge.mcmaven.impl.util.Task;
import net.minecraftforge.srgutils.IMappingFile;
import net.minecraftforge.util.file.FileUtils;
import net.minecraftforge.util.hash.HashFunction;
import net.minecraftforge.util.hash.HashStore;
import net.minecraftforge.util.hash.HashUtils;
import org.apache.commons.io.IOUtils;

public final class RenameTask
implements Task {
    private final String name;
    private final MCPSide side;
    private final boolean javadocs;
    private final Task task;

    public RenameTask(File build, String name, MCPSide side, Task sources, Mappings mappings, boolean javadocs) {
        this.name = name;
        this.side = side;
        this.javadocs = javadocs;
        this.task = this.remapSources(sources, mappings.getFolder(build), mappings);
    }

    @Override
    public File execute() {
        return this.task.execute();
    }

    @Override
    public boolean resolved() {
        return this.task.resolved();
    }

    @Override
    public String name() {
        return this.task.name();
    }

    private Task remapSources(Task input, File outputDir, Mappings provider) {
        File output = new File(outputDir, !this.javadocs ? "remapped.jar" : "remapped-javadoc.jar");
        Task mappings = provider.getCsvZip(this.side);
        Task srg = this.javadocs ? this.side.getTasks().getMappings() : null;
        return Task.named("remap[" + this.name + "][" + String.valueOf(provider) + "]" + (!this.javadocs ? "" : "[javadoc]"), Task.deps(input, mappings, srg), () -> RenameTask.remapSourcesImpl(input, mappings, output, srg));
    }

    /*
     * WARNING - void declaration
     */
    private static File remapSourcesImpl(Task inputTask, Task mappingsTask, File output, Task srgTask) {
        File input = inputTask.execute();
        File mappings = mappingsTask.execute();
        File srg = srgTask == null ? null : srgTask.execute();
        HashStore cache = HashStore.fromFile(output);
        cache.add("input", input);
        cache.add("mappings", mappings);
        if (srg != null) {
            cache.add("whitelist", srg);
        }
        if (output.exists() && cache.isSame()) {
            return output;
        }
        Mavenizer.assertNotCacheOnly();
        try {
            MCPNames names = MCPNames.load(mappings);
            HashSet<CallSite> vanillaClasses = null;
            if (srg != null) {
                vanillaClasses = new HashSet<CallSite>();
                IMappingFile map = IMappingFile.load(srg);
                for (IMappingFile.IClass iClass : map.getClasses()) {
                    if (iClass.getMapped().indexOf(36) != -1) continue;
                    vanillaClasses.add((CallSite)((Object)(iClass.getMapped() + ".java")));
                }
            }
            FileUtils.ensureParent(output);
            try (ZipInputStream zin = new ZipInputStream(new FileInputStream(input));
                 ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(output));){
                void var12_16;
                ZipEntry zipEntry = zin.getNextEntry();
                while (var12_16 != null) {
                    zout.putNextEntry(FileUtils.getStableEntry(var12_16.getName()));
                    if (var12_16.getName().endsWith(".java")) {
                        boolean javadocs = vanillaClasses != null && vanillaClasses.contains(var12_16.getName());
                        String mapped = names.rename(zin, javadocs, javadocs);
                        IOUtils.write(mapped, (OutputStream)zout, StandardCharsets.UTF_8);
                    } else {
                        IOUtils.copy((InputStream)zin, (OutputStream)zout);
                    }
                    ZipEntry zipEntry2 = zin.getNextEntry();
                }
            }
            HashUtils.updateHash(output, HashFunction.SHA1);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to rename sources for " + input.getAbsolutePath(), e);
        }
        cache.save();
        return output;
    }
}

