/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.util.download;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Optional;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class DownloadUtilsImpl {
    private static final Duration TIMEOUT = Duration.ofSeconds(5L);
    private static final int MAX_REDIRECTS = 3;
    private static final HttpClient CLIENT = HttpClient.newBuilder().connectTimeout(TIMEOUT).followRedirects(HttpClient.Redirect.NEVER).build();
    private static final HttpRequest.Builder REQUEST_BUILDER = HttpRequest.newBuilder().timeout(TIMEOUT).header("User-Agent", "MinecraftForge-Utils").header("Accept", "application/json");

    private DownloadUtilsImpl() {
    }

    static InputStream connect(String address) throws IOException, InterruptedException {
        HttpResponse con;
        URI uri;
        try {
            uri = new URI(address);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase("https") && !scheme.equalsIgnoreCase("http")) {
            return uri.toURL().openStream();
        }
        ArrayList<String> redirections = new ArrayList<String>();
        int redirects = 0;
        while (true) {
            String location;
            int res;
            if ((res = (con = CLIENT.send(REQUEST_BUILDER.uri(uri).build(), info -> HttpResponse.BodySubscribers.ofInputStream())).statusCode()) == 301 || res == 302) {
                Optional<String> header = con.headers().firstValue("Location");
                if (header.isEmpty()) {
                    throw new IOException(String.format("No location header found in redirect response: %s -- previous redirections: [%s]", uri, String.join((CharSequence)", ", redirections)));
                }
                location = header.get();
                redirections.add(location);
                if (redirects == 2) {
                    throw new IOException(String.format("Too many redirects: %s -- redirections: [%s]", address, String.join((CharSequence)", ", redirections)));
                }
            } else {
                if (res != 404) break;
                throw new FileNotFoundException("Returned 404: " + address);
            }
            uri = uri.resolve(location);
            ++redirects;
        }
        return (InputStream)con.body();
    }

    static byte[] readInputStream(InputStream stream) throws IOException {
        return stream.readAllBytes();
    }
}

