/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.util;

import java.io.File;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraftforge.mcmaven.impl.util.ComparableVersion;
import net.minecraftforge.mcmaven.impl.util.Util;
import net.minecraftforge.util.data.OS;
import org.jetbrains.annotations.Nullable;

public class Artifact
implements Comparable<Artifact>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Pattern SEMI = Pattern.compile(":");
    private static final ComparableVersion MISSING_VERSION = new ComparableVersion("0");
    private final String group;
    private final String name;
    @Nullable
    private final String version;
    @Nullable
    private final String classifier;
    private final String ext;
    private final EnumSet<OS> os;
    @Nullable
    private transient String folder;
    @Nullable
    private transient String path;
    @Nullable
    private transient String file;
    @Nullable
    private transient String fullDescriptor;
    @Nullable
    private transient ComparableVersion comparableVersion;
    @Nullable
    private transient Boolean isSnapshot;

    public static Artifact from(String descriptor) {
        return new Artifact(descriptor);
    }

    public static Artifact from(String group, String name, String version) {
        return new Artifact(group, name, version, null, null, OS.UNKNOWN);
    }

    public static Artifact from(String group, String name, String version, @Nullable String classifier) {
        return new Artifact(group, name, version, classifier, null, OS.UNKNOWN);
    }

    public static Artifact from(String group, String name, String version, @Nullable String classifier, @Nullable String ext) {
        return new Artifact(group, name, version, classifier, ext, OS.UNKNOWN);
    }

    private Artifact(String descriptor) {
        String[] pts = SEMI.split(descriptor);
        if (pts.length < 2) {
            throw new IllegalArgumentException("Descriptor is missing group and name: " + descriptor);
        }
        this.group = pts[0];
        this.name = pts[1];
        int last = pts.length - 1;
        int idx = pts[last].indexOf(64);
        if (idx != -1) {
            this.ext = pts[last].substring(idx + 1);
            pts[last] = pts[last].substring(0, idx);
        } else {
            this.ext = "jar";
        }
        this.version = pts.length > 2 ? pts[2] : null;
        this.classifier = pts.length > 3 ? pts[3] : null;
        this.os = EnumSet.noneOf(OS.class);
    }

    private Artifact(String group, String name, String version, @Nullable String classifier, @Nullable String ext, OS os) {
        this(group, name, version, classifier, ext, os, new OS[0]);
    }

    private Artifact(String group, String name, String version, @Nullable String classifier, @Nullable String ext, OS osFirst, OS ... osRest) {
        this(group, name, version, classifier, ext, EnumSet.of(osFirst, osRest));
    }

    private Artifact(String group, String name, String version, @Nullable String classifier, @Nullable String ext, EnumSet<OS> os) {
        this.group = group;
        this.name = name;
        this.version = version;
        this.classifier = classifier;
        this.ext = Objects.requireNonNullElse(ext, "jar");
        this.os = os;
    }

    public String getLocalPath() {
        return this.getPath().replace('/', File.separatorChar);
    }

    public String getDescriptor() {
        if (this.fullDescriptor == null) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.group).append(':').append(this.name);
            if (this.version != null) {
                buf.append(':').append(this.version);
                if (this.classifier != null) {
                    buf.append(':').append(this.classifier);
                }
            }
            if (this.ext != null && !"jar".equals(this.ext)) {
                buf.append('@').append(this.ext);
            }
            this.fullDescriptor = buf.toString();
        }
        return this.fullDescriptor;
    }

    public String getPath() {
        if (this.path == null) {
            this.path = this.getFolder() + "/" + this.getFilename();
        }
        return this.path;
    }

    public String getFolder() {
        if (this.folder == null) {
            this.folder = this.version == null ? this.group.replace('.', '/') + "/" + this.name : this.group.replace('.', '/') + "/" + this.name + "/" + this.version;
        }
        return this.folder;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    public String getExtension() {
        return this.ext;
    }

    public EnumSet<OS> getOs() {
        return this.os;
    }

    public boolean allowsOS(OS os) {
        return this.os.isEmpty() || this.os.contains((Object)os);
    }

    public String getFilename() {
        if (this.file == null) {
            StringBuilder file = new StringBuilder();
            file.append(this.name);
            if (this.version != null) {
                file.append('-').append(this.version);
                if (this.classifier != null) {
                    file.append('-').append(this.classifier);
                }
            }
            file.append('.').append(this.ext);
            this.file = file.toString();
        }
        return this.file;
    }

    public boolean isSnapshot() {
        if (this.isSnapshot == null) {
            this.isSnapshot = this.version != null && this.version.toLowerCase(Locale.ROOT).endsWith("-snapshot");
        }
        return this.isSnapshot;
    }

    public Artifact withVersion(String version) {
        return new Artifact(this.group, this.name, version, this.classifier, this.ext, this.os);
    }

    public Artifact withClassifier(String classifier) {
        return new Artifact(this.group, this.name, this.version, classifier, this.ext, this.os);
    }

    public Artifact withExtension(String ext) {
        return new Artifact(this.group, this.name, this.version, this.classifier, ext, this.os);
    }

    public Artifact withOS(OS os) {
        EnumSet<OS> osSet = EnumSet.copyOf(this.os);
        osSet.add(os);
        return new Artifact(this.group, this.name, this.version, this.classifier, this.ext, osSet);
    }

    public Artifact withOS(EnumSet<OS> os) {
        return new Artifact(this.group, this.name, this.version, this.classifier, this.ext, os);
    }

    public String toString() {
        return this.getDescriptor();
    }

    public int hashCode() {
        return this.getDescriptor().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof Artifact)) return false;
        Artifact o = (Artifact)obj;
        if (!this.getDescriptor().equals(o.getDescriptor())) return false;
        return true;
    }

    ComparableVersion getComparableVersion() {
        if (this.comparableVersion == null) {
            this.comparableVersion = this.version == null ? MISSING_VERSION : new ComparableVersion(this.version);
        }
        return this.comparableVersion;
    }

    @Override
    public int compareTo(Artifact o) {
        if (o == this) {
            return 0;
        }
        if (o == null) {
            return 1;
        }
        return Objects.equals(this.group, o.group) && Objects.equals(this.name, o.name) && Objects.equals(this.classifier, o.classifier) && Objects.equals(this.ext, o.ext) ? Util.compare(this.getComparableVersion(), o.getComparableVersion()) : Util.compare(this.getDescriptor(), o.getDescriptor());
    }
}

