/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.repo.mcpconfig;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.minecraftforge.mcmaven.impl.GlobalOptions;
import net.minecraftforge.mcmaven.impl.cache.Cache;
import net.minecraftforge.mcmaven.impl.mappings.Mappings;
import net.minecraftforge.mcmaven.impl.repo.Repo;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCP;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPSide;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPTaskFactory;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MinecraftTasks;
import net.minecraftforge.mcmaven.impl.tasks.RecompileTask;
import net.minecraftforge.mcmaven.impl.tasks.RenameTask;
import net.minecraftforge.mcmaven.impl.util.Artifact;
import net.minecraftforge.mcmaven.impl.util.GradleAttributes;
import net.minecraftforge.mcmaven.impl.util.POMBuilder;
import net.minecraftforge.mcmaven.impl.util.Task;
import net.minecraftforge.mcmaven.impl.util.Util;
import net.minecraftforge.util.file.FileUtils;
import net.minecraftforge.util.hash.HashStore;

public final class MCPConfigRepo
extends Repo {
    private final Map<Artifact, MCP> versions = new HashMap<Artifact, MCP>();
    private final Map<String, MinecraftTasks> mcTasks = new HashMap<String, MinecraftTasks>();

    public MCPConfigRepo(Cache cache) {
        super(cache);
    }

    public MCP get(String version) {
        return this.get(Artifact.from("de.oceanlabs.mcp", "mcp_config", version, null, "zip"));
    }

    public MCP get(Artifact artifact) {
        return this.versions.computeIfAbsent(artifact, this::download);
    }

    private MCP download(Artifact artifact) {
        return new MCP(this, artifact);
    }

    public MinecraftTasks getMCTasks(String version) {
        return this.mcTasks.computeIfAbsent(version, k -> new MinecraftTasks(this.cache.root(), version));
    }

    @Override
    public List<Repo.PendingArtifact> process(Artifact artifact, Mappings mappings) {
        String module = artifact.getGroup() + ":" + artifact.getName();
        String version = artifact.getVersion();
        if (!module.startsWith("net.minecraft:")) {
            throw new IllegalArgumentException("MCPConfigRepo cannot process modules that aren't for group net.minecraft");
        }
        String side = module.substring("net.minecraft:".length());
        MCP mcp = this.get(Artifact.from("de.oceanlabs.mcp", "mcp_config", version, null, "zip"));
        MCPSide mcpSide = mcp.getSide(side);
        MCPTaskFactory mcpTasks = mcpSide.getTasks();
        File build = mcpSide.getBuildFolder();
        Artifact name = Artifact.from("net.minecraft", side, version);
        return switch (mappings.channel()) {
            case "notch" -> List.of(MCPConfigRepo.pending("Classes", mcpTasks.getRawJar(), name.withClassifier("raw"), this.simpleVariant("obf-notch", new Mappings("notch", null))));
            case "srg", "searge" -> List.of(MCPConfigRepo.pending("Classes", mcpTasks.getSrgJar(), name.withClassifier("srg"), this.simpleVariant("obf-searge", new Mappings("searge", null))));
            default -> {
                ArrayList<Repo.PendingArtifact> pending = new ArrayList<Repo.PendingArtifact>();
                RenameTask sourcesTask = new RenameTask(build, name, mcpSide, mcpSide.getSources(), mappings);
                RecompileTask recompile = new RecompileTask(build, name, mcpSide.getMCP(), mcpSide::getClasspath, sourcesTask.get(), mappings);
                Task classesTask = MCPConfigRepo.mergeExtra(build, side, recompile.get(), mcpSide.getTasks().getExtra(), mappings);
                Repo.PendingArtifact sources = MCPConfigRepo.pending("Sources", sourcesTask.get(), name.withClassifier("sources"), this.sourceVariant(mappings));
                Repo.PendingArtifact classes = MCPConfigRepo.pending("Classes", classesTask, name, () -> this.classVariants(mappings, mcpSide, new Artifact[0]));
                Repo.PendingArtifact metadata = MCPConfigRepo.pending("Metadata", MCPConfigRepo.metadata(build, mcpSide), name.withClassifier("metadata").withExtension("zip"));
                pending.addAll(List.of(sources, classes, metadata));
                if (mappings.isPrimary()) {
                    Repo.PendingArtifact pom = MCPConfigRepo.pending("Maven POM", MCPConfigRepo.pom(build, side, mcpSide, version), name.withExtension("pom"));
                    pending.add(pom);
                }
                yield pending;
            }
        };
    }

    public List<Repo.PendingArtifact> processExtra(String module, String version) {
        if (!module.startsWith("net.minecraft:")) {
            throw new IllegalArgumentException("MCPConfigRepo cannot process modules that aren't for group net.minecraft");
        }
        String side = module.substring("net.minecraft:".length());
        String displayName = Character.toUpperCase(side.charAt(0)) + side.substring(1);
        MCP mcp = this.get(Artifact.from("de.oceanlabs.mcp", "mcp_config", version, null, "zip"));
        MCPSide mcpSide = mcp.getSide(side);
        File build = mcpSide.getBuildFolder();
        Artifact name = Artifact.from("net.minecraft", side + "-extra", version);
        Task extraTask = mcpSide.getTasks().getExtra();
        Task pomTask = MCPConfigRepo.pomExtra(build, side + "-extra", version);
        Repo.PendingArtifact extra = MCPConfigRepo.pending(displayName + " Extra", extraTask, name);
        Repo.PendingArtifact pom = MCPConfigRepo.pending(displayName + " Maven POM", pomTask, name.withExtension("pom"));
        return List.of(extra, pom);
    }

    private static Task mergeExtra(File build, String side, Task recompiled, Task extra, Mappings mappings) {
        return Task.named("mergeExtra[" + side + "][" + String.valueOf(mappings) + "]", Set.of(extra, recompiled), () -> {
            File output = new File(mappings.getFolder(build), "recompiled-extra.jar");
            File recompiledF = recompiled.get();
            File extraF = extra.get();
            HashStore cache = HashStore.fromFile(output).add(recompiledF, extraF);
            if (output.exists() && cache.isSame()) {
                return output;
            }
            GlobalOptions.assertNotCacheOnly();
            try {
                FileUtils.mergeJars(output, true, extraF, recompiledF);
            }
            catch (IOException e) {
                Util.sneak(e);
            }
            cache.save();
            return output;
        });
    }

    private static Task metadata(File build, MCPSide side) {
        MinecraftTasks minecraftTasks = side.getMCP().getMinecraftTasks();
        return Task.named("metadata[forge]", Set.of(minecraftTasks.versionJson), () -> {
            File output = new File(build, "metadata.zip");
            File metadataDir = new File(output.getParentFile(), "metadata");
            File versionProperties = new File(metadataDir, "version.properties");
            File minecraftDir = new File(metadataDir, "minecraft");
            File versionJson = minecraftTasks.versionJson.get();
            HashStore cache = HashStore.fromFile(output).add(versionJson).add(versionProperties);
            if (output.exists() && cache.isSame()) {
                return output;
            }
            GlobalOptions.assertNotCacheOnly();
            try {
                FileUtils.ensureParent(output);
                FileUtils.ensure(metadataDir);
                FileUtils.ensure(minecraftDir);
                try (FileWriter writer = new FileWriter(versionProperties);){
                    writer.append("version=1").append('\n').flush();
                }
                Files.copy(versionJson.toPath(), new File(minecraftDir, "version.json").toPath(), StandardCopyOption.REPLACE_EXISTING);
                cache.add(versionProperties);
                FileUtils.makeZip(metadataDir, output);
            }
            catch (IOException e) {
                Util.sneak(e);
            }
            cache.save();
            return output;
        });
    }

    private static Task pom(File build, String side, MCPSide mcpSide, String version) {
        return Task.named("pom[" + side + "]", () -> {
            File output = new File(build, side + ".pom");
            HashStore cache = HashStore.fromFile(output);
            if (output.exists() && cache.isSame()) {
                return output;
            }
            GlobalOptions.assertNotCacheOnly();
            POMBuilder builder = new POMBuilder("net.minecraft", side, version).preferGradleModule().dependencies(dependencies -> mcpSide.forAllLibraries(dependencies::add, GradleAttributes.OperatingSystemFamily::allowsAll));
            FileUtils.ensureParent(output);
            try (FileOutputStream os = new FileOutputStream(output);){
                os.write(builder.build().getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException | ParserConfigurationException | TransformerException e) {
                Util.sneak(e);
            }
            cache.save();
            return output;
        });
    }

    private static Task pomExtra(File build, String side, String version) {
        return Task.named("pom[" + side + "]", () -> {
            File output = new File(build, side + ".pom");
            HashStore cache = HashStore.fromFile(output);
            if (output.exists() && cache.isSame()) {
                return output;
            }
            GlobalOptions.assertNotCacheOnly();
            POMBuilder builder = new POMBuilder("net.minecraft", side, version);
            FileUtils.ensureParent(output);
            try (FileOutputStream os = new FileOutputStream(output);){
                os.write(builder.build().getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException | ParserConfigurationException | TransformerException e) {
                Util.sneak(e);
            }
            cache.save();
            return output;
        });
    }
}

