/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.repo;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.minecraftforge.mcmaven.impl.GlobalOptions;
import net.minecraftforge.mcmaven.impl.cache.Cache;
import net.minecraftforge.mcmaven.impl.data.GradleModule;
import net.minecraftforge.mcmaven.impl.mappings.Mappings;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPSide;
import net.minecraftforge.mcmaven.impl.util.Artifact;
import net.minecraftforge.mcmaven.impl.util.GradleAttributes;
import net.minecraftforge.mcmaven.impl.util.POMBuilder;
import net.minecraftforge.mcmaven.impl.util.Task;
import net.minecraftforge.mcmaven.impl.util.Util;
import net.minecraftforge.util.data.OS;
import net.minecraftforge.util.data.json.JsonData;
import net.minecraftforge.util.file.FileUtils;
import net.minecraftforge.util.hash.HashStore;
import net.minecraftforge.util.logging.Log;
import org.jetbrains.annotations.Nullable;

public abstract class Repo {
    protected final Cache cache;

    protected Repo(Cache cache) {
        this.cache = cache;
    }

    public final Cache getCache() {
        return this.cache;
    }

    public abstract List<PendingArtifact> process(Artifact var1, Mappings var2);

    protected static PendingArtifact pending(String message, Task task, Artifact artifact) {
        return Repo.pending(message, task, artifact, null);
    }

    protected static PendingArtifact pending(String message, Task task, Artifact artifact, Supplier<GradleModule.Variant[]> variants) {
        return Repo.pending(message, task, artifact, Repo.variantTask(task, variants));
    }

    protected static PendingArtifact pending(String message, Task task, Artifact artifact, @Nullable Task variants) {
        return new PendingArtifact(message, task, artifact, variants);
    }

    protected Supplier<GradleModule.Variant[]> sourceVariant(Mappings mappings) {
        return () -> new GradleModule.Variant[]{GradleModule.Variant.of("sources").attribute("org.gradle.usage", "java-runtime").attribute("org.gradle.category", "documentation").attribute("org.gradle.dependency.bundling", "external").attribute("org.gradle.docstype", "sources").attribute("org.gradle.libraryelements", "jar").attribute("net.minecraftforge.mappings.channel", mappings.channel()).attribute("net.minecraftforge.mappings.version", mappings.version())};
    }

    protected static Task variantTask(Task parent, Supplier<GradleModule.Variant[]> supplier) {
        return Task.named(parent.name() + "[variants]", List.of(parent), () -> {
            GradleModule.Variant[] variants = (GradleModule.Variant[])supplier.get();
            File variantFile = new File(parent.get().getAbsolutePath() + ".variants");
            try {
                FileUtils.ensureParent(variantFile);
                JsonData.toJson(variants, variantFile);
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to write artifact variants: %s".formatted(variantFile), t);
            }
            return variantFile;
        });
    }

    protected Supplier<GradleModule.Variant[]> simpleVariant(String name, Mappings mappings) {
        return () -> new GradleModule.Variant[]{GradleModule.Variant.of(name).attribute("org.gradle.category", "library").attribute("org.gradle.libraryelements", "jar").attribute("net.minecraftforge.mappings.channel", mappings.channel()).attribute("net.minecraftforge.mappings.version", mappings.version())};
    }

    protected GradleModule.Variant[] classVariants(Mappings mappings, MCPSide side, Artifact ... extraDeps) {
        ArrayList all = new ArrayList();
        EnumMap<GradleAttributes.OperatingSystemFamily, List> natives = new EnumMap<GradleAttributes.OperatingSystemFamily, List>(GradleAttributes.OperatingSystemFamily.class);
        natives.put(GradleAttributes.OperatingSystemFamily.WINDOWS, new ArrayList());
        natives.put(GradleAttributes.OperatingSystemFamily.MACOS, new ArrayList());
        natives.put(GradleAttributes.OperatingSystemFamily.LINUX, new ArrayList());
        Consumer<Artifact> addToVariants = artifact -> {
            if (artifact == null) {
                return;
            }
            if (GradleAttributes.OperatingSystemFamily.allowsAll(artifact)) {
                all.add(artifact);
            } else {
                for (OS os : artifact.getOs()) {
                    GradleAttributes.OperatingSystemFamily variant = GradleAttributes.OperatingSystemFamily.from(os);
                    ((List)natives.get(variant)).add(artifact);
                }
            }
        };
        side.getMCLibraries().forEach(addToVariants);
        side.getMCPConfigLibraries().forEach(addToVariants);
        Arrays.asList(extraDeps).forEach(addToVariants);
        Integer java = Util.replace(JsonData.minecraftVersion(side.getMCP().getMinecraftTasks().versionJson.get()), v -> v.javaVersion != null ? Integer.valueOf(v.javaVersion.majorVersion) : null);
        Consumer<GradleModule.Variant> common = v -> {
            v.attribute("org.gradle.usage", "java-runtime").attribute("org.gradle.category", "library").attribute("org.gradle.dependency.bundling", "external").attribute("org.gradle.libraryelements", "jar").attribute("org.gradle.jvm.environment", "standard-jvm").attribute("net.minecraftforge.mappings.channel", mappings.channel()).attribute("net.minecraftforge.mappings.version", mappings.version());
            if (java != null) {
                v.attribute("org.gradle.jvm.version", java);
            }
            v.deps(all);
        };
        ArrayList variants = new ArrayList();
        natives.forEach((os, deps) -> variants.add(GradleModule.Variant.of("classes-" + os.getValue(), common).attribute((GradleModule.Attribute)os).deps((Iterable<? extends Artifact>)deps)));
        return variants.toArray(new GradleModule.Variant[0]);
    }

    protected static Task simplePom(File build, Artifact artifact) {
        return Task.named("pom[" + artifact.getName() + "]", () -> {
            File output = new File(build, artifact.getName() + "-" + artifact.getVersion() + ".pom");
            HashStore cache = HashStore.fromFile(output);
            if (output.exists() && cache.isSame()) {
                return output;
            }
            GlobalOptions.assertNotCacheOnly();
            POMBuilder builder = new POMBuilder(artifact.getGroup(), artifact.getName(), artifact.getVersion());
            FileUtils.ensureParent(output);
            try (FileOutputStream os = new FileOutputStream(output);){
                os.write(builder.build().getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException | ParserConfigurationException | TransformerException e) {
                Util.sneak(e);
            }
            cache.save();
            return output;
        });
    }

    public static final class PendingArtifact
    implements Supplier<File> {
        private final String message;
        private final Task task;
        private final Artifact artifact;
        @Nullable
        private final Task variants;

        private PendingArtifact(String message, Task task, Artifact artifact, @Nullable Task variants) {
            this.message = message;
            this.task = task;
            this.artifact = artifact;
            this.variants = variants;
        }

        @Override
        public File get() {
            if (this.task.resolved()) {
                return this.task.get();
            }
            try {
                Log.info(this.message);
                Log.push();
                File file = this.task.execute();
                return file;
            }
            finally {
                if (this.variants != null) {
                    this.variants.execute();
                }
                Log.pop();
            }
        }

        public Task getAsTask() {
            return this.task;
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        @Nullable
        public Task getVariants() {
            return this.variants;
        }
    }
}

