/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.cli;

import java.io.File;
import java.util.Set;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraftforge.mcmaven.impl.MinecraftMaven;
import net.minecraftforge.mcmaven.impl.cache.Cache;
import net.minecraftforge.mcmaven.impl.mappings.Mappings;
import net.minecraftforge.mcmaven.impl.mappings.ParchmentMappings;
import net.minecraftforge.mcmaven.impl.repo.forge.Patcher;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCP;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPConfigRepo;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPSide;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPTaskFactory;
import net.minecraftforge.mcmaven.impl.tasks.RenameTask;
import net.minecraftforge.mcmaven.impl.util.Artifact;
import net.minecraftforge.mcmaven.impl.util.Task;
import net.minecraftforge.mcmaven.impl.util.Util;
import net.minecraftforge.util.hash.HashFunction;
import net.minecraftforge.util.hash.HashStore;
import net.minecraftforge.util.logging.Log;
import org.apache.commons.io.FileUtils;

public class MCPTask {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(String[] args) throws Exception {
        File sas;
        File jdkCacheRoot;
        Log.enabled = Log.Level.INFO;
        OptionParser parser = new OptionParser();
        parser.allowsUnrecognizedOptions();
        AbstractOptionSpec helpO = parser.accepts("help", "Displays this help message and exits").forHelp();
        ArgumentAcceptingOptionSpec<File> cacheO = parser.accepts("cache", "Directory to store data needed for this program").withRequiredArg().ofType(File.class).defaultsTo(new File("cache"), (File[])new File[0]);
        ArgumentAcceptingOptionSpec<File> jdkCacheO = parser.accepts("jdk-cache", "Directory to store jdks downloaded from the disoco api").withRequiredArg().ofType(File.class).defaultsTo(new File("cache/jdks"), (File[])new File[0]);
        ArgumentAcceptingOptionSpec<File> outputO = parser.accepts("output", "Root directory to generate the maven repository").withRequiredArg().ofType(File.class).defaultsTo(new File("output.jar"), (File[])new File[0]);
        ArgumentAcceptingOptionSpec<String> artifactO = parser.accepts("artifact", "MCPConfig artifact coordinates").withRequiredArg();
        ArgumentAcceptingOptionSpec<String> versionO = parser.accepts("version", "MCPConfig artifact version").withRequiredArg();
        ArgumentAcceptingOptionSpec<String> pipelineO = parser.accepts("pipeline", "MCPConfig pipeline to run, typically [client|server|joined]").withRequiredArg().defaultsTo("joined", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<File> atO = parser.accepts("at", "Access Transformer config file to apply").withOptionalArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<File> sasO = parser.accepts("sas", "Side Annotation Stripper confg file to apply").withOptionalArg().ofType(File.class);
        OptionSpecBuilder mappingsO = parser.accepts("mappings", "Use to enable using official mappings");
        ArgumentAcceptingOptionSpec<String> parchmentO = parser.accepts("parchment", "Version of parchment mappings to use, snapshots are not supported").availableIf(mappingsO, new OptionSpec[0]).withRequiredArg();
        OptionSet options = parser.parse(args);
        if (options.has(helpO)) {
            parser.printHelpOn(Log.INFO);
            Log.release();
            return;
        }
        File output = options.valueOf(outputO);
        File cacheRoot = options.valueOf(cacheO);
        File file = jdkCacheRoot = !options.has(cacheO) || options.has(jdkCacheO) ? options.valueOf(jdkCacheO) : new File(cacheRoot, "jdks");
        Artifact artifact = options.has(artifactO) ? Artifact.from(options.valueOf(artifactO)) : (options.has(versionO) ? Artifact.from("de.oceanlabs.mcp", "mcp_config", options.valueOf(versionO), null, "zip") : null);
        String pipeline = options.valueOf(pipelineO);
        File ats = options.has(atO) ? options.valueOf(atO) : null;
        File file2 = sas = options.has(sasO) ? options.valueOf(sasO) : null;
        if (artifact == null) {
            Log.error("Missing mcp --version or --artifact");
            Log.release();
            return;
        }
        MCPConfigRepo repo = new MCPConfigRepo(new Cache(cacheRoot, jdkCacheRoot));
        Log.info("  Output:     " + output.getAbsolutePath());
        Log.info("  Cache:      " + cacheRoot.getAbsolutePath());
        Log.info("  JDK Cache:  " + jdkCacheRoot.getAbsolutePath());
        Log.info("  Artifact:   " + String.valueOf(artifact));
        Log.info("  Pipeline:   " + pipeline);
        Log.info("  Access:     " + (ats == null ? null : ats.getAbsolutePath()));
        Log.info("  SAS:        " + (sas == null ? null : sas.getAbsolutePath()));
        Log.info();
        MCP mcp = repo.get(artifact);
        MCPSide side = mcp.getSide(pipeline);
        Task sourcesTask = side.getSources();
        if (ats != null || sas != null) {
            Task tmp;
            String hash = Util.hash(HashFunction.SHA1, ats, sas);
            File dir = new File(side.getBuildFolder(), hash);
            Task predecomp = side.getTasks().getPreDecompile();
            if (ats != null) {
                tmp = predecomp;
                predecomp = Task.named("modifyAccess", Set.of(tmp), () -> Patcher.modifyAccess(dir, tmp, ats, repo.getCache()));
            }
            if (sas != null) {
                tmp = predecomp;
                predecomp = Task.named("stripSides", Set.of(tmp), () -> Patcher.stripSides(dir, tmp, sas, repo.getCache()));
            }
            MCPTaskFactory factory = side.getTasks().child(dir, predecomp);
            sourcesTask = factory.getLastTask();
        }
        File sources = null;
        Log.info("Creating MCP Source Jar");
        byte indent = Log.push();
        try {
            sources = sourcesTask.execute();
        }
        finally {
            Log.pop(indent);
        }
        HashStore cache = HashStore.fromFile(output).add("sources", sources);
        if (options.has(mappingsO)) {
            Log.info("Renaming MCP Source Jar");
            byte indent2 = Log.push();
            try {
                ParchmentMappings mappings = options.has(parchmentO) ? new ParchmentMappings(options.valueOf(parchmentO)) : new Mappings("official", null).withMCVersion(MinecraftMaven.mcpToMcVersion(artifact.getVersion()));
                Task renameTask = new RenameTask(side.getBuildFolder(), pipeline, side, Task.existing("sources", sources), (Mappings)mappings).get();
                sources = renameTask.execute();
            }
            finally {
                Log.pop(indent2);
            }
            cache.add("renamed", sources);
        }
        if (!output.exists() || !cache.isSame()) {
            try {
                FileUtils.copyFile(sources, output);
                cache.save();
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to generate artifact: %s".formatted(artifact), t);
            }
        }
    }
}

