/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.util;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import net.minecraftforge.util.hash.HashFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;

@NotNullByDefault
public class Util {
    private static final long ZIPTIME = 628041600000L;
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");

    public static <S extends Comparable<S>> int compare(@Nullable S a, @Nullable S b) {
        if (a == null) {
            return b == null ? 0 : -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    public static <R, E extends Throwable> R sneak(Throwable t) throws E {
        throw t;
    }

    public static <T> T make(T obj, Consumer<? super T> action) {
        action.accept(obj);
        return obj;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static <T, R> R replace(@Nullable T obj, Function<T, @Nullable R> action) {
        return obj != null ? (R)action.apply(obj) : null;
    }

    public static String hash(HashFunction func, File ... files) {
        try {
            List<File> existing = Stream.of(files).filter(f -> f != null && f.exists()).toList();
            return func.hash(existing);
        }
        catch (IOException e) {
            return (String)Util.sneak(e);
        }
    }

    public static ZipEntry getStableEntry(String name) {
        return Util.getStableEntry(name, 628041600000L);
    }

    public static ZipEntry getStableEntry(String name, long time) {
        TimeZone _default = TimeZone.getDefault();
        TimeZone.setDefault(GMT);
        ZipEntry ret = new ZipEntry(name);
        ret.setTime(time);
        TimeZone.setDefault(_default);
        return ret;
    }
}

