/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.mappings;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.mcmaven.impl.GlobalOptions;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPSide;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MinecraftTasks;
import net.minecraftforge.mcmaven.impl.util.Artifact;
import net.minecraftforge.mcmaven.impl.util.Constants;
import net.minecraftforge.mcmaven.impl.util.ProcessUtils;
import net.minecraftforge.mcmaven.impl.util.Task;
import net.minecraftforge.util.hash.HashStore;
import org.jetbrains.annotations.Nullable;

public class Mappings {
    public static final String CHANNEL_ATTR = "net.minecraftforge.mappings.channel";
    public static final String VERSION_ATTR = "net.minecraftforge.mappings.version";
    protected final Map<MCPSide, Task> tasks = new HashMap<MCPSide, Task>();
    private final String channel;
    @Nullable
    private final String version;

    public Mappings(String channel, @Nullable String version) {
        this.channel = channel;
        this.version = version;
    }

    public String channel() {
        return this.channel;
    }

    @Nullable
    public String version() {
        return this.version;
    }

    public String toString() {
        return this.channel() + (String)(this.version() == null ? "" : "-" + this.version());
    }

    public File getFolder(File root) {
        return new File(root, this.channel() + "/" + this.version());
    }

    public boolean isPrimary() {
        return true;
    }

    public Mappings withMCVersion(String version) {
        return new Mappings(this.channel(), version);
    }

    public Artifact getArtifact(MCPSide side) {
        String mcpVersion = side.getMCP().getName().getVersion();
        String mcVersion = side.getMCP().getConfig().version;
        Object artifactVersion = mcpVersion;
        if (this.version != null && !mcVersion.equals(this.version)) {
            artifactVersion = mcpVersion + "-" + this.version;
        }
        return Artifact.from("net.minecraft", "mappings_" + this.channel, (String)artifactVersion).withExtension("zip");
    }

    public Task getCsvZip(MCPSide side) {
        Task ret = this.tasks.get(side);
        if (ret != null) {
            return ret;
        }
        MinecraftTasks mc = side.getMCP().getMinecraftTasks();
        Task srg = side.getTasks().getMappings();
        Task client = mc.versionFile("client_mappings", "txt");
        Task server = mc.versionFile("server_mappings", "txt");
        ret = Task.named("srg2names[" + String.valueOf(this) + "]", Set.of(srg, client, server), () -> this.getMappings(side, srg, client, server));
        this.tasks.put(side, ret);
        return ret;
    }

    private File getMappings(MCPSide side, Task srgMappings, Task clientTask, Task serverTask) {
        File tool = side.getMCP().getCache().maven().download(Constants.INSTALLER_TOOLS);
        File root = this.getFolder(new File(side.getMCP().getBuildFolder(), "data/mapings"));
        File output = new File(root, "official.zip");
        File log = new File(root, "official.log");
        File mappings = srgMappings.execute();
        File client = clientTask.execute();
        File server = serverTask.execute();
        HashStore cache = HashStore.fromFile(output);
        cache.add("tool", tool);
        cache.add("mappings", mappings);
        cache.add("client", client);
        cache.add("server", server);
        if (output.exists() && cache.isSame()) {
            return output;
        }
        GlobalOptions.assertNotCacheOnly();
        List<String> args = List.of("--task", "MAPPINGS_CSV", "--srg", mappings.getAbsolutePath(), "--client", client.getAbsolutePath(), "--server", server.getAbsolutePath(), "--output", output.getAbsolutePath());
        File jdk = side.getMCP().getCache().jdks().get(8);
        if (jdk == null) {
            throw new IllegalStateException("Failed to find JDK for version 8");
        }
        ProcessUtils.Result ret = ProcessUtils.runJar(jdk, log.getParentFile(), log, tool, Collections.emptyList(), args);
        if (ret.exitCode != 0) {
            throw new IllegalStateException("Failed to run MCP Step, See log: " + log.getAbsolutePath());
        }
        cache.save();
        return output;
    }
}

