/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.repo.mcpconfig;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCP;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPTaskFactory;
import net.minecraftforge.mcmaven.impl.util.Artifact;
import net.minecraftforge.mcmaven.impl.util.Task;
import org.jetbrains.annotations.Nullable;

public class MCPSide {
    public static final String CLIENT = "client";
    public static final String SERVER = "server";
    public static final String JOINED = "joined";
    private final MCP mcp;
    private final String side;
    private final File build;
    private final MCPTaskFactory factory;

    MCPSide(MCP owner, String side) {
        this.mcp = owner;
        this.side = side;
        this.build = new File(this.mcp.getBuildFolder(), this.side);
        this.factory = new MCPTaskFactory(this, this.build);
    }

    public boolean containsClient() {
        return this.side.equals(JOINED) || this.side.equals(CLIENT);
    }

    public boolean containsServer() {
        return this.side.equals(JOINED) || this.side.equals(SERVER);
    }

    public MCPTaskFactory getTasks() {
        return this.factory;
    }

    public String getName() {
        return this.side;
    }

    public MCP getMCP() {
        return this.mcp;
    }

    public File getBuildFolder() {
        return this.build;
    }

    public void forAllLibraries(Consumer<Artifact> consumer) {
        this.forAllLibraries(consumer, null);
    }

    public void forAllLibraries(Consumer<Artifact> consumer, Predicate<Artifact> filter) {
        this.forAllLibrariesInternal(consumer, filter, this.getMCLibraries());
        this.forAllLibrariesInternal(consumer, filter, this.getMCPConfigLibraries());
    }

    private void forAllLibrariesInternal(Consumer<? super Artifact> consumer, @Nullable Predicate<? super Artifact> filter, Iterable<? extends Artifact> libraries) {
        for (Artifact artifact : libraries) {
            if (filter != null && !filter.test(artifact)) continue;
            consumer.accept(artifact);
        }
    }

    public List<Artifact> getMCLibraries() {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (MCPTaskFactory.Lib lib : this.getTasks().getLibraries()) {
            artifacts.add(lib.name());
        }
        return artifacts;
    }

    public List<Artifact> getMCPConfigLibraries() {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (String lib : this.mcp.getConfig().getLibraries(this.side)) {
            Artifact artifact = Artifact.from(lib);
            artifacts.add(artifact);
        }
        return artifacts;
    }

    public Task getSources() {
        return this.getTasks().getLastTask();
    }

    public List<File> getClasspath() {
        ArrayList<File> classpath = new ArrayList<File>();
        for (MCPTaskFactory.Lib lib : this.factory.getLibraries()) {
            classpath.add(lib.file());
        }
        for (String string : this.mcp.getConfig().getLibraries(this.side)) {
            classpath.add(this.mcp.getCache().maven().download(Artifact.from(string)));
        }
        return classpath;
    }
}

