/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraftforge.mcmaven.impl.GlobalOptions;
import net.minecraftforge.mcmaven.impl.cache.Cache;
import net.minecraftforge.mcmaven.impl.data.GradleModule;
import net.minecraftforge.mcmaven.impl.mappings.Mappings;
import net.minecraftforge.mcmaven.impl.repo.Repo;
import net.minecraftforge.mcmaven.impl.repo.forge.FGVersion;
import net.minecraftforge.mcmaven.impl.repo.forge.ForgeRepo;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPConfigRepo;
import net.minecraftforge.mcmaven.impl.util.Artifact;
import net.minecraftforge.mcmaven.impl.util.ComparableVersion;
import net.minecraftforge.util.data.json.JsonData;
import net.minecraftforge.util.hash.HashStore;
import net.minecraftforge.util.hash.HashUtils;
import net.minecraftforge.util.logging.Log;
import org.apache.commons.io.FileUtils;

public record MinecraftMaven(File output, Cache cache, Mappings mappings, Map<String, String> foreignRepositories, boolean globalAuxiliaryVariants) {
    private static final ComparableVersion MIN_SUPPORTED_FORGE = new ComparableVersion("1.14.4");

    public MinecraftMaven(File output, File cacheRoot, File jdkCacheRoot, Mappings mappings, Map<String, String> foreignRepositories, boolean globalAuxiliaryVariants) {
        this(output, new Cache(cacheRoot, jdkCacheRoot, foreignRepositories), mappings, foreignRepositories, globalAuxiliaryVariants);
    }

    public MinecraftMaven {
        Log.info("  Output:            " + output.getAbsolutePath());
        Log.info("  Cache:             " + cache.root().getAbsolutePath());
        Log.info("  JDK Cache:         " + cache.jdks().root().getAbsolutePath());
        Log.info("  Offline:           " + GlobalOptions.isOffline());
        Log.info("  Cache Only:        " + GlobalOptions.isCacheOnly());
        Log.info("  Mappings:          " + String.valueOf(mappings));
        if (!foreignRepositories.isEmpty()) {
            Log.info("  Foreign Repos:     [" + String.join((CharSequence)", ", foreignRepositories.values()) + "]");
        }
        Log.info("  GradleVariantHack: " + globalAuxiliaryVariants);
        Log.info();
    }

    public void run(Artifact artifact) {
        String module = artifact.getGroup() + ":" + artifact.getName();
        String version = artifact.getVersion();
        Log.info("Processing Minecraft dependency: %s:%s".formatted(module, version));
        MCPConfigRepo mcprepo = new MCPConfigRepo(this.cache);
        if ("net.minecraftforge".equals(artifact.getGroup()) && "forge".equals(artifact.getName())) {
            ForgeRepo repo = new ForgeRepo(this.cache, mcprepo);
            if (artifact.getVersion() == null) {
                throw new IllegalArgumentException("No version specified for Forge");
            }
            if ("all".equals(version)) {
                List<String> versions = this.cache.maven().getVersions(artifact);
                HashMap<String, Mappings> mappingCache = new HashMap<String, Mappings>();
                for (String ver : versions.reversed()) {
                    FGVersion fg;
                    ComparableVersion cver = new ComparableVersion(ver);
                    if (cver.compareTo(MIN_SUPPORTED_FORGE) < 0 || (fg = FGVersion.fromForge(ver)) == null || fg.ordinal() < FGVersion.v3.ordinal()) continue;
                    Mappings mappings = mappingCache.computeIfAbsent(MinecraftMaven.forgeToMcVersion(ver), this.mappings()::withMCVersion);
                    Artifact art = artifact.withVersion(ver);
                    List<Repo.PendingArtifact> artifacts = repo.process(art, mappings);
                    this.finalize(art, mappings, artifacts);
                }
            } else {
                Mappings mappings = this.mappings().withMCVersion(MinecraftMaven.forgeToMcVersion(version));
                List<Repo.PendingArtifact> artifacts = repo.process(artifact, mappings);
                this.finalize(artifact, mappings, artifacts);
            }
        } else if ("net.minecraft".equals(artifact.getGroup())) {
            if (artifact.getVersion() == null) {
                throw new IllegalArgumentException("No version specified for MCPConfig");
            }
            Mappings mappings = this.mappings().withMCVersion(MinecraftMaven.mcpToMcVersion(version));
            List<Repo.PendingArtifact> artifacts = mcprepo.process(artifact, mappings);
            this.finalize(artifact, mappings, artifacts);
        } else {
            throw new IllegalArgumentException("Artifact '%s' is currently Unsupported. Will add later".formatted(module));
        }
    }

    private static String forgeToMcVersion(String version) {
        int idx = version.indexOf(45);
        if (idx == -1) {
            throw new IllegalArgumentException("Invalid Forge version: " + version);
        }
        return version.substring(0, idx).replace('_', '-');
    }

    public static String mcpToMcVersion(String version) {
        int idx = version.lastIndexOf(45);
        if (idx < 0) {
            return version;
        }
        if (!version.substring(idx + 1).matches("\\d{8}\\.\\d{6}")) {
            return version;
        }
        return version.substring(0, idx);
    }

    private void finalize(Artifact module, Mappings mappings, List<Repo.PendingArtifact> artifacts) {
        HashSet<Artifact> variants = new HashSet<Artifact>();
        for (Repo.PendingArtifact pending : artifacts) {
            boolean write;
            if (pending == null) continue;
            Artifact artifact = pending.getArtifact();
            String suffix = null;
            if (pending.getVariants() != null && !mappings.isPrimary()) {
                suffix = mappings.channel() + "-" + mappings.version();
                artifact = artifact.getClassifier() == null ? artifact.withClassifier(suffix) : artifact.withClassifier(artifact.getClassifier() + "-" + suffix);
            }
            File target = new File(this.output, artifact.getLocalPath());
            File varTarget = new File(this.output, artifact.getLocalPath() + ".variants");
            File source = pending.get();
            HashStore cache = HashStore.fromFile(target).add("source", source);
            if ("pom".equals(pending.getArtifact().getExtension())) {
                write = !target.exists() || mappings.isPrimary() && !cache.isSame();
            } else {
                boolean bl = write = !target.exists() || !cache.isSame();
            }
            if (write) {
                try {
                    FileUtils.copyFile(source, target);
                    HashUtils.updateHash(target);
                    cache.save();
                }
                catch (Throwable t) {
                    throw new RuntimeException("Failed to generate artifact: %s".formatted(artifact), t);
                }
            }
            if (pending.getVariants() == null) continue;
            source = pending.getVariants().execute();
            cache = HashStore.fromFile(varTarget).add("source", source);
            if (varTarget.exists() && cache.isSame()) continue;
            variants.add(Artifact.from(artifact.getGroup(), artifact.getName(), artifact.getVersion()));
            try {
                GradleModule.Variant[] data = JsonData.fromJson(source, GradleModule.Variant[].class);
                GradleModule.Variant.File file = new GradleModule.Variant.File(target);
                for (GradleModule.Variant variant : data) {
                    variant.file(file);
                    if (suffix == null || pending.isAuxiliary() && this.globalAuxiliaryVariants) continue;
                    variant.name = variant.name + "-" + suffix;
                }
                JsonData.toJson(data, varTarget);
                cache.save();
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to write artifact variants: %s".formatted(artifact), t);
            }
        }
        for (Artifact artifact : variants) {
            this.updateVariants(artifact);
        }
    }

    private void updateVariants(Artifact artifact) {
        File root = new File(this.output, artifact.getFolder());
        ArrayList<File> inputs = new ArrayList<File>();
        for (File file : root.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".variants")) continue;
            inputs.add(file);
        }
        File target = new File(this.output, artifact.withExtension("module").getLocalPath());
        HashStore cache = HashStore.fromFile(target);
        for (File file : inputs) {
            cache.add(file);
        }
        if (target.exists() && cache.isSame()) {
            return;
        }
        GradleModule module = GradleModule.of(artifact);
        for (File input : inputs) {
            try {
                GradleModule.Variant[] data;
                for (GradleModule.Variant variant : data = JsonData.fromJson(input, GradleModule.Variant[].class)) {
                    module.variant(variant);
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to read artifact variants: %s".formatted(input), t);
            }
        }
        try {
            JsonData.toJson(module, target);
            HashUtils.updateHash(target);
            cache.save();
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Failed to write artifact module: %s".formatted(artifact), throwable);
        }
    }
}

