/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.cli;

import java.time.Duration;
import java.util.ArrayList;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraftforge.mcmaven.cli.JarVersionInfo;
import net.minecraftforge.mcmaven.cli.Tasks;
import net.minecraftforge.util.logging.Log;

public class Main {
    private static final String DISPLAY_NAME = "Minecraft Mavenizer";

    public static void main(String[] args) throws Exception {
        long start = System.nanoTime();
        try {
            Log.capture();
            Log.info(JarVersionInfo.of(DISPLAY_NAME, Main.class).implementation());
            Main.run(args);
        }
        catch (Throwable e) {
            Log.release();
            throw e;
        }
        Duration time = Duration.ofNanos(System.nanoTime() - start);
        if (Log.isCapturing()) {
            Log.drop();
            Log.INFO.print("Minecraft Maven is up-to-date");
        } else {
            Log.INFO.print("Minecraft Maven has finished");
        }
        Log.INFO.println(String.format(", took %d:%02d.%03d", time.toMinutesPart(), time.toSecondsPart(), time.toMillisPart()));
    }

    private static void run(String[] args) throws Exception {
        OptionParser parser = new OptionParser();
        parser.allowsUnrecognizedOptions();
        Tasks[] tasks = Tasks.values();
        ArrayList<OptionSpecBuilder> opts = new ArrayList<OptionSpecBuilder>();
        for (Tasks task : tasks) {
            opts.add(parser.accepts(task.key, task.description));
        }
        for (OptionSpecBuilder opt : opts) {
            for (OptionSpecBuilder o : opts) {
                if (o == opt) continue;
                opt.availableUnless(o, new OptionSpec[0]);
            }
        }
        OptionSet options = parser.parse(args);
        for (Tasks task : tasks) {
            if (!options.has(task.key)) continue;
            task.callback.run(args);
            return;
        }
        parser.printHelpOn(Log.INFO);
        Log.release();
    }
}

