/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.java_provisioner;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraftforge.java_provisioner.JavaHomeLocator;
import net.minecraftforge.java_provisioner.api.IJavaInstall;
import net.minecraftforge.java_provisioner.util.OS;

public class GradleLocator
extends JavaHomeLocator {
    private static final String GRADLE_FROMENV = "org.gradle.java.installations.fromEnv";
    private static final String GRADLE_PATHS = "org.gradle.java.installations.paths";
    private static final String MARKER_FILE = ".ready";
    private static final String LEGACY_MARKER_FILE = "provisioned.ok";
    private static final String MAC_JAVA_HOME_FOLDER = "Contents/Home";
    private static final Pattern GRADLE_ENV = Pattern.compile("JDK\\d\\d*");

    @Override
    public File find(int version) {
        ArrayList<IJavaInstall> results = new ArrayList<IJavaInstall>();
        this.fromGradleEnv(results, version);
        if (!results.isEmpty()) {
            return ((IJavaInstall)results.get(0)).home();
        }
        this.fromPaths(results, version);
        if (!results.isEmpty()) {
            return ((IJavaInstall)results.get(0)).home();
        }
        IJavaInstall result = this.fromEnv("JDK" + version);
        if (result != null) {
            if (result.majorVersion() != version) {
                this.log("  Wrong version: Was " + result.majorVersion() + " wanted " + version);
            } else {
                return result.home();
            }
        }
        this.fromGradleHome(results, version);
        if (!results.isEmpty()) {
            return ((IJavaInstall)results.get(0)).home();
        }
        return null;
    }

    @Override
    public List<IJavaInstall> findAll() {
        ArrayList<IJavaInstall> ret = new ArrayList<IJavaInstall>();
        this.fromGradleEnv(ret, -1);
        this.fromPaths(ret, -1);
        for (String key : System.getenv().keySet()) {
            IJavaInstall tmp;
            if (!GRADLE_ENV.matcher(key).matches() || (tmp = this.fromEnv(key)) == null) continue;
            ret.add(tmp);
        }
        this.fromGradleHome(ret, -1);
        return ret;
    }

    @Override
    public List<String> logOutput() {
        return this.searched;
    }

    private void fromGradleEnv(Collection<IJavaInstall> list, int version) {
        String[] envs;
        String prop = System.getProperty(GRADLE_FROMENV);
        this.log("Property: org.gradle.java.installations.fromEnv = " + prop);
        if (prop == null) {
            return;
        }
        for (String env : envs = prop.split(",")) {
            IJavaInstall ret = this.fromEnv(env);
            if (ret == null) continue;
            if (version == -1) {
                list.add(ret);
                continue;
            }
            if (ret.majorVersion() != version) {
                this.log("  Wrong version: Was " + ret.majorVersion() + " wanted " + version);
                continue;
            }
            list.add(ret);
            return;
        }
    }

    private void fromPaths(Collection<IJavaInstall> list, int version) {
        String[] envs;
        String prop = System.getProperty(GRADLE_PATHS);
        this.log("Property: org.gradle.java.installations.paths = " + prop);
        if (prop == null) {
            return;
        }
        for (String path : envs = prop.split(",")) {
            IJavaInstall ret = this.fromPath(path);
            if (ret == null) continue;
            if (version == -1) {
                list.add(ret);
                continue;
            }
            if (ret.majorVersion() != version) {
                this.log("  Wrong version: Was " + ret.majorVersion() + " wanted " + version);
                continue;
            }
            list.add(ret);
            return;
        }
    }

    private File getGradleHome() {
        String home = System.getProperty("gradle.user.home");
        if (home == null && (home = System.getenv("GRADLE_USER_HOME")) == null) {
            home = System.getProperty("user.home") + "/.gradle";
        }
        File ret = new File(home);
        try {
            ret = ret.getCanonicalFile();
        }
        catch (IOException e) {
            return ret;
        }
        return ret;
    }

    private void fromGradleHome(Collection<IJavaInstall> list, int version) {
        File gradleHome = this.getGradleHome();
        if (!gradleHome.exists() || !gradleHome.isDirectory()) {
            this.log("Gradle home: \"" + gradleHome.getAbsolutePath() + "\" Does not exist");
            return;
        }
        File jdks = new File(gradleHome, "jdks");
        if (!jdks.exists() || !jdks.isDirectory()) {
            this.log("Gradle Home JDKs: \"" + jdks.getAbsolutePath() + "\" Does not exist");
            return;
        }
        for (File dir : jdks.listFiles()) {
            if (!dir.isDirectory()) continue;
            List<File> markers = this.findMarkers(dir);
            for (File marked : markers) {
                if (OS.CURRENT == OS.OSX) {
                    marked = this.findMacHome(dir);
                }
                this.log("Gradle Home JDK: \"" + marked.getAbsolutePath() + "\"");
                IJavaInstall ret = this.fromPath(marked);
                if (ret == null) continue;
                if (version == -1) {
                    list.add(ret);
                    continue;
                }
                if (ret.majorVersion() != version) {
                    this.log("  Wrong version: Was " + ret.majorVersion() + " wanted " + version);
                    continue;
                }
                list.add(ret);
                return;
            }
        }
    }

    private List<File> findMarkers(File root) {
        ArrayList<File> ret = new ArrayList<File>();
        if (new File(root, MARKER_FILE).exists() || new File(root, LEGACY_MARKER_FILE).exists()) {
            ret.add(root);
        }
        for (File child : root.listFiles()) {
            if (!child.isDirectory() || !new File(child, MARKER_FILE).exists() && !new File(child, LEGACY_MARKER_FILE).exists()) continue;
            ret.add(child);
        }
        return ret;
    }

    private File findMacHome(File root) {
        File tmp = new File(root, MAC_JAVA_HOME_FOLDER);
        if (tmp.exists()) {
            return tmp;
        }
        for (File child : root.listFiles()) {
            if (!child.isDirectory() || !(tmp = new File(child, MAC_JAVA_HOME_FOLDER)).exists()) continue;
            return tmp;
        }
        return root;
    }
}

