/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.java_provisioner;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.java_provisioner.Disco;
import net.minecraftforge.java_provisioner.JavaHomeLocator;
import net.minecraftforge.java_provisioner.api.IJavaInstall;
import net.minecraftforge.java_provisioner.util.OS;

public class DiscoLocator
extends JavaHomeLocator {
    private final File cache;
    private final boolean offline;

    public DiscoLocator(File cache) {
        this(cache, false);
    }

    public DiscoLocator(File cache, boolean offline) {
        this.cache = cache;
        this.offline = offline;
    }

    @Override
    public File find(int version) {
        List<IJavaInstall> results = this.findInternal(version);
        return results.isEmpty() ? null : results.get(0).home();
    }

    @Override
    public List<IJavaInstall> findAll() {
        return this.findInternal(-1);
    }

    private List<IJavaInstall> findInternal(int version) {
        if (!this.cache.exists() || !this.cache.isDirectory()) {
            return Collections.emptyList();
        }
        ArrayList<IJavaInstall> results = new ArrayList<IJavaInstall>();
        for (File dir : this.cache.listFiles()) {
            if (!dir.isDirectory()) continue;
            this.log("Disco Cache: \"" + dir.getAbsolutePath() + "\"");
            IJavaInstall ret = this.fromPath(dir);
            if (ret == null) continue;
            if (version == -1) {
                results.add(ret);
                continue;
            }
            if (ret.majorVersion() != version) {
                this.log("  Wrong version: Was " + ret.majorVersion() + " wanted " + version);
                continue;
            }
            results.add(ret);
            return results;
        }
        return results;
    }

    @Override
    public IJavaInstall provision(int version) {
        this.log("Locators failed to find any suitable installs, attempting Disco download");
        Disco disco = new Disco(this.cache, this.offline){

            @Override
            protected void debug(String message) {
                DiscoLocator.this.log(message);
            }

            @Override
            protected void error(String message) {
                DiscoLocator.this.log(message);
            }
        };
        List<Disco.Package> jdks = disco.getPackages(version, OS.CURRENT, Disco.Distro.TEMURIN, Disco.Arch.CURRENT);
        if (jdks == null || jdks.isEmpty()) {
            this.log("Failed to find any distros from Disco for " + version + " " + (Object)((Object)OS.CURRENT) + " " + (Object)((Object)Disco.Arch.CURRENT) + " " + Disco.Distro.TEMURIN);
            jdks = disco.getPackages(version, OS.CURRENT, null, Disco.Arch.CURRENT);
            if (jdks == null || jdks.isEmpty()) {
                this.log("Failed to find any distros from Disco for " + version + " " + (Object)((Object)OS.CURRENT) + " " + (Object)((Object)Disco.Arch.CURRENT));
                jdks = disco.getPackages(version, OS.CURRENT, null, null);
                if (jdks == null || jdks.isEmpty()) {
                    this.log("Failed to find any distros from Disco for " + version + " " + (Object)((Object)OS.CURRENT));
                    return null;
                }
            }
        }
        this.log("Found " + jdks.size() + " download canidates");
        Disco.Package pkg = jdks.get(0);
        this.log("Selected " + pkg.distribution + ": " + pkg.filename);
        File java_home = disco.extract(pkg);
        if (java_home == null) {
            return null;
        }
        IJavaInstall result = this.fromPath(java_home);
        return result;
    }
}

